package com.elitesland.tw.tw5.server.prd.humanresources.eval.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluateConfigPointPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateConfigPointQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateConfigPointService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateConfigPointVO;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdEvaluateConfigPointConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.dao.PrdEvaluateConfigPointDao;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.entity.PrdEvaluateConfigPointDO;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.repo.PrdEvaluateConfigPointRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import javax.servlet.http.HttpServletResponse;

import com.elitescloud.boot.exception.BusinessException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.collection.CollectionUtil;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.boot.exception.BusinessException;

import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价配置点表Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdEvaluateConfigPointServiceImpl implements PrdEvaluateConfigPointService {


    private final PrdEvaluateConfigPointDao prdEvaluateConfigPointDao;

    private final PrdEvaluateConfigPointRepo prdEvaluateConfigPointRepo;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdEvaluateConfigPointVO save(PrdEvaluateConfigPointPayload prdEvaluateConfigPointPayload) {

        checkData(prdEvaluateConfigPointPayload);
        // 校验名称
        if (null == prdEvaluateConfigPointPayload.getId()) {
            PrdEvaluateConfigPointQuery prdEvaluateConfigPointQuery = new PrdEvaluateConfigPointQuery();
            prdEvaluateConfigPointQuery.setName(prdEvaluateConfigPointPayload.getName());
            Long count = prdEvaluateConfigPointDao.count(prdEvaluateConfigPointQuery);
            if (count > 0) {
                throw new BusinessException("评价点名称已存在");
            }

        }

        PrdEvaluateConfigPointDO prdEvaluateConfigPointDO = new PrdEvaluateConfigPointDO();
        prdEvaluateConfigPointDO = PrdEvaluateConfigPointConvert.INSTANCE.p2d(prdEvaluateConfigPointPayload);
        PrdEvaluateConfigPointDO res = prdEvaluateConfigPointRepo.save(prdEvaluateConfigPointDO);
        return PrdEvaluateConfigPointConvert.INSTANCE.d2v(res);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdEvaluateConfigPointVO update(PrdEvaluateConfigPointPayload prdEvaluateConfigPointPayload) {

        Assert.notNull(prdEvaluateConfigPointPayload.getId(), "id is null");
        PrdEvaluateConfigPointVO prdEvaluateConfigPointVO = get(prdEvaluateConfigPointPayload.getId());
        // 名称不相同
        if (!prdEvaluateConfigPointVO.getName().equals(prdEvaluateConfigPointPayload.getName())) {
            PrdEvaluateConfigPointQuery prdEvaluateConfigPointQuery = new PrdEvaluateConfigPointQuery();
            prdEvaluateConfigPointQuery.setName(prdEvaluateConfigPointPayload.getName());
            Long count = prdEvaluateConfigPointDao.count(prdEvaluateConfigPointQuery);
            if (count > 0) {
                throw new BusinessException("评价点名称已存在");
            }
        }
        PrdEvaluateConfigPointVO res = save(prdEvaluateConfigPointPayload);
        return res;

    }


    @Override
    public PrdEvaluateConfigPointVO get(Long id) {

        if (null == id) {
            return null;
        }
        PrdEvaluateConfigPointVO res = prdEvaluateConfigPointDao.get(id);
        return res;

    }


    @Override
    public PagingVO<PrdEvaluateConfigPointVO> page(PrdEvaluateConfigPointQuery prdEvaluateConfigPointQuery) {

        PagingVO<PrdEvaluateConfigPointVO> res = prdEvaluateConfigPointDao.page(prdEvaluateConfigPointQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdEvaluateConfigPointDao.del(ids);
        return res;

    }

    @Override
    public List<PrdEvaluateConfigPointVO> getList(PrdEvaluateConfigPointQuery prdEvaluateConfigPointQuery) {
        prdEvaluateConfigPointQuery.setState(1);
        List<PrdEvaluateConfigPointVO> res = prdEvaluateConfigPointDao.getList(prdEvaluateConfigPointQuery);
        return res;

    }


    /**
     * 数据校验
     *
     * @param prdEvaluateConfigPointPayload
     */
    private void checkData(PrdEvaluateConfigPointPayload prdEvaluateConfigPointPayload) {

        if (StringUtils.isBlank(prdEvaluateConfigPointPayload.getName())) {
            throw new BusinessException("名称不能为空");
        }
        if (null == prdEvaluateConfigPointPayload.getState()) {
            throw new BusinessException("状态不能为空");
        }
        if (null == prdEvaluateConfigPointPayload.getScoreMin()) {
            throw new BusinessException("分数下限不能为空");
        }
        if (null == prdEvaluateConfigPointPayload.getScoreMax()) {
            throw new BusinessException("分数上限不能为空");
        }


    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateByCondition(PrdEvaluateConfigPointPayload prdEvaluateConfigPointPayload) {
        Assert.notNull(prdEvaluateConfigPointPayload.getId(), "id不能为空");
//        checkData(prdEvaluateConfigPointPayload);
        Long res = prdEvaluateConfigPointDao.update(prdEvaluateConfigPointPayload);
        return res;
    }


}

