package com.elitesland.tw.tw5.server.prd.humanresources.eval.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluateConfigDtlPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluateConfigPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateConfigDtlQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateConfigQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateConfigDtlService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateConfigService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateConfigDtlVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateConfigVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdEvaluateConfigConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.dao.PrdEvaluateConfigDao;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.entity.PrdEvaluateConfigDO;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.repo.PrdEvaluateConfigRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import javax.servlet.http.HttpServletResponse;

import com.elitescloud.boot.exception.BusinessException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.collection.CollectionUtil;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.boot.exception.BusinessException;

import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价配置表Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdEvaluateConfigServiceImpl implements PrdEvaluateConfigService {


    private final PrdEvaluateConfigDao prdEvaluateConfigDao;

    private final PrdEvaluateConfigRepo prdEvaluateConfigRepo;

    private final PrdEvaluateConfigDtlService prdEvaluateConfigDtlService;

    private final CacheUtil cacheUtil;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdEvaluateConfigVO save(PrdEvaluateConfigPayload prdEvaluateConfigPayload) {

        checkData(prdEvaluateConfigPayload);
        PrdEvaluateConfigDO prdEvaluateConfigDO = new PrdEvaluateConfigDO();
        // 评价类别/评价类型
        PrdEvaluateConfigQuery prdEvaluateConfigQuery = new PrdEvaluateConfigQuery();
        prdEvaluateConfigQuery.setCate(prdEvaluateConfigPayload.getCate());
        prdEvaluateConfigQuery.setType(prdEvaluateConfigPayload.getType());
        if (null == prdEvaluateConfigPayload.getId()) {
            Long count = prdEvaluateConfigDao.count(prdEvaluateConfigQuery);
            if (count > 0) {
                throw new BusinessException("已存在评价类别/评价类型的数据,请勿重复添加");
            }
        }

        prdEvaluateConfigDO = PrdEvaluateConfigConvert.INSTANCE.p2d(prdEvaluateConfigPayload);
        PrdEvaluateConfigDO res = prdEvaluateConfigRepo.save(prdEvaluateConfigDO);

        // 配置点集合明细处理
        for (Long pointId : prdEvaluateConfigPayload.getPointIdList()) {
            PrdEvaluateConfigDtlPayload prdEvaluateConfigDtlPayload = new PrdEvaluateConfigDtlPayload();
            prdEvaluateConfigDtlPayload.setPointId(pointId);
            prdEvaluateConfigDtlPayload.setConfigId(res.getId());
            prdEvaluateConfigDtlService.save(prdEvaluateConfigDtlPayload);
        }
        return PrdEvaluateConfigConvert.INSTANCE.d2v(res);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdEvaluateConfigVO update(PrdEvaluateConfigPayload prdEvaluateConfigPayload) {

        Assert.notNull(prdEvaluateConfigPayload.getId(), "id is null");
        Long del = prdEvaluateConfigDtlService.delByConfigId(prdEvaluateConfigPayload.getId());
        PrdEvaluateConfigVO res = save(prdEvaluateConfigPayload);
        return res;

    }


    @Override
    public PrdEvaluateConfigVO get(Long id) {

        if (null == id) {
            return null;
        }
        PrdEvaluateConfigVO res = prdEvaluateConfigDao.get(id);
        PrdEvaluateConfigDtlQuery prdEvaluateConfigDtlQuery = new PrdEvaluateConfigDtlQuery();
        prdEvaluateConfigDtlQuery.setConfigId(id);
        List<PrdEvaluateConfigDtlVO> dtlVOList = prdEvaluateConfigDtlService.getList(prdEvaluateConfigDtlQuery);
        res.setPrdEvaluateConfigDtlVOList(dtlVOList);
        return res;

    }


    @Override
    public PagingVO<PrdEvaluateConfigVO> page(PrdEvaluateConfigQuery prdEvaluateConfigQuery) {

        PagingVO<PrdEvaluateConfigVO> res = prdEvaluateConfigDao.page(prdEvaluateConfigQuery);
        res.getRecords().forEach(x -> {
            x.setTypeDesc(cacheUtil.transferSystemSelection("org:employee:evalClass", x.getType()));
            x.setCateDesc(cacheUtil.transferSystemSelection("org:employee:evalClass", x.getCate()));
        });
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdEvaluateConfigDao.del(ids);
        return res;

    }

    @Override
    public List<PrdEvaluateConfigVO> getList(PrdEvaluateConfigQuery prdEvaluateConfigQuery) {

        List<PrdEvaluateConfigVO> res = prdEvaluateConfigDao.getList(prdEvaluateConfigQuery);
        return res;

    }


    /**
     * 数据校验
     *
     * @param prdEvaluateConfigPayload
     */
    private void checkData(PrdEvaluateConfigPayload prdEvaluateConfigPayload) {

        if (StringUtils.isBlank(prdEvaluateConfigPayload.getCate())) {
            throw new BusinessException("类别不能为空");
        }
        if (StringUtils.isBlank(prdEvaluateConfigPayload.getType())) {
            throw new BusinessException("类型不能为空");
        }
        if (CollUtil.isEmpty(prdEvaluateConfigPayload.getPointIdList())) {
            throw new BusinessException("配置点id集合不能为空");
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateByCondition(PrdEvaluateConfigPayload prdEvaluateConfigPayload) {
        Assert.notNull(prdEvaluateConfigPayload.getId(), "id不能为空");
        Long res = prdEvaluateConfigDao.update(prdEvaluateConfigPayload);
        return res;
    }

    @Override
    public PrdEvaluateConfigVO getByCondition(PrdEvaluateConfigQuery prdEvaluateConfigQuery) {

        PrdEvaluateConfigVO res = prdEvaluateConfigDao.getByCondition(prdEvaluateConfigQuery);
        if (null != res) {
            // 查询明细配置
            PrdEvaluateConfigDtlQuery prdEvaluateConfigDtlQuery = new PrdEvaluateConfigDtlQuery();
            prdEvaluateConfigDtlQuery.setConfigId(res.getId());
            List<PrdEvaluateConfigDtlVO> dtlVOList = prdEvaluateConfigDtlService.getList(prdEvaluateConfigDtlQuery);
            res.setPrdEvaluateConfigDtlVOList(dtlVOList);
        }
        return res;
    }


}

