package com.elitesland.tw.tw5.server.prd.humanresources.examination.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdExamTempPointPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdExamTempPointQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdExamTempPointService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdExamTempPointVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import org.springframework.web.bind.annotation.*;
import java.util.Arrays;


/**
 * @author : WWW
 * @date : 2023-11-13
 * @desc : 绩效考核模板-绩效考核点
 */

@RestController
@RequestMapping("/api/prdExamTempPoint")
@RequiredArgsConstructor
@Api(value = "绩效考核模板-绩效考核点", tags = {"绩效考核模板-绩效考核点"})
public class PrdExamTempPointController{
    
    private final PrdExamTempPointService prdExamTempPointService;
    
    
    @GetMapping("get/{id}")
    @ApiOperation("详情-绩效考核模板-绩效考核点")
    public TwOutputUtil<PrdExamTempPointVO> get(@PathVariable Long id) {
    
        PrdExamTempPointVO res = prdExamTempPointService.get(id);
        return TwOutputUtil.ok(res);
        
    }
    
    
    @PostMapping("save")
    @ApiOperation("新增-绩效考核模板-绩效考核点")
    public TwOutputUtil<Long> save(@RequestBody PrdExamTempPointPayload prdExamTempPointPayload) {
        
        PrdExamTempPointVO res = prdExamTempPointService.save(prdExamTempPointPayload);
        return TwOutputUtil.ok(res.getId());
        
    }
    
    
    @PostMapping("update")
    @ApiOperation("修改-绩效考核模板-绩效考核点")
    public TwOutputUtil<Long> update(@RequestBody PrdExamTempPointPayload prdExamTempPointPayload) {
        
        PrdExamTempPointVO res = prdExamTempPointService.update(prdExamTempPointPayload);
        return TwOutputUtil.ok(res.getId());
        
    }
    
    
    @DeleteMapping("del")
    @ApiOperation("删除-绩效考核模板-绩效考核点")
    public TwOutputUtil<Long> del(Long[] ids) {
    
        Long res = prdExamTempPointService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);
        
    }
    
    
    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-绩效考核模板-绩效考核点")
    public TwOutputUtil<PagingVO<PrdExamTempPointVO>> page(PrdExamTempPointQuery prdExamTempPointQuery) {
        
        PagingVO<PrdExamTempPointVO> res = prdExamTempPointService.page(prdExamTempPointQuery);
        return TwOutputUtil.ok(res);
        
    }
    
    
    
}

