package com.elitesland.tw.tw5.server.prd.humanresources.examination.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamResultPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamGradeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamPointQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamResultQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.*;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.*;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.base.HrBaseEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdPerformanceExamConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.dao.PrdPerformanceExamDao;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdPerformanceExamDO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.repo.PrdPerformanceExamRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-14
 * @desc : 绩效考核Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdPerformanceExamServiceImpl implements PrdPerformanceExamService {


    private final PrdPerformanceExamDao prdPerformanceExamDao;

    private final PrdPerformanceExamRepo prdPerformanceExamRepo;

    private final PrdPerformanceExamPointService prdPerformanceExamPointService;

    private final PrdPerformanceExamGradeService prdPerformanceExamGradeService;

    private final PrdPerformanceExamRelateService prdPerformanceExamRelateService;

    @Autowired
    @Lazy
    private PrdPerformanceExamRangeService prdPerformanceExamRangeService;

    private final PrdPerformanceExamResultService prdPerformanceExamResultService;

    private final PrdPerformanceExamResDtlService prdPerformanceExamResDtlService;

    private final PrdOrgOrganizationService prdOrgOrganizationService;

    private final PrdSystemRoleDAO prdSystemRoleDAO;

    private final PrdOrgEmployeeDAO prdOrgEmployeeDAO;

    private final WorkflowUtil workflowUtil;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdPerformanceExamVO save(PrdPerformanceExamPayload prdPerformanceExamPayload) {

        checkData(prdPerformanceExamPayload);

        PrdPerformanceExamDO prdPerformanceExamDO = new PrdPerformanceExamDO();
        prdPerformanceExamDO = PrdPerformanceExamConvert.INSTANCE.p2d(prdPerformanceExamPayload);
        PrdPerformanceExamDO res = prdPerformanceExamRepo.save(prdPerformanceExamDO);

        // 考核点
        prdPerformanceExamPayload.getPrdPerformanceExamPointPayloadList().forEach(x -> {
            x.setExamId(res.getId());
            prdPerformanceExamPointService.save(x);
        });
        // 考核等级
        prdPerformanceExamPayload.getPrdPerformanceExamGradePayloadList().forEach(x -> {
            x.setExamId(res.getId());
            prdPerformanceExamGradeService.save(x);
        });
        // 可查看考核明细 （我参与的流程中进行查看）
//        prdPerformanceExamPayload.getPrdPerformanceExamRelatePayloadList().forEach(x -> {
//            x.setExamId(res.getId());
//            prdPerformanceExamRelateService.save(x);
//        });
        // 考核范围
        prdPerformanceExamPayload.getPrdPerformanceExamRangePayloadList().forEach(x -> {
            x.setExamId(res.getId());
            PrdPerformanceExamRangeVO save = prdPerformanceExamRangeService.save(x);

        });

        return PrdPerformanceExamConvert.INSTANCE.d2v(res);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdPerformanceExamVO update(PrdPerformanceExamPayload prdPerformanceExamPayload) {

        Assert.notNull(prdPerformanceExamPayload.getId(), "id is null");
        // 考核点
        prdPerformanceExamPointService.delByExamId(prdPerformanceExamPayload.getId());
        // 考核等级
        prdPerformanceExamGradeService.delByExamId(prdPerformanceExamPayload.getId());
        // 考核范围
//        prdPerformanceExamRangeService.delByExamId(prdPerformanceExamPayload.getId());

        PrdPerformanceExamVO res = save(prdPerformanceExamPayload);
        return res;

    }


    @Override
    public PrdPerformanceExamVO get(Long id) {

        if (null == id) {
            return null;
        }
        PrdPerformanceExamVO res = prdPerformanceExamDao.get(id);
        // 可查看明细人
//        PrdPerformanceExamRelateQuery prdPerformanceExamRelateQuery = new PrdPerformanceExamRelateQuery();
//        prdPerformanceExamRelateQuery.setExamId(id);
//        List<PrdPerformanceExamRelateVO> relateVOList = prdPerformanceExamRelateService.getList(prdPerformanceExamRelateQuery);
//        res.setPrdPerformanceExamRelateVOList(relateVOList);
        // 考核点
        PrdPerformanceExamPointQuery prdPerformanceExamPointQuery = new PrdPerformanceExamPointQuery();
        prdPerformanceExamPointQuery.setExamId(id);
        List<PrdPerformanceExamPointVO> pointVOList = prdPerformanceExamPointService.getList(prdPerformanceExamPointQuery);
        res.setPrdPerformanceExamPointVOList(pointVOList);
        // 考核结果等级
        PrdPerformanceExamGradeQuery prdPerformanceExamGradeQuery = new PrdPerformanceExamGradeQuery();
        prdPerformanceExamGradeQuery.setExamId(id);
        List<PrdPerformanceExamGradeVO> gradeVOList = prdPerformanceExamGradeService.getList(prdPerformanceExamGradeQuery);
        res.setPrdPerformanceExamGradeVOList(gradeVOList);
        //
        return res;

    }


    @Override
    public PagingVO<PrdPerformanceExamVO> page(PrdPerformanceExamQuery prdPerformanceExamQuery) {

        PagingVO<PrdPerformanceExamVO> res = prdPerformanceExamDao.page(prdPerformanceExamQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdPerformanceExamDao.del(ids);
        return res;

    }

    @Override
    public List<PrdPerformanceExamVO> getList(PrdPerformanceExamQuery prdPerformanceExamQuery) {

        List<PrdPerformanceExamVO> res = prdPerformanceExamDao.getList(prdPerformanceExamQuery);
        return res;

    }


    /**
     * 数据校验
     *
     * @param prdPerformanceExamPayload
     */
    private void checkData(PrdPerformanceExamPayload prdPerformanceExamPayload) {

        if (StringUtils.isBlank(prdPerformanceExamPayload.getName())) {
            throw new BusinessException("考核名称不能为空");
        }
        if (StringUtils.isBlank(prdPerformanceExamPayload.getCycle())) {
            throw new BusinessException("考核周期不能为空");
        }
        if (null == (prdPerformanceExamPayload.getScoreMax())) {
            throw new BusinessException("分数上限不能为空");
        }
        if (null == (prdPerformanceExamPayload.getScoreMin())) {
            throw new BusinessException("分数下限不能为空");
        }


    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateByCondition(PrdPerformanceExamPayload prdPerformanceExamPayload) {
        Assert.notNull(prdPerformanceExamPayload.getId(), "id不能为空");
        Long res = prdPerformanceExamDao.update(prdPerformanceExamPayload);
        return res;
    }

    @Override
    public Long startflow(PrdPerformanceExamPayload prdPerformanceExamPayload) {
        // 新增绩效考核结果
        PrdPerformanceExamVO prdPerformanceExamVO = prdPerformanceExamDao.get(prdPerformanceExamPayload.getId());
        // 绩效考核范围
        PrdPerformanceExamResultQuery prdPerformanceExamResultQuery = new PrdPerformanceExamResultQuery();
        prdPerformanceExamResultQuery.setExamId(prdPerformanceExamPayload.getId());
        List<PrdPerformanceExamResultVO> resultVOList = prdPerformanceExamResultService.getList(prdPerformanceExamResultQuery);
        for (PrdPerformanceExamResultVO prdPerformanceExamResultVO : resultVOList) {
            // 发起工作流程
            startWorkFlow(prdPerformanceExamResultVO, prdPerformanceExamVO.getName());
        }
        // 绩效考核 状态变成进行中
        PrdPerformanceExamPayload payload = new PrdPerformanceExamPayload();
        payload.setId(prdPerformanceExamVO.getId());
        payload.setState(String.valueOf(1));
        this.updateByCondition(payload);
        return prdPerformanceExamVO.getId();
    }

    public void startWorkFlow(PrdPerformanceExamResultVO res, String name) {
        // 启动工作流
        HashMap<String, Object> variables = new HashMap<>();

//            PrdPerformanceExamRelateQuery prdPerformanceExamRelateQuery = new PrdPerformanceExamRelateQuery();
//            prdPerformanceExamRelateQuery.setRoleType("ASSIGN");
//            prdPerformanceExamRelateQuery.setExamId(prdPerformanceExamPayload.getId());
//            List<PrdPerformanceExamRelateVO> relateVOList = prdPerformanceExamRelateService.getList(prdPerformanceExamRelateQuery);
//            if (CollectionUtil.isNotEmpty(relateVOList)) {
//                List<Long> relateUserList = relateVOList.stream().map(x -> x.getResId()).collect(Collectors.toList());
//                // 指定资源
//                variables.put("Activity_1afn123", relateUserList);
//            }
        // 资源自评
        variables.put("Activity_1afn3zj", res.getUserId());
        // 直属领导评价
        PrdOrgEmployeeRefDO prdOrgEmployeeRefDO = prdOrgEmployeeDAO.queryByOrgIdAndUserId(res.getBaseBuId(), res.getUserId());
        if (null != prdOrgEmployeeRefDO) {
            variables.put("Activity_19d0izo", prdOrgEmployeeRefDO.getParentId());
        }
        // 资源经理评价 RESOURCE_MANAGER

        List<Long> zyUserIds = prdSystemRoleDAO.queryUserIdByRoleCodes(List.of(RoleEnum.PLAT_RESOURCE_DIRECTOR.getCode()));
        variables.put("Activity_1hrp7lh", zyUserIds);

        // Bu负责人评价
        PrdOrgOrganizationVO prdOrgOrganizationVO = prdOrgOrganizationService.queryDetailSimpleByOrgId(res.getBaseBuId());

        variables.put("Activity_1co4fc9", prdOrgOrganizationVO.getManageId());
        // HR组织评价  PLAT_SALARY_MANAGER
        List<Long> hrUserIds = prdSystemRoleDAO.queryUserIdByRoleCodes(List.of(RoleEnum.PLAT_SALARY_MANAGER.getCode()));
        variables.put("Activity_0i5l378", hrUserIds);

        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                HrBaseEnum.PERFORMANCE_EXAM.getCode(),
                "A113.绩效考核流程-" + name,
                res.getId().toString(),
                variables));
        String procInstId = processInfo.getProcInstId();
        ProcInstStatus procInstStatus = processInfo.getProcInstStatus();

        PrdPerformanceExamResultPayload payload = new PrdPerformanceExamResultPayload();
        payload.setId(res.getId());
        // 流程编号
//            payload.setFlowDocNo();
        payload.setProcInstId(procInstId);
        payload.setProcInstStatus(procInstStatus);
        payload.setState(ProcInstStatus.APPROVING.name());
        prdPerformanceExamResultService.updateByCondition(payload);
    }


}

