package com.elitesland.tw.tw5.server.prd.inv.service;


import com.elitesland.tw.tw5.api.prd.inv.payload.InvInvoiceTravelItineraryPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceTravelItineraryQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceTravelItineraryService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceTravelItineraryVO;
import com.elitesland.tw.tw5.server.prd.inv.convert.InvInvoiceTravelItineraryConvert;
import com.elitesland.tw.tw5.server.prd.inv.dao.InvInvoiceTravelItineraryDAO;
import com.elitesland.tw.tw5.server.prd.inv.entity.InvInvoiceTravelItineraryDO;
import com.elitesland.tw.tw5.server.prd.inv.repo.InvInvoiceTravelItineraryRepo;
import org.springframework.stereotype.Service;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 发票行程单
 *
 * @author zoey
 * @date 2023-12-05
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class InvInvoiceTravelItineraryServiceImpl extends BaseServiceImpl implements InvInvoiceTravelItineraryService {

    private final InvInvoiceTravelItineraryRepo invInvoiceTravelItineraryRepo;
    private final InvInvoiceTravelItineraryDAO invInvoiceTravelItineraryDAO;

    @Override
    public PagingVO<InvInvoiceTravelItineraryVO> queryPaging(InvInvoiceTravelItineraryQuery query){
        return invInvoiceTravelItineraryDAO.queryPaging(query);
    }

    @Override
    public List<InvInvoiceTravelItineraryVO> queryListDynamic(InvInvoiceTravelItineraryQuery query){
        return invInvoiceTravelItineraryDAO.queryListDynamic(query);
    }

    @Override
    public InvInvoiceTravelItineraryVO queryByKey(Long key) {
        InvInvoiceTravelItineraryDO entity = invInvoiceTravelItineraryRepo.findById(key).orElseGet(InvInvoiceTravelItineraryDO::new);
        Assert.notNull(entity.getId(), "不存在");
        InvInvoiceTravelItineraryVO vo = InvInvoiceTravelItineraryConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public InvInvoiceTravelItineraryVO insert(InvInvoiceTravelItineraryPayload payload) {
        InvInvoiceTravelItineraryDO entityDo = InvInvoiceTravelItineraryConvert.INSTANCE.toDo(payload);
        return InvInvoiceTravelItineraryConvert.INSTANCE.toVo(invInvoiceTravelItineraryRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public InvInvoiceTravelItineraryVO update(InvInvoiceTravelItineraryPayload payload) {
        InvInvoiceTravelItineraryDO entity = invInvoiceTravelItineraryRepo.findById(payload.getId()).orElseGet(InvInvoiceTravelItineraryDO::new);
        Assert.notNull(entity.getId(), "不存在");
        InvInvoiceTravelItineraryDO entityDo = InvInvoiceTravelItineraryConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return InvInvoiceTravelItineraryConvert.INSTANCE.toVo(invInvoiceTravelItineraryRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(InvInvoiceTravelItineraryPayload payload) {
        InvInvoiceTravelItineraryDO entity = invInvoiceTravelItineraryRepo.findById(payload.getId()).orElseGet(InvInvoiceTravelItineraryDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = invInvoiceTravelItineraryDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            invInvoiceTravelItineraryDAO.deleteSoft(keys);
        }
    }

}
