package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.math.BigDecimal;

/**
 * 远程办公申请明细
 *
 * @author wangly
 * @date 2024-06-12
 */
@Entity
@Table(name = "abnormal_work_apply_detail", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "abnormal_work_apply_detail", comment = "远程办公申请明细")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AbnormalWorkApplyDetailDO extends BaseModel implements Serializable  {
    /** 远程办公申请ID */
    @Comment("远程办公申请ID")
    @Column()
    private Long applyId;
    /** 月份 */
    @Comment("月份")
    @Column()
    private String workMonth;
    /** 远程办公日期 */
    @Comment("远程办公日期")
    @Column()
    private LocalDate workDate;
    /** 远程办公天数 */
    @Comment("远程办公天数")
    @Column()
    private BigDecimal workDays;
    /** 0.5天区分上午下午 AM上午 PM下午 */
    @Comment("0.5天区分上午下午 AM上午 PM下午")
    @Column()
    private String workInterval;
    /** 流程实例ID */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /** 流程审批状态 */
    @Comment("流程审批状态")
    @Column()
    private String procInstStatus;
    /** 审批时间 */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    public void copy(AbnormalWorkApplyDetailDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
