package com.elitesland.tw.tw5.server.prd.my.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.time.LocalDate;

@Entity
@Table(name = "t_attendance_normal_date_special", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_attendance_normal_date_special", comment = "特殊打卡工作日表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TAttendanceNormalDateSpecialDO extends BaseModel {

    @Comment("规则ID")
    @Column()
    private Long attendanceRuleId;

    @Comment("打卡日期")
    @Column()
    private LocalDate attendanceDate;

    @Comment("需要必须打卡")
    @Column()
    private String needAttendanceFlg;

    @Comment("特殊打卡原因")
    @Column()
    private String specialReason;

    @Comment("上班时间")
    @Column()
    private String attendanceTimeStart;

    @Comment("下班时间")
    @Column()
    private String attendanceTimeEnd;

}
