package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 自购电脑申请
 *
 * @author lemon
 * @date 2023-09-19
 */
@Entity
@Table(name = "t_device_apply", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_device_apply", comment = "自购电脑申请")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TDeviceApplyDO extends BaseModel implements Serializable  {
    /** 申请单号 */
    @Comment("申请单号")
    @Column()
    private String applyNo;
    /** 申请状态 */
    @Comment("申请状态")
    @Column()
    private String applyStatus;
    /** 申请日期 */
    @Comment("申请日期")
    @Column()
    private LocalDate applyDate;
    /** 申请人资源ID */
    @Comment("申请人资源ID")
    @Column()
    private Long applyResId;
    /** 每月补贴金额 */
    @Comment("每月补贴金额")
    @Column()
    private BigDecimal monthlyAmt;
    /** 票据号 */
    @Comment("票据号")
    @Column()
    private String billNo;
    /** 品牌型号及颜色 */
    @Comment("品牌型号及颜色")
    @Column()
    private String deviceDesc;
    /** 内存 */
    @Comment("内存")
    @Column()
    private String memSize;
    /** 硬盘 */
    @Comment("硬盘")
    @Column()
    private String hdSize;
    /** 购置价格 */
    @Comment("购置价格")
    @Column()
    private BigDecimal devicePrice;
    /** 购置日期 */
    @Comment("购置日期")
    @Column()
    private LocalDate buyDate;
    /** 补贴起始月份 */
    @Comment("补贴起始月份")
    @Column()
    private Integer startPeriodId;
    /** 申请理由 */
    @Comment("申请理由")
    @Column()
    private String applyDesc;
    /** 申请人BU_ID */
    @Comment("申请人BU_ID")
    @Column()
    private Long resBuId;

    /** 附件 */
    @Comment("附件")
    @Column()
    private String fileCode;

    /** 流程实例ID */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /** 流程审批状态 */
    @Comment("流程审批状态")
    @Column()
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    /** 审批时间 */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    public void copy(TDeviceApplyDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
