package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 服务器申请
 *
 * @author lemon
 * @date 2023-09-23
 */
@Entity
@Table(name = "t_server_apply", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_server_apply", comment = "服务器申请")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TServerApplyDO extends BaseModel implements Serializable  {
    /** 申请人 */
    @Comment("申请人")
    @Column()
    private Long applyResId;
    /** 申请时间 */
    @Comment("申请时间")
    @Column()
    private LocalDate applyDate;
    /** 申请bu */
    @Comment("申请bu")
    @Column()
    private Long applyBuId;
    /** 使用人姓名 */
    @Comment("使用人姓名")
    @Column()
    private Long userResId;
    /** 使用bu */
    @Comment("使用bu")
    @Column()
    private Long userBuId;
    /** 用途 */
    @Comment("用途")
    @Column()
    private String purpose;
    /** 服务器类型 */
    @Comment("服务器类型")
    @Column()
    private String type;
    /** 服务器品牌 */
    @Comment("服务器品牌")
    @Column()
    private String brand;
    /** 使用范围 */
    @Comment("使用范围")
    @Column()
    private String useScope;
    /** 预计费用 */
    @Comment("预计费用")
    @Column()
    private BigDecimal expectAmt;
    /** 费用承担bu */
    @Comment("费用承担bu")
    @Column()
    private Long expenseBuId;
    /** CPU */
    @Comment("CPU")
    @Column()
    private String cpu;
    /** 内存 */
    @Comment("内存")
    @Column()
    private String memory;
    /** 硬盘 */
    @Comment("硬盘")
    @Column()
    private String hardDisk;
    /** 系统类型 */
    @Comment("系统类型")
    @Column()
    private String sysType;
    /** 生效日期 */
    @Comment("生效日期")
    @Column()
    private LocalDate effectiveDate;
    /** 使用日期开始 */
    @Comment("使用日期开始")
    @Column()
    private LocalDate useDateStart;
    /** 使用日期结束 */
    @Comment("使用日期结束")
    @Column()
    private LocalDate useDateEnd;
    /** 采购合同id */
    @Comment("采购合同id")
    @Column()
    private Long purchaseConId;
    /** 申请编号 */
    @Comment("申请编号")
    @Column()
    private String applyNo;
    /** 申请状态 */
    @Comment("申请状态")
    @Column()
    private String applyStatus;
    /** 服务器名称 */
    @Comment("服务器名称")
    @Column()
    private String serverName;
    /** 流程实例ID */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /** 流程审批状态 */
    @Comment("流程审批状态")
    @Column()
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    /** 审批时间 */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    public void copy(TServerApplyDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
