package com.elitesland.tw.tw5.server.prd.my.service;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.ResActivityPayload;
import com.elitesland.tw.tw5.api.prd.my.query.ResActivityQuery;
import com.elitesland.tw.tw5.api.prd.my.service.ResActivityService;
import com.elitesland.tw.tw5.api.prd.my.vo.ResActivityVO;
import com.elitesland.tw.tw5.api.prd.my.vo.ResProjectActivityVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectActivityService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectActivityVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.FileUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.ResActivityConvert;
import com.elitesland.tw.tw5.server.prd.my.entity.ResActivityDO;
import com.elitesland.tw.tw5.server.prd.my.repo.ResActivityRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.sf.cglib.core.Local;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;

/**
 * 工时-资源活动
 *
 * @author duh
 * @date 2022-12-21
 */
@Service
@RequiredArgsConstructor
@Slf4j
@Deprecated
public class ResActivityServiceImpl implements ResActivityService {

    private final ResActivityRepo resActivityRepo;
    private final HttpUtil httpUtil;
    @Value("${tw5.findProjectActivityByProjId4Url:/api/openReport/v1/projActivity/findProjActivityByProjectv4}")
    private String findProjectActivityByProjId4Url;
    private PmsProjectActivityService pmsProjectActivityService;

    @Override
    public PagingVO<ResActivityVO> paging(ResActivityQuery query) {
        Page<ResActivityDO> page = resActivityRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(ResActivityConvert.INSTANCE::toVo));
    }

    @Override
    public List<ResActivityVO> queryList(ResActivityQuery query) {
        return ResActivityConvert.INSTANCE.toVoList(resActivityRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Override
    public ResActivityVO queryByKey(Long key) {
        ResActivityDO entity = resActivityRepo.findById(key).orElseGet(ResActivityDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ResActivityVO vo = ResActivityConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResActivityVO insert(ResActivityPayload payload) {
        ResActivityDO entityDo = ResActivityConvert.INSTANCE.toDo(payload);
        return ResActivityConvert.INSTANCE.toVo(resActivityRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResActivityVO update(ResActivityPayload payload) {
        ResActivityDO entity = resActivityRepo.findById(payload.getId()).orElseGet(ResActivityDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ResActivityDO entityDo = ResActivityConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ResActivityConvert.INSTANCE.toVo(resActivityRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            resActivityRepo.deleteSoft(keys);
        }
    }

    @Override
    public void download(List<ResActivityVO> all, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> list = new ArrayList<>();
        for (ResActivityVO resActivity : all) {
            Map<String, Object> map = new LinkedHashMap<>();
            map.put("4.0活动主键", resActivity.getActivityIdV4());
            map.put("活动编号", resActivity.getActNo());
            map.put("活动名称", resActivity.getActName());
            map.put("活动状态", resActivity.getActStatus());
            map.put("活动资源id", resActivity.getActResId());
            map.put("项目活动", resActivity.getProjAct());
            map.put("预计开始日期", resActivity.getPlanStartDate());
            map.put("预计结束日期", resActivity.getPlanEndDate());
            map.put("实际开始日期", resActivity.getActualStartDate());
            map.put("活动当量", resActivity.getEqvaQty());
            map.put("已结算当量", resActivity.getSettledEqva());
            map.put("是否里程碑", resActivity.getMilestoneFlag());
            map.put("完工日期", resActivity.getFinishDate());
            map.put("完工说明", resActivity.getFinishDesc());
            map.put("完工百分比", resActivity.getFinishRate());
            map.put("要求文档清单", resActivity.getRequiredDocList());
            map.put("任务id 4.0", resActivity.getTaskId());
            map.put("项目活动id", resActivity.getProjActivityId());
            map.put("资源活动父id", resActivity.getResActivityPid());
            map.put("规划当量", resActivity.getPlanEqva());
            map.put("结算状态", resActivity.getSettleStatus());
            map.put("审批状态", resActivity.getApprStatus());
            map.put("拓展1", resActivity.getExt1());
            map.put("拓展2", resActivity.getExt2());
            map.put("拓展3", resActivity.getExt3());
            map.put("拓展4", resActivity.getExt4());
            map.put("拓展5", resActivity.getExt5());
            list.add(map);
        }
        FileUtil.downloadExcel(list, response);
    }

    @Override
    public Map<Long, Long> getV4AndV5ActivityIds() {
        Map<Long, Long> result = new HashMap<>();
        ResActivityQuery query = new ResActivityQuery();
        final List<ResActivityVO> resActivityVOS = queryList(query);
        for (ResActivityVO resActivityVO : resActivityVOS) {
            result.put(resActivityVO.getActivityIdV4(), resActivityVO.getId());
        }
        return result;
    }

    @Override
    public ResActivityVO queryByActivityIdV4(Long actId) {
        ResActivityDO entity = resActivityRepo.getByActivityIdV4(actId);
        Assert.notNull(entity, "活动不存在");
        ResActivityVO vo = ResActivityConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    public List<ResProjectActivityVO> selectActivityByDefaultTask(Long projId, String workDate) {
        List<PmsProjectActivityVO> pmsProjectActivityVOS = pmsProjectActivityService.querySimpleActiveList(projId);
        LocalDate workDateLocalDate = LocalDate.parse(workDate);
        List<PmsProjectActivityVO> resultList = new ArrayList<>();
        for (PmsProjectActivityVO pmsProjectActivityVO : pmsProjectActivityVOS) {
            if(pmsProjectActivityVO.getStartDate() !=null  && pmsProjectActivityVO.getEndDate() != null
                    && (workDateLocalDate.isAfter(pmsProjectActivityVO.getStartDate()) || workDateLocalDate.isEqual(pmsProjectActivityVO.getStartDate()))
                    && (workDateLocalDate.isBefore(pmsProjectActivityVO.getEndDate()) || workDateLocalDate.isEqual(pmsProjectActivityVO.getEndDate()))
            ){
                resultList.add(pmsProjectActivityVO);
            }
        }
        List<ResProjectActivityVO> resProjectActivityVOS = new ArrayList<>();
        if(!ObjectUtils.isEmpty(resultList)){
            for(PmsProjectActivityVO activityVO : resultList){
                ResProjectActivityVO resProjectActivityVO = new ResProjectActivityVO();
                resProjectActivityVO.setId(String.valueOf(activityVO.getId()));
                resProjectActivityVO.setActNo(activityVO.getActNo());
                resProjectActivityVO.setActName(activityVO.getActName());
                resProjectActivityVO.setStartDate(activityVO.getStartDate()== null ? null : activityVO.getStartDate());
                resProjectActivityVO.setEndDate(activityVO.getEndDate()==null ? null : activityVO.getEndDate());
                resProjectActivityVOS.add(resProjectActivityVO);
            }
        }
        return resProjectActivityVOS;
//        Map<String, Object> paramMap = new HashMap<>();
//        paramMap.put("projIdV4", projId);
//        paramMap.put("workDate", workDate);
//        String result = httpUtil.sendSyncGet(findProjectActivityByProjId4Url, paramMap);
//        Map<String, Object> data = (Map) JSONObject.parse(result);
//
//        List<ResProjectActivityVO> resultList = new ArrayList<>();
//        if ((data.get("ok") + "").equals("true")) {
//            if (!ObjectUtils.isEmpty(data.get("datum"))) {
//                List<Map<String, Object>> resActivityList = (List<Map<String, Object>>) data.get("datum");
//                for(Map<String, Object> map : resActivityList){
//                    ResProjectActivityVO resProjectActivityVO = new ResProjectActivityVO();
//                    resProjectActivityVO.setId(String.valueOf(map.get("id")));
//                    resProjectActivityVO.setActNo((String)map.get("actNo"));
//                    resProjectActivityVO.setActName((String)map.get("actName"));
//                    resProjectActivityVO.setStartDate(map.get("startDate")== null ? null : LocalDate.parse(String.valueOf(map.get("startDate")), DateTimeFormatter.ofPattern("yyyy-MM-dd")));
//                    resProjectActivityVO.setEndDate(map.get("endDate")==null ? null : LocalDate.parse(String.valueOf(map.get("endDate")), DateTimeFormatter.ofPattern("yyyy-MM-dd")));
//                    resultList.add(resProjectActivityVO);
//                }
//            }
//        }
//
//        return resultList;
    }
}
