package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.tw.tw5.api.prd.my.payload.TDeviceApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TDeviceApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TDeviceApplyService;
import com.elitesland.tw.tw5.api.prd.my.vo.TDeviceApplyVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgRoleVO;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.TDeviceApplyConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TDeviceApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TDeviceApplyDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TDeviceApplyRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

/**
 * 自购电脑申请
 *
 * @author lemon
 * @date 2023-09-19
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TDeviceApplyServiceImpl implements TDeviceApplyService {

    private final TDeviceApplyRepo tDeviceApplyRepo;
    private final TDeviceApplyDAO tDeviceApplyDAO;

    private final FileUtil fileUtil;
    private final CacheUtil cacheUtil;
    @Value("${tw5.workflow.enabled}")
    private Boolean workflow_enabled;

    @Value("${tw5.workflow.orgId}")
    private Long workflow_orgId;

    private final PrdOrgOrganizationDAO daoOrg;

    private final TransactionUtilService transactionUtilService;

    private final WorkflowUtil workflowUtil;

    @Override
    public PagingVO<TDeviceApplyVO> queryPaging(TDeviceApplyQuery query){
        PagingVO<TDeviceApplyVO> paging = tDeviceApplyDAO.queryPaging(query);
        return paging;
    }

    @Override
    public List<TDeviceApplyVO> queryListDynamic(TDeviceApplyQuery query){
        return tDeviceApplyDAO.queryListDynamic(query);
    }

    @Override
    public TDeviceApplyVO queryByKey(Long key) {
        TDeviceApplyVO vo = tDeviceApplyDAO.queryByKey(key);
        vo.setFileData(fileUtil.getFileDatas(vo.getFileCode()));
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TDeviceApplyVO insert(TDeviceApplyPayload payload) {
        payload.setApplyDate(LocalDate.now());
        TDeviceApplyDO entityDo = TDeviceApplyConvert.INSTANCE.toDo(payload);
        TDeviceApplyDO save = tDeviceApplyRepo.save(entityDo);
        if (payload.getSubmit() != null && payload.getSubmit()) {
            deviceApplyProc(save);
        }
        return TDeviceApplyConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TDeviceApplyVO update(TDeviceApplyPayload payload) {
        TDeviceApplyDO entity = tDeviceApplyRepo.findById(payload.getId()).orElseGet(TDeviceApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TDeviceApplyDO entityDo = TDeviceApplyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        TDeviceApplyDO save = tDeviceApplyRepo.save(entity);
        if (!StringUtils.hasText(entity.getProcInstId())) {
            deviceApplyProcByUpdate(entity);
        }
        return TDeviceApplyConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TDeviceApplyPayload payload) {
        TDeviceApplyDO entity = tDeviceApplyRepo.findById(payload.getId()).orElseGet(TDeviceApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = tDeviceApplyDAO.updateByKeyDynamic(payload);
        if (payload.getSubmit() != null && payload.getSubmit()) {
            deviceApplyProcByUpdate(entity);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            tDeviceApplyDAO.deleteSoft(keys);
        }
    }


    /**
     * 权限申请流程
     *
     * @param deviceApplyDO
     */
    private void deviceApplyProc(TDeviceApplyDO deviceApplyDO) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.CREATE_WORK.getCode();
        if (workflow_enabled) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, Object> variables = new HashMap<>();

            //获取申请人
            Long applyResId = deviceApplyDO.getApplyResId();
            String applyResName = cacheUtil.getUserName(applyResId);
            // 申请人bu负责人
            Long planOrgManageUserId = daoOrg.queryManageIdById(deviceApplyDO.getResBuId());
            variables.put("Activity_1qf9o2s", planOrgManageUserId);
            // 平台IT负责人
            List<PrdOrgRoleVO> prdOrgRoleVOS = daoOrg.queryRoleList(workflow_orgId);
            Optional<PrdOrgRoleVO> optional = prdOrgRoleVOS.stream().filter(e -> "PLAT_IT_ADMIN".equals(e.getRoleCode())).findFirst();
            if (!optional.isPresent()) {
                throw new BusinessException("平台IT负责人角色不存在！");
            }
            PrdOrgRoleVO prdOrgRoleVO = optional.get();
            String[] split = prdOrgRoleVO.getRoleEmployees().split(",");
            variables.put("Activity_15lageb", Arrays.asList(split));

            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.SELF_PUR_COMPUTER.name(),
                    applyResName + "-自购电脑申请流程",
                    deviceApplyDO.getId() + "",
                    variables)
            );
        }
        //流程启动成功后，回写业务表数据
        TDeviceApplyPayload payload = new TDeviceApplyPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(deviceApplyDO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setApplyStatus(status);
        payload.setApplyNo(String.valueOf(deviceApplyDO.getId()));
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            tDeviceApplyDAO.updateByKeyDynamic(payload);
        });
    }
    /**
     * 权限申请流程
     *
     * @param deviceApplyDO
     */
    private void deviceApplyProcByUpdate(TDeviceApplyDO deviceApplyDO) {

        if (workflow_enabled) {
            HashMap<String, Object> variables = new HashMap<>();

            //获取申请人
            Long applyResId = deviceApplyDO.getApplyResId();
            String applyResName = cacheUtil.getUserName(applyResId);
            // 申请人bu负责人
            Long planOrgManageUserId = daoOrg.queryManageIdById(deviceApplyDO.getResBuId());
            variables.put("Activity_1qf9o2s", planOrgManageUserId);
            // 平台IT负责人
            List<PrdOrgRoleVO> prdOrgRoleVOS = daoOrg.queryRoleList(workflow_orgId);
            Optional<PrdOrgRoleVO> optional = prdOrgRoleVOS.stream().filter(e -> "PLAT_IT_ADMIN".equals(e.getRoleCode())).findFirst();
            if (!optional.isPresent()) {
                throw new BusinessException("平台IT负责人角色不存在！");
            }
            PrdOrgRoleVO prdOrgRoleVO = optional.get();
            String[] split = prdOrgRoleVO.getRoleEmployees().split(",");
            variables.put("Activity_15lageb", Arrays.asList(split));
            SetVariablesPayload payload = new SetVariablesPayload();
            payload.setProcInstId(deviceApplyDO.getProcInstId());
            payload.setVariables(variables);
            workflowUtil.setVaribales(payload);
        }
    }
}
