package com.elitesland.tw.tw5.server.prd.my.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RestStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @BelongsProject: tw-svr5
 * @BelongsPackage: com.elitesland.tw.tw5.server.prd.my.vo
 * @Author: dragonHuang
 * @CreateTime: 2023-08-30  13:44
 * @Description: TODO
 * @Version: 1.0
 */
@Data
public class OvertimeApplicationVO extends BaseViewModel {

    /**
     * 工作流实例id
     */
    private String processInstanceId;

    /**
     * 项目id
     */
    private Long projectId;

    // 项目名称
    private String projectName;

    // 任务id
    private Long taskId;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 用户名
     **/
    private String userName;

    /**
     * 工作加班日期
     */
    private LocalDate overtimeWorkDate;

    /**
     * 工时
     */
    private BigDecimal overtimeWorkHour;

    /**
     * 加班工作说明
     */
    private String overtimeWorkDesc;

    // 审批状态
    private String approveStatus;

    /**
     * 调休日期
     */
    private LocalDate restDate;

    // 调休状态
    private String restStatus;

    public String getApproveStatusName(){
        for (WorkFlowStatusEnum value : WorkFlowStatusEnum.values()) {
            if (value.getCode().equals(approveStatus)){
                return value.getDesc();
            }
        }
        return null;
    }

    public String getRestStatusName(){
        for (RestStatusEnum value : RestStatusEnum.values()) {
            if (value.getCode().equals(restStatus)){
                return value.getDesc();
            }
        }
        return null;
    }
}
