package com.elitesland.tw.tw5.server.prd.office.models.filemodel;

import com.elitesland.tw.tw5.server.prd.office.models.enums.DocumentType;
import com.elitesland.tw.tw5.server.prd.office.models.enums.Type;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope("prototype")
@Getter
@Setter
public class FileModel {  // the file base parameters which include the platform type used, document display size (width and height) and type of the document opened
    @Autowired
    private Document document;  // the parameters pertaining to the document (title, url, file type, etc.)
    private DocumentType documentType;  // the document type to be opened
    @Autowired
    private EditorConfig editorConfig;  //  the parameters pertaining to the editor interface: opening mode (viewer or editor), interface language, additional buttons, etc.
    private String token;  // the encrypted signature added to the Document Server config
    private Type type;  // the platform type used to access the document
}
