package com.elitesland.tw.tw5.server.prd.org.controller;

import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgVersionPayload;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgVersionService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgVersionVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 维度版本管理
 *
 * @author wangding
 */
@Api("维度版本管理")
@RestController
@RequiredArgsConstructor
//@RequestMapping(API_ORG)
@RequestMapping("/api/org")
@Slf4j
public class PrdOrgVersionController {

    private final PrdOrgVersionService service;

    /**
     * 新建
     *
     * @param payload po类
     * @return result
     */
    @ApiOperation("新增")
    @PostMapping("/version/insert")
    public TwOutputUtil insert(PrdOrgVersionPayload payload) {
        PrdOrgVersionVO vo = service.insert(payload);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 全部修改
     *
     * @param payload po类
     * @return result
     */
    @ApiOperation("修改")
    @PutMapping("/version/update")
    public TwOutputUtil update(PrdOrgVersionPayload payload) {
        service.update(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 逻辑删除
     *
     * @param key 主键
     * @return result
     */
    @ApiOperation("逻辑删除")
    @DeleteMapping("/version/delete/{key}")
    public TwOutputUtil delete(@PathVariable Long key) {
        service.deleteSoft(key);
        return TwOutputUtil.ok();
    }


    /**
     * 根据维度id版本查询
     *
     * @param dimensionId 主键
     * @return result
     */
    @ApiOperation("根据维度id版本查询")
    @GetMapping("/version/list")
    public TwOutputUtil queryList(Long dimensionId) {
        List<PrdOrgVersionVO> vo = service.queryList(dimensionId);
        return TwOutputUtil.ok(vo);
    }


}
