package com.elitesland.tw.tw5.server.prd.org.dao;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.EmployeeBlackListQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.EmployeeBlackListVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgPersonPayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgPersonQuery;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgPersonVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.org.entity.*;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgPersonRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.util.List;
import java.util.Optional;

@Repository
@RequiredArgsConstructor
public class PrdOrgPersonDAO {

    private final PrdOrgPersonRepo prdOrgPersonRepo;
    private final JPAQueryFactory jpaQueryFactory;

    private final QPrdOrgPersonDO prdOrgPersonDO = QPrdOrgPersonDO.prdOrgPersonDO;

    private final QPrdOrgEmployeeDO employeeDO = QPrdOrgEmployeeDO.prdOrgEmployeeDO;

    private final QPrdOrgOrganizationDO qdoOrg = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QPrdOrgEmployeeRefDO qdoRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;

    private JPAQuery<PrdOrgPersonVO> getPersonSelect() {
        return jpaQueryFactory.select(Projections.bean(PrdOrgPersonVO.class,
                        prdOrgPersonDO.id,
                        prdOrgPersonDO.personName,
                        prdOrgPersonDO.foreignName,
                        prdOrgPersonDO.sex,
                        prdOrgPersonDO.email,
                        prdOrgPersonDO.mobile,
                        prdOrgPersonDO.apprStatus,
                        prdOrgPersonDO.createTime,
                        prdOrgPersonDO.remark))
                .from(prdOrgPersonDO)
                .where(prdOrgPersonDO.inBlackList.eq(false).or(prdOrgPersonDO.inBlackList.isNull()));
    }

    private JPAQuery<PrdOrgPersonVO> getPersonWhere(PrdOrgPersonQuery query) {
        JPAQuery<PrdOrgPersonVO> jpaQuery = getPersonSelect();
        jpaQuery.where(prdOrgPersonDO.deleteFlag.eq(0));

        if (!ObjectUtils.isEmpty(query.getPersonName())) {
            jpaQuery.where(prdOrgPersonDO.personName.like(SqlUtil.toSqlLikeString(query.getPersonName())));
        }
        if (!ObjectUtils.isEmpty(query.getSex())) {
            jpaQuery.where(prdOrgPersonDO.sex.eq(query.getSex()));
        }
        if (!ObjectUtils.isEmpty(query.getApprStatus())) {
            jpaQuery.where(prdOrgPersonDO.apprStatus.eq(query.getApprStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getRemark())) {
            jpaQuery.where(prdOrgPersonDO.remark.like(SqlUtil.toSqlLikeString(query.getRemark())));
        }
        if (!ObjectUtils.isEmpty(query.getMobile())) {
            jpaQuery.where(prdOrgPersonDO.mobile.eq(query.getMobile()));
        }
        if (!ObjectUtils.isEmpty(query.getCreateTimeStart()) && !ObjectUtils.isEmpty(query.getCreateTimeEnd())) {
            jpaQuery.where(prdOrgPersonDO.createTime.between(query.getCreateTimeStart(), query.getCreateTimeEnd()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, prdOrgPersonDO._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(prdOrgPersonDO, query.getOrders()));
        return jpaQuery;
    }

    public PagingVO<PrdOrgPersonVO> queryPaging(PrdOrgPersonQuery query) {
        JPAQuery<PrdOrgPersonVO> jpaQuery = getPersonWhere(query);
        QueryResults<PrdOrgPersonVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<PrdOrgPersonVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public void deleteSoft(Long id) {
        jpaQueryFactory.update(prdOrgPersonDO)
                .set(prdOrgPersonDO.deleteFlag, 1)
                .where(prdOrgPersonDO.id.eq(id))
                .execute();
    }

    public PrdOrgPersonDO save(PrdOrgPersonDO prdOrgPersonDO) {
        return prdOrgPersonRepo.save(prdOrgPersonDO);
    }

    public Optional<PrdOrgPersonDO> findById(Long id) {
        return prdOrgPersonRepo.findById(id);
    }

    public void deleteById(Long id) {
        jpaQueryFactory.update(prdOrgPersonDO)
                .set(prdOrgPersonDO.deleteFlag, 1)
                .where(prdOrgPersonDO.id.eq(id))
                .execute();
    }

    public void updateProcessDate(PrdOrgPersonPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(prdOrgPersonDO)
                .where(prdOrgPersonDO.id.eq(payload.getId()));

        if (payload.getProcInstId() != null) {
            update.set(prdOrgPersonDO.procInstId, payload.getProcInstId());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(prdOrgPersonDO.procInstStatus, payload.getProcInstStatus());
        }
        if (payload.getSubmitTime() != null) {
            update.set(prdOrgPersonDO.submitTime, payload.getSubmitTime());
        }
        if (payload.getApprovedTime() != null) {
            update.set(prdOrgPersonDO.approvedTime, payload.getApprovedTime());
        }
        // 执行修改
        update.execute();
    }

    public Long getIdByProcId(String procId) {
        return jpaQueryFactory.select(prdOrgPersonDO.id)
                .where(prdOrgPersonDO.procInstId.eq(procId))
                .from(prdOrgPersonDO)
                .fetchOne();
    }

    public void updateApprStatus(Long id, String apprStatus) {
        jpaQueryFactory.update(prdOrgPersonDO)
                .set(prdOrgPersonDO.apprStatus, apprStatus)
                .where(prdOrgPersonDO.id.eq(id))
                .execute();
    }


    public void inBlackList(Long id) {
        jpaQueryFactory.update(prdOrgPersonDO)
                .set(prdOrgPersonDO.inBlackList, true)
                .where(prdOrgPersonDO.id.eq(id))
                .execute();
    }

    public void outBlackList(Long personId) {
        jpaQueryFactory.update(prdOrgPersonDO)
                .set(prdOrgPersonDO.inBlackList, false)
                .where(prdOrgPersonDO.id.eq(personId))
                .execute();
    }

    public JPAQuery<EmployeeBlackListVO> getBlackListSelect() {
        JPAQuery<EmployeeBlackListVO> jpaQuery = jpaQueryFactory.select(Projections.bean(EmployeeBlackListVO.class,
                        prdOrgPersonDO.id,
                        prdOrgPersonDO.personName,
                        prdOrgPersonDO.procInstStatus.as("apprStatus"),
//                        prdOrgPersonDO.resourceStatus.as("personStatus"),
                        employeeDO.extString5,
                        employeeDO.extString6,
                        employeeDO.extString9,
                        employeeDO.resourceStatus,
                        employeeDO.enrollDate,
                        employeeDO.extDate4,
                        employeeDO.employeeNo,
                        employeeDO.id.as("employeeId"),
                        qdoOrg.id.as("orgId"),
                        qdoOrg.orgName,
                        prdOrgPersonDO.remark
                ))
                .from(prdOrgPersonDO)
                .leftJoin(employeeDO).on(employeeDO.personId.eq(prdOrgPersonDO.id))
                .leftJoin(qdoRef).on(employeeDO.userId.longValue().eq(qdoRef.userId.longValue()).and(qdoRef.isDefault.eq(0)).and(qdoRef.isCopy.eq(0)).and(qdoRef.deleteFlag.eq(0)))
                .leftJoin(qdoOrg).on(qdoOrg.id.longValue().eq(qdoRef.orgId.longValue()).and(qdoOrg.isCopy.eq(0)))
                .where(prdOrgPersonDO.inBlackList.eq(true));
        return jpaQuery;
    }

    public PagingVO<EmployeeBlackListVO> queryBlackListPaging(EmployeeBlackListQuery query) {
        JPAQuery<EmployeeBlackListVO> jpaQuery = getBlackListWhere(query);
        QueryResults<EmployeeBlackListVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<EmployeeBlackListVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    private JPAQuery<EmployeeBlackListVO> getBlackListWhere(EmployeeBlackListQuery query) {
        JPAQuery<EmployeeBlackListVO> jpaQuery = getBlackListSelect();
        jpaQuery.where(prdOrgPersonDO.deleteFlag.eq(0));

        if (!ObjectUtils.isEmpty(query.getEmployeeNo())) {
            jpaQuery.where(employeeDO.employeeNo.eq(query.getEmployeeNo()));
        }
        if (!ObjectUtils.isEmpty(query.getPersonName())) {
            jpaQuery.where(prdOrgPersonDO.personName.like(SqlUtil.toSqlLikeString(query.getPersonName())));
        }
        if (!ObjectUtils.isEmpty(query.getExtString6()) && !ObjectUtils.isEmpty(query.getExtString9())) {
            jpaQuery.where(employeeDO.extString6.eq(query.getExtString6()));
            jpaQuery.where(employeeDO.extString9.eq(query.getExtString9()));
        }
        if (!ObjectUtils.isEmpty(query.getApprStatus())) {
            jpaQuery.where(prdOrgPersonDO.apprStatus.eq(query.getApprStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getOrgId())) {
            jpaQuery.where(qdoOrg.id.eq(query.getOrgId()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString5())) {
            jpaQuery.where(employeeDO.extString5.eq(query.getExtString5()));
        }
        if (!ObjectUtils.isEmpty(query.getEnrollDateStart()) && !ObjectUtils.isEmpty(query.getEnrollDateEnd())) {
            jpaQuery.where(employeeDO.enrollDate.between(query.getEnrollDateStart(), query.getEnrollDateEnd()));
        }
        if (!ObjectUtils.isEmpty(query.getExtDate4Start()) && !ObjectUtils.isEmpty(query.getExtDate4End())) {
            jpaQuery.where(employeeDO.extDate4.between(query.getExtDate4Start(), query.getExtDate4End()));
        }
        if (!ObjectUtils.isEmpty(query.getResourceStatus())) {
            jpaQuery.where(employeeDO.resourceStatus.eq(query.getResourceStatus()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, prdOrgPersonDO._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(prdOrgPersonDO, query.getOrders()));
        return jpaQuery;
    }

    public List<PrdOrgPersonVO> getByMobile(String recommPhone) {
        JPAQuery<PrdOrgPersonVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdOrgPersonVO.class,
                        prdOrgPersonDO.id,
                        prdOrgPersonDO.personName,
                        prdOrgPersonDO.apprStatus,
                        prdOrgPersonDO.mobile,
                        prdOrgPersonDO.remark
                ))
                .from(prdOrgPersonDO);
        List<PrdOrgPersonVO> res = jpaQuery.where(prdOrgPersonDO.mobile.eq(recommPhone))
                .where(prdOrgPersonDO.deleteFlag.eq(0))
                .fetch();

        return res;
    }

    public PrdOrgPersonDO queryByMobile(String mobile) {
        return jpaQueryFactory.select(prdOrgPersonDO)
                .from(prdOrgPersonDO)
                .where(prdOrgPersonDO.mobile.eq(mobile))
                .where(prdOrgPersonDO.deleteFlag.eq(0))
                .fetchFirst();
    }

    public PrdOrgPersonDO queryByIdNo(String idNo) {
        return jpaQueryFactory.select(prdOrgPersonDO)
                .from(prdOrgPersonDO)
                .where(prdOrgPersonDO.idNo.eq(idNo))
                .where(prdOrgPersonDO.deleteFlag.eq(0))
                .fetchFirst();
    }

    public PrdOrgPersonDO queryByEmail(String email) {
        return jpaQueryFactory.select(prdOrgPersonDO)
                .from(prdOrgPersonDO)
                .where(prdOrgPersonDO.email.eq(email))
                .where(prdOrgPersonDO.deleteFlag.eq(0))
                .fetchFirst();
    }

    public PrdOrgEmployeeDO findEmployeeByPersonId(Long personId) {
        return jpaQueryFactory.select(employeeDO)
                .from(employeeDO)
                .where(employeeDO.personId.eq(personId))
                .where(employeeDO.deleteFlag.eq(0))
                .fetchFirst();
    }

    public PrdOrgPersonDO findByKey(Long key) {
        return prdOrgPersonRepo.getReferenceById(key);
    }


}
