package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.query.SaleConContractQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsConContractDAO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Service
@RequiredArgsConstructor
@Slf4j
public class PmsConContractServiceImpl implements PmsConContractService {

    //    private final PmsConContractRepo repo;
    private final PmsConContractDAO pmsConContractDAO;

    @Override
    public PagingVO<SaleConContractVO> findListByDeliUserId(SaleConContractQuery query) {
        Long deliUserId = GlobalUtil.getLoginUserId();
        query.setDeliUserId(deliUserId);
        return pmsConContractDAO.queryPaging(query);
    }

    @Override
    public long findCountByDeliUserId(Long deliUserId) {
        SaleConContractQuery query = new SaleConContractQuery();
        query.setDeliUserId(deliUserId);
        return pmsConContractDAO.count(query);
    }

}
