package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsMaConfigDataPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsMaConfigPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsMaConfigQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsMaConfigService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsMaConfigVO;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsMaConfigConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsMaConfigDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsMaConfigDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsMaConfigRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.util.List;

/**
 * 项目经理任务书配置
 *
 * @author carl
 * @date 2023-09-19
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsMaConfigServiceImpl extends BaseServiceImpl implements PmsMaConfigService {

    private final PmsMaConfigRepo pmsMaConfigRepo;
    private final PmsMaConfigDAO pmsMaConfigDAO;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchInsertOrUpdate(PmsMaConfigDataPayload payload) {
        if (!ObjectUtils.isEmpty(payload.getDelIds())) {
            pmsMaConfigDAO.deleteSoft(payload.getDelIds());
        }
        if (!ObjectUtils.isEmpty(payload.getPayloads())) {
            List<PmsMaConfigDO> pmsMaConfigDOS = PmsMaConfigConvert.INSTANCE.toDos(payload.getPayloads());
            pmsMaConfigRepo.saveAll(pmsMaConfigDOS);

        }
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsMaConfigVO insertOrUpdate(PmsMaConfigPayload payload) {
        PmsMaConfigDO entityDo = PmsMaConfigConvert.INSTANCE.toDo(payload);
        return PmsMaConfigConvert.INSTANCE.toVo(pmsMaConfigRepo.save(entityDo));
    }

    @Override
    public PagingVO<PmsMaConfigVO> queryPaging(PmsMaConfigQuery query) {
        return pmsMaConfigDAO.queryPaging(query);
    }

    @Override
    public List<PmsMaConfigVO> queryListDynamic(PmsMaConfigQuery query) {
        return pmsMaConfigDAO.queryListDynamic(query);
    }

    @Override
    public PmsMaConfigVO queryByKey(Long key) {
        PmsMaConfigDO entity = pmsMaConfigRepo.findById(key).orElseGet(PmsMaConfigDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsMaConfigVO vo = PmsMaConfigConvert.INSTANCE.toVo(entity);
        return vo;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PmsMaConfigPayload payload) {
        PmsMaConfigDO entity = pmsMaConfigRepo.findById(payload.getId()).orElseGet(PmsMaConfigDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = pmsMaConfigDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            pmsMaConfigDAO.deleteSoft(keys);
        }
    }

}
