package com.elitesland.tw.tw5.server.prd.pms.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimVO;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmBusitripApplyQuery;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmBusitripApplyService;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmBusitripApplyVO;
import com.elitesland.tw.tw5.api.prd.cal.service.CalAccountService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalAccountVO;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetService;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsInspectionItemPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectConclusionPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectConclusionQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsInspectionItemConfigService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectConclusionService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsInspectionItemConfigVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectConclusionVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchasePaymentQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchasePaymentService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentVO;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.api.prd.task.service.TaskCommonService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimDocStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.*;
import com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.*;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectConclusionConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectConclusionDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectConclusionDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectConclusionRepo;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchasePaymentEnum;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ActionType;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDate;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.elitesland.workflow.enums.ActionType.AGREE;

/**
 * 项目结项
 *
 * @author xxb
 * @date 2023-11-27
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsProjectConclusionServiceImpl extends BaseServiceImpl implements PmsProjectConclusionService {

    private final PmsProjectConclusionRepo pmsProjectConclusionRepo;
    private final PmsProjectConclusionDAO pmsProjectConclusionDAO;

    private final PmsProjectService pmsProjectService;

    private final PmsInspectionItemConfigService pmsInspectionItemConfigService;

    private final WorkflowUtil workflowUtil;

    private final PrdSystemRoleService roleService;

    private final CacheUtil cacheUtil;


    private final CalAccountService calAccountService;

    private final FileUtil fileUtil;

    private final TaskCommonService taskCommonService;

    private final AdmBusitripApplyService admBusitripApplyService;
    private final AccReimService accReimService;
    private final ConReceivablePlanService conReceivablePlanService;
    private final PurchasePaymentService purchasePaymentService;
    private final PmsTimesheetService pmsTimesheetService;
    private final TransactionUtilService transactionUtilService;

    private final PmsProjectDAO pmsProjectDAO;

    @Override
    public PmsProjectConclusionVO queryByProjectId(Long projectId) {
        if (ObjectUtils.isEmpty(projectId)) {
            throw TwException.error("", "项目ID不能为空");
        }

        // 查询项目结项
        PmsProjectConclusionVO projectConclusionVO = pmsProjectConclusionDAO.queryByProjId(projectId);
        if (!ObjectUtils.isEmpty(projectConclusionVO)) {
            throw TwException.error("", "项目已结项，不允许再次发起");
        }
        // 项目结项不存在 则初始化一个
        // 查询项目
        PmsProjectVO projectVO = pmsProjectService.querySimpleProjectByKey(projectId);
        //  权限验证
        checkPermission(projectVO);
        // 初始化 项目结项
        projectConclusionVO = new PmsProjectConclusionVO();
        projectConclusionVO.setApplyUserId(GlobalUtil.getLoginUserId());
        projectConclusionVO.setApplyDate(LocalDate.now());
        projectConclusionVO.setAbnormalFlag(0);
        // 获取审批节点
        List<String> approvalNodes = getApprovalNode(null, null);
        // 获取项目数据
        getProjectData(projectConclusionVO, projectVO);
        // 获取检查项
        List<PmsInspectionItemConfigVO> inspectionItemConfigList = getListByWorkTypeAndApprovalNode(projectConclusionVO, projectVO.getWorkType(), approvalNodes);
        projectConclusionVO.setInspectionItemConfigList(inspectionItemConfigList);
        return projectConclusionVO;
    }


    /**
     * 权限验证
     *
     * @param projectVO
     */
    void checkPermission(PmsProjectVO projectVO) {
        //只有项目经理可以 发起项目结项
//        if (!GlobalUtil.getLoginUserId().equals(projectVO.getPmResId())) {
//            throw TwException.error("", "只有项目经理可以 发起项目结项");
//        }
        // 仅激活状态的项目 可以发起结项
        if (!ProjectStatusEnum.ACTIVE.getCode().equals(projectVO.getProjStatus()) && !ProjectStatusEnum.CLOSING.getCode().equals(projectVO.getProjStatus())) {
            throw TwException.error("", "仅激活状态的项目 可以发起结项");
        }
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void insertOrUpdate(PmsProjectConclusionPayload payload) {
        // 数据验证
        Long projId = payload.getProjId();
        if (ObjectUtils.isEmpty(projId)) {
            throw TwException.error("", "项目ID不能为空");
        }
        String approvalNodeInfo = payload.getApprovalNodeInfo();
        if (ObjectUtils.isEmpty(approvalNodeInfo)) {
            throw TwException.error("", "节点操作详情不能为空");
        }
        // 查询项目结项
        PmsProjectConclusionVO projectConclusionVO = pmsProjectConclusionDAO.queryByProjId(projId);
        // 获取审批节点
        getApprovalNode(projectConclusionVO, payload.getApprovalNode());
        Integer abnormalFlag = payload.getAbnormalFlag();
        if (ObjectUtils.isEmpty(abnormalFlag)) {
            throw TwException.error("", "异常标识不能为空");
        }
        List<PmsInspectionItemPayload> itemConfigPayloadList = payload.getInspectionItemConfigPayloadList();
        if (!ObjectUtils.isEmpty(itemConfigPayloadList)) {
            for (PmsInspectionItemPayload itemConfigPayload : itemConfigPayloadList) {
                String checkItem = itemConfigPayload.getCheckItem();
                if (itemConfigPayloadList.stream().anyMatch(v -> v.getCheckItem().equals(checkItem) && !v.getCompleteStatus().equals(itemConfigPayload.getCompleteStatus()))) {
                    throw TwException.error("", "项目结项中，有检查项一样，但是完成状态不一样的数据");
                }
            }
            if (payload.getSubmitFlag()) {
                //提交需要校验，检查项是否完成
                Optional<PmsInspectionItemPayload> inspectionItemConfigPayloadOptional = itemConfigPayloadList.stream().filter(v -> ObjectUtils.isEmpty(v.getCompleteStatus()) || !v.getCompleteStatus()).findFirst();
                if (inspectionItemConfigPayloadOptional.isPresent()) {
                    throw TwException.error("", "项目结项中，有未完成的检查项");
                }
            }
        }

        Long deliUserId = null;
        String workType = null;
        Long pmResId = null;
        String projName = null;
        // 结项新增时 或者 提交时 需要进行权限验证
        if ((ObjectUtils.isEmpty(projectConclusionVO) && payload.getSubmitFlag()) || (!ObjectUtils.isEmpty(projectConclusionVO) && WorkFlowStatusEnum.NOTSUBMIT.getCode().equals(projectConclusionVO.getConclusionStatus()))) {
            // 查询项目  进行权限验证
            PmsProjectVO projectVO = pmsProjectService.querySimpleProjectByKey(projId);
            checkPermission(projectVO);
            deliUserId = projectVO.getDeliUserId();
            pmResId = projectVO.getPmResId();
            workType = projectVO.getWorkType();
            projName = projectVO.getProjName();
        }

        String procInstId = null;
        PmsProjectConclusionDO entityDo = null;
        try {
            transactionUtilService.begin();
            if (ObjectUtils.isEmpty(projectConclusionVO)) {
                // 生成结项编号 发号器4.0逻辑：PC+年月日+0X序号  PC23111505
                payload.setConclusionCode(generateSeqNum("PROJECT_CONCLUSION"));
                payload.setConclusionStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());
                if (!ObjectUtils.isEmpty(itemConfigPayloadList)) {
                    payload.setConclusionCheckItems(JSON.toJSONString(itemConfigPayloadList));
                }
                pmsProjectService.updateProjectCloseStatus(Arrays.asList(projId), ProjectStatusEnum.CLOSING.getCode());
            } else {
                procInstId = projectConclusionVO.getProcInstId();
                if (!ObjectUtils.isEmpty(itemConfigPayloadList)) {
                    String conclusionCheckItem = projectConclusionVO.getConclusionCheckItems();
                    if (!ObjectUtils.isEmpty(conclusionCheckItem)) {
                        List<PmsInspectionItemPayload> fromDbList = JSON.parseArray(conclusionCheckItem, PmsInspectionItemPayload.class);
                        if (!ObjectUtils.isEmpty(fromDbList)) {
                            // 将页面传过来的更新到数据库
                            List<String> checkItems = itemConfigPayloadList.stream().map(PmsInspectionItemPayload::getCheckItem).collect(Collectors.toList());
                            //老数据过滤掉新的相同配置项数据
                            List<PmsInspectionItemPayload> newDbList = fromDbList.stream().filter(db -> !checkItems.contains(db.getCheckItem())).collect(Collectors.toList());
                            newDbList.addAll(itemConfigPayloadList);
                            payload.setConclusionCheckItems(JSON.toJSONString(newDbList));
                        }
                    }
                }
            }
            if (payload.getSubmitFlag()) {
                payload.setConclusionStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
            }
            //保存项目结项信息
            entityDo = PmsProjectConclusionConvert.INSTANCE.toDo(payload);
            entityDo = pmsProjectConclusionRepo.save(entityDo);
            transactionUtilService.commit();
        } catch (Exception e) {
            transactionUtilService.rollback();
            throw e;
        }
        //判断是否提交
        if (payload.getSubmitFlag()) {
            if (ObjectUtils.isEmpty(procInstId)) {
                // 发起审批流程
                startProcess(entityDo, deliUserId, workType, pmResId, projName);

                // 修改项目的jde确认时间
                // 交付项目、自主研发 是根据按钮“收入确认”提交的时间 2、其他项目 的收入确认时间 取结项申请日期
//                if (workType.equals(SaleConWorkTypeEnum.DELIVERY.getCode()) || workType.equals(SaleConWorkTypeEnum.INDEPENDENT.getCode())) {
//                    vo.setJdeConfirmTime(vo.getJdeConfirmTime());
//                } else {

                // 修改项目的jde确认日期为当前提交时间
//                    PmsProjectPayload pmsProjectPayload = new PmsProjectPayload();
//                    pmsProjectPayload.setId(projId);
//                    pmsProjectPayload.setJdeConfirmTime(LocalDateTime.now());
//                    pmsProjectDAO.updateByKeyDynamic(pmsProjectPayload);

                // 将日期更新至JDE
//                    jdeService.syncProjectDate(payload);

//                }
            }
        }
    }

    @Override
    public PagingVO<PmsProjectConclusionVO> queryPagingJoinProject(PmsProjectConclusionQuery query) {
        //处理权限
        operPermissionFlag(query);
        return pmsProjectConclusionDAO.queryPagingJoinProject(query);
    }

    /**
     * 权限处理
     *
     * @param query
     */
    void operPermissionFlag(PmsProjectConclusionQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        //需要处理权限
        query.setLoginUserId(loginUserId);
        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.OPS.getCode(), RoleEnum.PLAT_FIN_PIC.getCode(), RoleEnum.PLAT_PMO.getCode(), RoleEnum.PLAT_PMO_AID.getCode(), RoleEnum.PROJECT_CONCLUSION.getCode()));
        query.setPermissionFlag(!rolePermission);
//        if (!rolePermission) {
//            Set<Long> longs = employeeService.querySubordinatesIdsByUserId(loginUserId);
//            query.setLowerUserIds(longs);
//
//        }
    }

    @Override
    public List<PmsProjectConclusionVO> queryListDynamic(PmsProjectConclusionQuery query) {
        return pmsProjectConclusionDAO.queryListDynamic(query);
    }

    @Override
    public PmsProjectConclusionVO queryByKey(Long key, String approvalNode) {
        if (ObjectUtils.isEmpty(key)) {
            throw TwException.error("", "主键不能为空");
        }
        // 查询项目结项
        PmsProjectConclusionVO projectConclusionVO = pmsProjectConclusionDAO.queryByKeyJoinProject(key);
        transfer(projectConclusionVO);
        // 获取审批节点
        List<String> approvalNodes = getApprovalNode(projectConclusionVO, approvalNode);
        // 判断是否是财务关账阶段 ，如果是，没有检查项，而且要查 账户信息
        if (isFinanceClose(approvalNodes)) {
            //项目账户
            CalAccountVO projAccountVO = calAccountService.queryByAuTypeAndAuId(CalAccTypeEnum.PROJ.getCode(), projectConclusionVO.getProjId());
            projectConclusionVO.setProjAccountNo(projAccountVO.getLedgerNo());
            projectConclusionVO.setProjAccountAvalQty(projAccountVO.getAvalQty());
            //BU账户
            CalAccountVO buAccountVO = calAccountService.queryByAuTypeAndAuId(CalAccTypeEnum.BU.getCode(), projectConclusionVO.getDeliBuId());
            projectConclusionVO.setBuAccountNo(buAccountVO.getLedgerNo());
            projectConclusionVO.setBuAccountName(buAccountVO.getLedgerName());
        }
        // 获取检查项
        List<PmsInspectionItemConfigVO> inspectionItemConfigList = getListByWorkTypeAndApprovalNode(projectConclusionVO, projectConclusionVO.getWorkType(), approvalNodes);
        projectConclusionVO.setInspectionItemConfigList(inspectionItemConfigList);
        return projectConclusionVO;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            //结项申请单处于“未提交”、“撤回”、“已拒绝”状态的单据支持删除
            List<PmsProjectConclusionVO> list = pmsProjectConclusionDAO.queryByKeys(keys);
            for (PmsProjectConclusionVO v : list) {
                if (!WorkFlowStatusEnum.NOTSUBMIT.getCode().equals(v.getConclusionStatus())
                        && !WorkFlowStatusEnum.REJECTED_WORK.getCode().equals(v.getConclusionStatus())) {
                    throw TwException.error("", "只有结项申请单处于“未提交”、“撤回”、“已拒绝”状态的单据支持删除");
                }
            }
            pmsProjectConclusionDAO.deleteSoft(keys);
            // 删除后，项目就变为激活
            List<Long> projectIds = list.stream().map(PmsProjectConclusionVO::getProjId).collect(Collectors.toList());
            pmsProjectService.updateProjectCloseStatus(projectIds, ProjectStatusEnum.ACTIVE.getCode());
        }
    }


    @Override
    public List<PmsInspectionItemConfigVO> autoCheck(Long projectId, String workType, String approvalNode) {
        if (ObjectUtils.isEmpty(projectId)) {
            throw TwException.error("", "项目id不能为空");
        }
        if (ObjectUtils.isEmpty(workType)) {
            throw TwException.error("", "流程类型不能为空");
        }
        PmsProjectConclusionVO projectConclusionVO = pmsProjectConclusionDAO.queryByProjId(projectId);
        List<String> approvalNodes = getApprovalNode(projectConclusionVO, approvalNode);

        //查询检查项
        List<PmsInspectionItemConfigVO> list = getListByWorkTypeAndApprovalNode(projectConclusionVO, workType, approvalNodes);
        //待检查事由
        List<String> checkItems = new ArrayList<>();
        for (PmsInspectionItemConfigVO v : list) {
            if (InspectionItemCheckMethod.SYSTEM_AUTOMATIC_CHECK.getCode().equals(v.getCheckMethod()) && (ObjectUtils.isEmpty(v.getCompleteStatus()) || !v.getCompleteStatus())) {
                checkItems.add(v.getCheckItem());
            }
        }
        Map<String, Boolean> info = new HashMap<>();
        /**
         *   如果是项目经理，交付负责人 要验证
         *         任务关闭 系统自动检查 项目相关的任务包都已关闭
         *         工时审批 系统自动检查 项目相关的工时都已审批（不能有状态为“/新建 / 审批中 / 已退回”的工时）
         *         出差申请审批 系统自动检查 项目相关的出差申请都已提交（不能有状态为“/新建”的申请单）
         *         费用报销审批 系统自动检查 项目相关的费用报销都已提交(不能有状态为“新建”状态的报销单)
         *         收款开票	系统自动检查	所有收款计划的开票都已完成(交付项目额外判断除尾款及质保款以外不能有“新建/申请中/退回申请/开票退回/退票申请中”的开票申请）
         *         预付款审批	系统自动检查	项目相关的预付款申请都已审批（不能有状态为“/新建/申请中”的预付款申请单）
         */
        String desc1 = cacheUtil.getSystemSelectionValueByName("PMS:PROJ_CLOSED:APPROVAL_NODE", PmsProjectConclusionNodeEnum.PM.getDesc());
        String desc2 = cacheUtil.getSystemSelectionValueByName("PMS:PROJ_CLOSED:APPROVAL_NODE", PmsProjectConclusionNodeEnum.DF.getDesc());
        if (approvalNodes.contains(desc1) || approvalNodes.contains(desc2)) {
            // 任务关闭：项目相关的任务包都已关闭
            if (checkItems.contains(ProjectCloseReasonEnum.REASON4.getCode())) {
//                List<TaskInfoVO> taskInfoVOS = taskCommonService.queryTaskByReason(PmsReasonTypeEnum.PROJ_CONTRACT.getCode(), projectId);
//                long count = taskInfoVOS.stream().filter(v -> !v.getTaskStatus().equals(TaskStatusEnum.CLOSED.getCode())).count();
                info.put(ProjectCloseReasonEnum.REASON4.getCode(), 0 == 0);
            }
            if (checkItems.contains(ProjectCloseReasonEnum.REASON6.getCode())) {
                // 工时审批 系统自动检查 项目相关的工时都已审批（不能有状态为“/新建 / 审批中 / 已退回”的工时）
                List<String> strings = Arrays.asList(TimesheetStatus.CREATE.getCode(), TimesheetStatus.APPROVING.getCode(), TimesheetStatus.REJECTED.getCode());
                TimesheetQuery query = new TimesheetQuery();
                query.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
                query.setReasonId(projectId);
                query.setTsStatusList(strings);
                long count1 = pmsTimesheetService.count(query);
                info.put(ProjectCloseReasonEnum.REASON6.getCode(), count1 == 0);
            }
            //出差申请审批 系统自动检查 项目相关的出差申请都已提交（不能有状态为“/新建”的申请单）
            if (checkItems.contains(ProjectCloseReasonEnum.REASON7.getCode())) {
                AdmBusitripApplyQuery query = new AdmBusitripApplyQuery();
                query.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
                query.setReasonId(projectId);
                query.setApplyStatusFlag(0);
                query.setApplyStatus(BusitripApplyStatusEnum.APPROVED.getCode());
                List<AdmBusitripApplyVO> admBusitripApplyVOS = admBusitripApplyService.queryListDynamic(query);
                info.put(ProjectCloseReasonEnum.REASON7.getCode(), ObjectUtils.isEmpty(admBusitripApplyVOS));
            }
            // 费用报销审批 系统自动检查 项目相关的费用报销都已提交(不能有状态为“新建”状态的报销单)
            if (checkItems.contains(ProjectCloseReasonEnum.REASON8.getCode())) {
                AccReimQuery queryReim = new AccReimQuery();
                queryReim.setReasonId(projectId);
                queryReim.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
                List<String> strings = Arrays.asList(AccReimDocStatusEnum.REJECTED.getCode(), AccReimDocStatusEnum.APPROVED.getCode());
                queryReim.setNotReimStatusList(strings);
                List<AccReimVO> accReimVOS = accReimService.queryListDynamic(queryReim);
                info.put(ProjectCloseReasonEnum.REASON8.getCode(), ObjectUtils.isEmpty(accReimVOS));
            }
            PmsProjectVO pmsProjectVO = null;
            //收款开票 所有收款计划的“开票状态”为“收款完成”(”开票状态“不能有“新建/申请中/退回申请/开票退回/退票申请中”的开票申请）
            if (checkItems.contains(ProjectCloseReasonEnum.REASON10.getCode())) {
                pmsProjectVO = pmsProjectService.querySimpleProjectByKey(projectId);
                ConReceivablePlanQuery queryPlan = new ConReceivablePlanQuery();
                queryPlan.setSaleConId(pmsProjectVO.getContractId());
                //收款计划
                List<ConReceivablePlanVO> recvPlanViews = conReceivablePlanService.queryListDynamic(queryPlan);
                if (ObjectUtils.isEmpty(recvPlanViews)) {
                    info.put(ProjectCloseReasonEnum.REASON10.getCode(), true);
                } else {
                    List<String> filterList = Arrays.asList("1", "2", "3", "5", "8", "9");
                    long count1 = recvPlanViews.stream().filter(view -> StringUtils.hasText(view.getInvStatus()) && filterList.contains(view.getInvStatus())).count();
                    info.put(ProjectCloseReasonEnum.REASON10.getCode(), count1 == 0);
                }
            }
            // 预付款审批	系统自动检查	项目相关的预付款申请都已审批（不能有状态为“/新建/申请中”的预付款申请单）
            if (checkItems.contains(ProjectCloseReasonEnum.REASON11.getCode())) {
                if (pmsProjectVO == null) {
                    pmsProjectVO = pmsProjectService.querySimpleProjectByKey(projectId);
                }
                List<String> strings = Arrays.asList(PurchasePaymentEnum.PaymentStatus.APPROVED.getCode(), PurchasePaymentEnum.PaymentStatus.PAID.getCode(), PurchasePaymentEnum.PaymentStatus.WRITTEN_OFF.getCode());

                PurchasePaymentQuery queryPayment = new PurchasePaymentQuery();
                queryPayment.setRelatedProjectNo(pmsProjectVO.getProjNo());
                queryPayment.setNotInStateList(strings);
                List<PurchasePaymentVO> purchasePaymentVOS = purchasePaymentService.queryListDynamic(queryPayment);
                info.put(ProjectCloseReasonEnum.REASON11.getCode(), ObjectUtils.isEmpty(purchasePaymentVOS));

            }
        }
        /**
         *   如果是财务核查 要验证
         *         费用报销审批 系统自动检查 项目相关的费用报销都已审批（不能有状态为“报销已完成 / 报销未通过”以外的报销单）
         *         收款情况 系统自动检查 项目相关的收款都已完成（不能有状态为“收款完成 / 已退票”以外的开票申请）
         *         客户承担费用	系统自动检查	客户承担费用全部收回
         *         项目未支付款项	系统自动检查	项目应支付未支付款项提醒
         */
        String desc = cacheUtil.getSystemSelectionValueByName("PMS:PROJ_CLOSED:APPROVAL_NODE", PmsProjectConclusionNodeEnum.FIN_VER.getDesc());
        if (approvalNodes.contains(desc)) {
            // 费用报销审批 系统自动检查 项目相关的费用报销都已提交(不能有状态为“新建”状态的报销单)
            if (checkItems.contains(ProjectCloseReasonEnum.REASON8.getCode())) {
                AccReimQuery queryReim = new AccReimQuery();
                queryReim.setReasonId(projectId);
                queryReim.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
                List<String> strings = Arrays.asList(AccReimDocStatusEnum.REJECTED.getCode(), AccReimDocStatusEnum.APPROVED.getCode());
                queryReim.setNotReimStatusList(strings);
                List<AccReimVO> accReimVOS = accReimService.queryListDynamic(queryReim);
                info.put(ProjectCloseReasonEnum.REASON8.getCode(), ObjectUtils.isEmpty(accReimVOS));
            }
            // 收款计划 本项目对应子合同的收款计划的”收款状态“为”已全额收款“（不能有状态为“已全额收款“以外的收款计划单）
            if (checkItems.contains(ProjectCloseReasonEnum.REASON16.getCode())) {
                PmsProjectVO pmsProjectVO = pmsProjectService.querySimpleProjectByKey(projectId);
                ConReceivablePlanQuery queryPlan = new ConReceivablePlanQuery();
                queryPlan.setSaleConId(pmsProjectVO.getContractId());
                //收款计划
                List<ConReceivablePlanVO> recvPlanViews = conReceivablePlanService.queryListDynamic(queryPlan);
                if (ObjectUtils.isEmpty(recvPlanViews)) {
                    info.put(ProjectCloseReasonEnum.REASON16.getCode(), true);
                } else {
                    long count1 = recvPlanViews.stream().filter(view -> StringUtils.hasText(view.getReceStatus()) && !view.getReceStatus().equals("3")).count();
                    info.put(ProjectCloseReasonEnum.REASON16.getCode(), count1 == 0);
                }
            }
        }
        //  重新系统检查下
        for (PmsInspectionItemConfigVO v : list) {
            if (InspectionItemCheckMethod.SYSTEM_AUTOMATIC_CHECK.getCode().equals(v.getCheckMethod()) && (ObjectUtils.isEmpty(v.getCompleteStatus()) || !v.getCompleteStatus())) {
                if (info.containsKey(v.getCheckItem())) {
                    v.setCompleteStatus(info.get(v.getCheckItem()));
                }
            }
        }
        return list;
    }

    @Override
    public void processStatusChange(ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        //根据业务key查询当前业务对象
        PmsProjectConclusionVO pmsProjectConclusionVO = pmsProjectConclusionDAO.queryByKey(Long.valueOf(businessKey));
        if (pmsProjectConclusionVO != null) {
            PmsProjectConclusionPayload projectConclusionPayload = new PmsProjectConclusionPayload();
            projectConclusionPayload.setId(Long.parseLong(businessKey));
            projectConclusionPayload.setApprStatus(procInstStatus.name());
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    projectConclusionPayload.setConclusionStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    projectConclusionPayload.setProcInstId(null);
                    projectConclusionPayload.setNullFields(List.of("procInstId"));
                    projectConclusionPayload.setConclusionStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());

                    // 申请中断 项目状态为激活
                    pmsProjectService.updateProjectCloseStatus(Arrays.asList(pmsProjectConclusionVO.getProjId()), ProjectStatusEnum.ACTIVE.getCode());

                    break;
                case INVALID://作废 先删除流程再删除单据
                    //一般情况将单据状态变成"作废" ，或直接删除单据
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    projectConclusionPayload.setDeleteFlag(1);
                    projectConclusionPayload.setProcInstId(null);
                    projectConclusionPayload.setNullFields(List.of("procInstId"));
                    projectConclusionPayload.setConclusionStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());

                    // 申请作废 项目状态为激活
                    pmsProjectService.updateProjectCloseStatus(Arrays.asList(pmsProjectConclusionVO.getProjId()), ProjectStatusEnum.ACTIVE.getCode());

                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    projectConclusionPayload.setConclusionStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
                    break;
                case APPROVED:
                    projectConclusionPayload.setConclusionStatus(WorkFlowStatusEnum.APPROVED.getCode());

                    // 申请后审批通过 项目状态为关闭
                    pmsProjectService.updateProjectCloseStatus(Arrays.asList(pmsProjectConclusionVO.getProjId()), ProjectStatusEnum.CLOSED.getCode());
                    // 项目关账后项目账户当量余额及项目账户现金余额自动转入交付BU账户，并项目账户当量余额及项目账户金额清0
                    pmsProjectService.createProjFinishWideSettle(pmsProjectConclusionVO.getProjId());

                    break;
                case APPROVING:
                    break;
            }
            pmsProjectConclusionDAO.updateByKeyDynamic(projectConclusionPayload);
        }
    }

    @Override
    public void taskCreated(TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
        // 业务key
        String businessKey = payload.getBusinessKey();
        //根据业务key查询当前业务对象
        PmsProjectConclusionVO pmsProjectConclusionVO = pmsProjectConclusionDAO.queryByKey(Long.valueOf(businessKey));
        if (pmsProjectConclusionVO != null) {
            // 当前流程 审批类型
            CommentInfo commentInfo = payload.getCommentInfo();
            if (!ObjectUtils.isEmpty(commentInfo)) {
                ActionType actionType = commentInfo.getType();
                if (actionType.equals(AGREE)) {
                    // 如果下一个节点为财务关账节点，项目状态为待关账
                    String nextTaskKey = payload.getTaskKey();
                    if (isFinanceClose(Arrays.asList(nextTaskKey))) {
                        pmsProjectService.updateProjectCloseStatus(Arrays.asList(pmsProjectConclusionVO.getProjId()), ProjectStatusEnum.OVERDUE_ACCOUNTS.getCode());
                    }
                }
            }
        }
    }


    /**
     * 获取项目数据
     *
     * @param projectConclusionVO
     * @param projectVO
     */
    private void getProjectData(PmsProjectConclusionVO projectConclusionVO, PmsProjectVO projectVO) {
        // 项目编号、项目名称、子合同编号、项目状态、工作类型、项目经理、交付BU、交付负责人、销售负责人
        projectConclusionVO.setProjId(projectVO.getId());
        projectConclusionVO.setProjName(projectVO.getProjName());
        projectConclusionVO.setProjNo(projectVO.getProjNo());
        projectConclusionVO.setContractNo(projectVO.getContractNo());
        projectConclusionVO.setProjStatus(projectVO.getProjStatus());
        projectConclusionVO.setWorkType(projectVO.getWorkType());
        projectConclusionVO.setPmResId(projectVO.getPmResId());
        projectConclusionVO.setDeliBuId(projectVO.getDeliBuId());
        projectConclusionVO.setDeliUserId(projectVO.getDeliUserId());
        projectConclusionVO.setSaleManUserId(projectVO.getSaleManUserId());
    }

    /**
     * 发起审批流程
     *
     * @param entityDo
     */
    private void startProcess(PmsProjectConclusionDO entityDo, Long deliUserId, String workType, Long pmResId, String projName) {
        PrdSystemSelectionVO selection = cacheUtil.getSystemSelection("PMS:PROJ_CLOSED:APPROVAL_NODE");
        if (selection == null) {
            throw TwException.error("", "请配置审批节点");
        }
        List<PrdSystemSelectionVO> children = selection.getChildren();
        Map<String, PrdSystemSelectionVO> selectionVOMap = children.stream().collect(Collectors.toMap(PrdSystemSelectionVO::getSelectionName, Function.identity()));

        HashMap<String, Object> variables = new HashMap<>();
        // 配置审批节点
        for (PmsProjectConclusionNodeEnum pmsProjectConclusionNodeEnum : PmsProjectConclusionNodeEnum.values()) {
            String desc = pmsProjectConclusionNodeEnum.getDesc();
            if (!PmsProjectConclusionNodeEnum.PM.getDesc().equals(desc)) {
                PrdSystemSelectionVO systemSelectionVO = selectionVOMap.get(pmsProjectConclusionNodeEnum.getDesc());
                if (ObjectUtils.isEmpty(systemSelectionVO)) {
                    throw TwException.error("", "请配置" + desc + "审批节点");
                }
                if (PmsProjectConclusionNodeEnum.DF.getDesc().equals(desc) || PmsProjectConclusionNodeEnum.DH_EVAL.getDesc().equals(desc)) {
                    // 交付负责人审批、交付负责人评价  -- 交付负责人
                    variables.put(systemSelectionVO.getSelectionValue(), deliUserId);
                } else if (PmsProjectConclusionNodeEnum.MEMBER_EVAL.getDesc().equals(desc)) {
                    // 项目成员评价 -- 项目经理
                    variables.put(systemSelectionVO.getSelectionValue(), pmResId);
                } else {
                    String roleCodes = systemSelectionVO.getExtString1();
                    if (ObjectUtils.isEmpty(roleCodes)) {
                        throw TwException.error("", "请配置" + desc + "审批节点的角色");
                    }
                    variables.put(systemSelectionVO.getSelectionValue(), roleService.queryUserIdByRoleCodes(Arrays.asList(roleCodes.split(","))));
                }
            }
        }
        // 配置验证
        // 是否为 内部项目（内部研发项目、专项管理、管理类项目）、 纯贸易项目 、 自主研发（软件)
        Boolean check1 = SaleConWorkTypeEnum.DEVELOP.getCode().equals(workType) ||
                SaleConWorkTypeEnum.SPECIAL.getCode().equals(workType) ||
                SaleConWorkTypeEnum.MANAGE.getCode().equals(workType) ||
                SaleConWorkTypeEnum.PURETRADE.getCode().equals(workType) ||
                SaleConWorkTypeEnum.INDEPENDENT.getCode().equals(workType);
        variables.put("check1", check1);
        variables.put("check5", check1);
        // 是否为管理类项目/专项项目
        variables.put("check2", SaleConWorkTypeEnum.MANAGE.getCode().equals(workType) || SaleConWorkTypeEnum.SPECIAL.getCode().equals(workType));
        // 是否为运维类项目
        variables.put("check3", SaleConWorkTypeEnum.OPERATION.getCode().equals(workType));
        // 是否为纯贸易项目
        variables.put("check4", SaleConWorkTypeEnum.PURETRADE.getCode().equals(workType));


        // 流程实例名称 A40.项目名称-项目结项流程
        String procInstName = "A40." + projName + "-项目结项流程";
        //发起流程审批
        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                PmsProcDefKey.PMS_PROJECT_CLOSE.name(),
                procInstName,
                entityDo.getId() + "",
                variables)
        );
        //流程启动成功后，回写业务表数据
        entityDo.setProcInstId(processInfo.getProcInstId());
        entityDo.setApprStatus(processInfo.getProcInstStatus().name());
        entityDo.setApplyUserId(GlobalUtil.getLoginUserId());
        entityDo.setApplyDate(LocalDate.now());

        if (ProcInstStatus.APPROVING.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
            // 申请结项表单数据提交后的状态
            entityDo.setConclusionStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
        } else if (ProcInstStatus.APPROVED.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
            // 申请后审批通过
            entityDo.setConclusionStatus(WorkFlowStatusEnum.APPROVED.getCode());
            // 申请后审批通过 项目状态为关闭
            pmsProjectService.updateProjectCloseStatus(Arrays.asList(entityDo.getProjId()), ProjectStatusEnum.CLOSED.getCode());
            // 项目关账后项目账户当量余额及项目账户现金余额自动转入交付BU账户，并项目账户当量余额及项目账户金额清0
            pmsProjectService.createProjFinishWideSettle(entityDo.getProjId());
        }
        pmsProjectConclusionDAO.save(entityDo);
    }


    /**
     * 判断是否是财务关账
     *
     * @param approvalNodes
     * @return
     */
    private boolean isFinanceClose(List<String> approvalNodes) {
        String value1 = cacheUtil.getSystemSelectionValueByName("PMS:PROJ_CLOSED:APPROVAL_NODE", PmsProjectConclusionNodeEnum.FIN_CLOSING_1.getDesc());
        String value2 = cacheUtil.getSystemSelectionValueByName("PMS:PROJ_CLOSED:APPROVAL_NODE", PmsProjectConclusionNodeEnum.FIN_CLOSING_2.getDesc());
        return approvalNodes.contains(value1) || approvalNodes.contains(value2);
    }

    /**
     * 获取审批节点
     *
     * @param projectConclusionVO
     * @param approvalNode
     * @return
     */
    List<String> getApprovalNode(PmsProjectConclusionVO projectConclusionVO, String approvalNode) {
        List<String> keys = new ArrayList<>();
        if (ObjectUtils.isEmpty(approvalNode)) {
            // 当当前用户 为 申请人 并且 状态为未提交  节点为 项目经理
            if (ObjectUtils.isEmpty(projectConclusionVO) || (GlobalUtil.getLoginUserId().equals(projectConclusionVO.getApplyUserId()) && WorkFlowStatusEnum.NOTSUBMIT.getCode().equals(projectConclusionVO.getConclusionStatus()))) {
                keys.add(cacheUtil.getSystemSelectionValueByName("PMS:PROJ_CLOSED:APPROVAL_NODE", PmsProjectConclusionNodeEnum.PM.getDesc()));
            }
            if (ObjectUtils.isEmpty(keys) && !ObjectUtils.isEmpty(projectConclusionVO)) {
                String approvalNodeInfo = projectConclusionVO.getApprovalNodeInfo();
                // 节点1:uerid1,节点2:uerid2
                if (!ObjectUtils.isEmpty(approvalNodeInfo)) {
                    String[] nodeIdPairs = approvalNodeInfo.split(",");
                    for (String nodeIdPair : nodeIdPairs) {
                        String[] pairElements = nodeIdPair.split(":");
                        String userId = pairElements[1];
                        if (GlobalUtil.getLoginUserId().equals(Long.parseLong(userId))) {
                            keys.add(pairElements[0]);
                        }
                    }
                }
            }
        } else {
            keys.add(approvalNode);
        }
        if (ObjectUtils.isEmpty(keys)) {
            throw TwException.error("", "审批节点不能为空");
        }
        return keys.stream()
                .distinct()
                .collect(Collectors.toList());
    }

    /**
     * 获取 检查事项
     *
     * @param projectConclusionVO
     * @param workType
     * @param approvalNodes
     */
    List<PmsInspectionItemConfigVO> getListByWorkTypeAndApprovalNode(PmsProjectConclusionVO projectConclusionVO, String workType, List<String> approvalNodes) {
        List<PmsInspectionItemConfigVO> fromConfig = new ArrayList<>();
        for (String approvalNode : approvalNodes) {
            fromConfig.addAll(pmsInspectionItemConfigService.getListByWorkTypeAndApprovalNode(workType, approvalNode));
        }
        if (!ObjectUtils.isEmpty(projectConclusionVO)) {
            String conclusionCheckItems = projectConclusionVO.getConclusionCheckItems();
            if (!ObjectUtils.isEmpty(conclusionCheckItems)) {
                List<PmsInspectionItemPayload> inspectionItemPayloads = JSON.parseArray(conclusionCheckItems, PmsInspectionItemPayload.class);
                Map<String, PmsInspectionItemPayload> inspectionItemPayloadMap = inspectionItemPayloads.stream().collect(Collectors.toMap(PmsInspectionItemPayload::getCheckItem, pmsInspectionItemPayload -> pmsInspectionItemPayload));
                for (PmsInspectionItemConfigVO itemConfig : fromConfig) {
                    String checkItem = itemConfig.getCheckItem();
                    if (inspectionItemPayloadMap.containsKey(checkItem)) {
                        PmsInspectionItemPayload inspectionItemPayload = inspectionItemPayloadMap.get(checkItem);
                        itemConfig.setCompleteStatus(inspectionItemPayload.getCompleteStatus());
                        itemConfig.setRemark(inspectionItemPayload.getRemark());
                    }
                }
            }
        }
        return fromConfig;
    }

    private void transfer(PmsProjectConclusionVO vo) {
        vo.setBudgetFilesData(fileUtil.getFileDatas(vo.getBudgetFiles()));
        if (!ObjectUtils.isEmpty(vo.getEqvaPrice()) && !ObjectUtils.isEmpty(vo.getTotalEqva())) {
            vo.setTotalEqvaAmt(vo.getEqvaPrice().multiply(vo.getTotalEqva()));
        }
        String main = vo.getProductClass();
        String sub = vo.getProductSubClass();
        //翻译产品小类
        if (!ObjectUtils.isEmpty(main) || !ObjectUtils.isEmpty(sub)) {
            PrdSystemSelectionVO systemSelectionVO = cacheUtil.querySystemSelection("con:sales_class", main);
            vo.setProductSubClassDesc(cacheUtil.transferSystemSelection(systemSelectionVO.getSelectionKey(), sub));
        }
    }

}
