package com.elitesland.tw.tw5.server.prd.purchase.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 采购合同预估明细
 *
 * @author wangly
 * @date 2024-06-04
 */
@Entity
@Table(name = "purchase_estimated_revenue_detail", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "purchase_estimated_revenue_detail", comment = "采购合同预估明细")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PurchaseEstimatedRevenueDetailDO extends BaseModel implements Serializable  {
    /** 采购预估主表ID */
    @Comment("采购预估主表ID")
    @Column()
    private Long purEstimatedRevenueId;
    /** 采购合同ID */
    @Comment("采购合同ID")
    @Column()
    private Long purContractId;
    /** 付款申请单id */
    @Comment("付款申请单id")
    @Column()
    private Long paymentApplyId;
    /** 付款申请单类型 */
    @Comment("付款申请单类型")
    @Column()
    private String paymentApplicationType;
    /**
     * 付款记录ID
     */
    @Comment("付款记录ID")
    @Column()
    private Long paymentSlipId;

    /** 核销单据ID */
    @Comment("核销单据ID")
    @Column()
    private Long paymentWriteoffApplyId;

    /** 核销单据号 */
    @Comment("核销单据号")
    @Column()
    private String paymentWriteoffApplyNo;
    /** 核销日期 */
    @Comment("核销日期")
    @Column()
    private LocalDate writeOffDate;

    /** 核销金额 */
    @Comment("核销金额")
    @Column()
    private BigDecimal writeOffAmt;
    /** 本次核销金额 */
    @Comment("本次核销金额")
    @Column()
    private BigDecimal currentWriteOffAmt;
    /** 预估单核销凭证 */
    @Comment("预估单核销凭证")
    @Column()
    private String purWriteoffVoucher;
    /** 预估单核销类型 */
    @Comment("预估单核销类型")
    @Column()
    private String purWriteOffType;
    /** 预估单核销单据号 */
    @Comment("预估单核销单据号")
    @Column()
    private String purWriteOffBatchNo;
    /** 预估单应收公司 */
    @Comment("预估单应收公司")
    @Column()
    private String purWriteOffCompany;
    /** 核销同步jde状态 */
    @Comment("核销同步jde状态")
    @Column()
    private String purWriteoffStatus;
    /** 核销失败原因 */
    @Comment("核销失败原因")
    @Column()
    private String purWriteoffFailReason;
    /** 预留字段1 */
    @Comment("预留字段1")
    @Column()
    private String ext1;
    /** 预留字段2 */
    @Comment("预留字段2")
    @Column()
    private String ext2;
    /** 预留字段3 */
    @Comment("预留字段3")
    @Column()
    private String ext3;
    /** 预留字段4 */
    @Comment("预留字段4")
    @Column()
    private String ext4;
    /** 预留字段5 */
    @Comment("预留字段5")
    @Column()
    private String ext5;

    public void copy(PurchaseEstimatedRevenueDetailDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
