package com.elitesland.tw.tw5.server.prd.salecon.service;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.el.coordinator.boot.fsm.service.FileService;
import com.el.coordinator.core.common.api.ApiResult;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgOrganizationQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessCustomerInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerInfoVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.*;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConRecvplanChangeLogQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConServicePriceQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.SaleConContractQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConServicePriceService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.*;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.*;
import com.elitesland.tw.tw5.server.common.crontask.payload.TwContractRecvplanEntity;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.*;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetConvert;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConReceivablePlanConvert;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConRecvplanChangeLogConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConReceivablePlanDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConRecvplanChangeLogDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.SaleConContractDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConReceivablePlanDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.SaleConContractDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConInvBatchRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConReceivablePlanRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.SaleConContractRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 收款计划
 *
 * @author likunpeng
 * @date 2023-03-29
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ConReceivablePlanServiceImpl extends BaseServiceImpl implements ConReceivablePlanService {

    private final ConReceivablePlanRepo conReceivablePlanRepo;
    private final ConReceivablePlanDAO conReceivablePlanDAO;
    private final PrdSystemLogService logService;
    private final CacheUtil cacheUtil;
    private final PrdOrgOrganizationService orgService;
    private final PrdOrgEmployeeService employeeService;
    private final BusinessPartnerService businessPartnerService;
    private final ConServicePriceService conServicePriceService;
    private final BusinessCustomerInfoService businessCustomerInfoService;

    private final UdcUtil udcUtil;
    private final ExcelUtil excelUtil;
    private final FileService fileService;

    private final PrdOrgSyncLogDAO daoLog;

    private final HttpUtil httpUtil;

//    @Value("${tw4.url}")
//    private String tw4_url;

    @Value("${tw4.sale.contractRecvplan}")
    private String contractRecvplan;

    private final ConRecvplanChangeLogDAO conRecvplanChangeLogDAO;

    private final SaleConContractRepo saleConContractRepo;

    private final SaleConContractDAO saleConContractDao;

    private final ConInvBatchRepo conInvBatchRepo;

    private final TimesheetRepo timesheetRepo;

    @Override
    public PagingVO<ConReceivablePlanVO> paging(ConReceivablePlanQuery query) {
        Page<ConReceivablePlanDO> page = conReceivablePlanRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(ConReceivablePlanConvert.INSTANCE::toVo));
    }

    @Override
    public ConReceivablePlanDataVO queryAppMyHandlNum(String type) {
        if (!StringUtils.hasText(type)) {
            throw TwException.error("", "类型不可为空");
        }

        ConReceivablePlanQuery query = new ConReceivablePlanQuery();

        LocalDate localDate = LocalDate.now();
//        //今天往前推三个月的数据
//        LocalDate expectRecvDateEnd = localDate.plusDays(90);
//        query.setExpectRecvDateEnd(expectRecvDateEnd);
        List<String> receStatus;
        if (StringUtils.hasText(type) && type.equals("1")) {
            //我的代收款
            receStatus = Arrays.asList(ReceStatusEnum.OK_INVOICE.getCode(), ReceStatusEnum.PART_PAYMENT.getCode());
        } else {
            receStatus = Arrays.asList(ReceStatusEnum.NO_INVOICE.getCode());
        }
        query.setReceStatusList(receStatus);

        SaleConContractQuery saleConContractQuery = new SaleConContractQuery();
        //获取合同权限,项目经理权限
        if (query.getIsPermission()) {
            getPermissionParams(saleConContractQuery);
        }
//        // 传入的是业务伙伴的id,合同的客户id是地址簿id
//        if (query.getCustId() !=null){
//            BusinessPartnerVO businessPartnerVO = businessPartnerService.queryByKey(query.getCustId());
//            if(!ObjectUtils.isEmpty(businessPartnerVO)){
//                query.setCustId(businessPartnerVO.getBookId());
//            }
//        }
        List<Long> orgIdsByPermission = saleConContractQuery.getOrgIdsByPermission();
        List<Long> userIdsByPermission = saleConContractQuery.getUserIdsByPermission();
        query.setOrgIdsByPermission(orgIdsByPermission);
        query.setUserIdsByPermission(userIdsByPermission);
        if (StringUtils.hasText(type) && type.equals("2")) {
            query.setSaleConStatusIn(Arrays.asList("APPROVING", "ACTIVE"));
        }
        List<ConReceivablePlanVO> conReceivablePlanVOS = conReceivablePlanDAO.queryListDynamic(query);
        long overdueNum = 0;
        long oneMonthNum = 0;
        long threeMonthNum = 0;
        long totalNum = conReceivablePlanVOS.size();

        if (StringUtils.hasText(type) && type.equals("1")) {
            //我的代收款
            //   List<ConReceivablePlanVO> conReceivablePlanVOS = planVOS.stream().filter(vo -> vo.getExpectReceDate() != null).collect(Collectors.toList());
            overdueNum = conReceivablePlanVOS.stream().filter(vo -> vo.getExpectReceDate() != null && vo.getExpectReceDate().isBefore(localDate)).count();
            oneMonthNum = conReceivablePlanVOS.stream().filter(vo -> vo.getExpectReceDate() != null && vo.getExpectReceDate().isAfter(localDate.minusDays(1)) && vo.getExpectReceDate().isBefore(localDate.plusDays(30))).count();
            threeMonthNum = conReceivablePlanVOS.stream().filter(vo -> vo.getExpectReceDate() != null && vo.getExpectReceDate().isAfter(localDate.minusDays(1)) && vo.getExpectReceDate().isBefore(localDate.plusDays(90))).count();
        } else {
            //我的待开票
            //List<ConReceivablePlanVO> conReceivablePlanVOS = planVOS.stream().filter(vo -> vo.getExpectInvDate() != null).collect(Collectors.toList());
            overdueNum = conReceivablePlanVOS.stream().filter(vo -> vo.getExpectInvDate() != null && vo.getExpectInvDate().isBefore(localDate)).count();
            oneMonthNum = conReceivablePlanVOS.stream().filter(vo -> vo.getExpectInvDate() != null && vo.getExpectInvDate().isAfter(localDate.minusDays(1)) && vo.getExpectInvDate().isBefore(localDate.plusDays(30))).count();
            threeMonthNum = conReceivablePlanVOS.stream().filter(vo -> vo.getExpectInvDate() != null && vo.getExpectInvDate().isAfter(localDate.minusDays(1)) && vo.getExpectInvDate().isBefore(localDate.plusDays(90))).count();
        }
        ConReceivablePlanDataVO dataVO = new ConReceivablePlanDataVO();
        dataVO.setType(type);
        dataVO.setOneMonthNum(oneMonthNum);
        dataVO.setOverdueNum(overdueNum);
        dataVO.setThreeMonthNum(threeMonthNum);
        dataVO.setTotalNum(totalNum);
        return dataVO;
    }

    @Override
    public PagingVO<ConReceivablePlanVO> queryPaging(ConReceivablePlanQuery query) {
        SaleConContractQuery saleConContractQuery = new SaleConContractQuery();
        //获取合同权限,项目经理权限
        if (query.getIsPermission()) {
            getPermissionParams(saleConContractQuery);
        }
//        // 传入的是业务伙伴的id,合同的客户id是地址簿id
//        if (query.getCustId() !=null){
//            BusinessPartnerVO businessPartnerVO = businessPartnerService.queryByKey(query.getCustId());
//            if(!ObjectUtils.isEmpty(businessPartnerVO)){
//                query.setCustId(businessPartnerVO.getBookId());
//            }
//        }
        List<Long> orgIdsByPermission = saleConContractQuery.getOrgIdsByPermission();
        List<Long> userIdsByPermission = saleConContractQuery.getUserIdsByPermission();
        query.setOrgIdsByPermission(orgIdsByPermission);
        query.setUserIdsByPermission(userIdsByPermission);

        PagingVO<ConReceivablePlanVO> paging = conReceivablePlanDAO.queryPaging(query);
        // 查询预计开票日期和预计收款日期
        List<ConReceivablePlanVO> records = paging.getRecords();
        if (!CollectionUtils.isEmpty(records)) {
            List<Long> partnerIdList = records.stream().filter(p -> p.getPartnerId() != null).map(e -> e.getPartnerId()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(partnerIdList)) {
                BusinessCustomerInfoQuery businessCustomerInfoQuery = new BusinessCustomerInfoQuery();
                businessCustomerInfoQuery.setPartnerIdList(partnerIdList);
                List<BusinessCustomerInfoVO> businessCustomerInfoVOS = businessCustomerInfoService.queryListDynamic(businessCustomerInfoQuery);
                if (!CollectionUtils.isEmpty(businessCustomerInfoVOS)) {
                    final Map<Long, List<BusinessCustomerInfoVO>> map = businessCustomerInfoVOS.stream().collect(Collectors.groupingBy(BusinessCustomerInfoVO::getPartnerId, Collectors.toList()));
                    records.forEach(p -> {
                        if (p.getPartnerId() != null && map.containsKey(p.getPartnerId())) {
                            p.setCustomerNo(map.get(p.getPartnerId()).get(0).getCustomerNo());
                        }
                    });
                }
            }
            records.forEach(e -> {
                e.setDistAmt((e.getActualRecvAmt() == null ? BigDecimal.ZERO : e.getActualRecvAmt()).subtract(e.getConfirmedAmt() == null ? BigDecimal.ZERO : e.getConfirmedAmt()));
                e.setNotReceAmt(e.getReceAmt().subtract(e.getActualRecvAmt() == null ? BigDecimal.ZERO : e.getActualRecvAmt()));
            });
            List<Long> recvplanIds = records.stream().map(ConReceivablePlanVO::getId).collect(Collectors.toList());
            ConRecvplanChangeLogQuery logQuery = new ConRecvplanChangeLogQuery();
            logQuery.setRecvplanIds(recvplanIds);
            List<ConRecvplanChangeLogVO> conRecvplanChangeLogVOS = conRecvplanChangeLogDAO.queryListDynamic(logQuery);
            conRecvplanChangeLogVOS.forEach(e -> e.setCreateUserName(cacheUtil.getUserName(e.getCreateUserId())));
            if (!CollectionUtils.isEmpty(conRecvplanChangeLogVOS)) {
                for (ConReceivablePlanVO vo : records) {
                    List<ConRecvplanChangeLogVO> recvDateChangeLogs = conRecvplanChangeLogVOS.stream().filter(e -> vo.getId().equals(e.getRecvplanId()) && "RECV".equals(e.getType())).collect(Collectors.toList());
                    List<ConRecvplanChangeLogVO> invDateChangeLogs = conRecvplanChangeLogVOS.stream().filter(e -> vo.getId().equals(e.getRecvplanId()) && "INV".equals(e.getType())).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(recvDateChangeLogs)) {
                        vo.setRecvDateChangeLogs(recvDateChangeLogs);
                    }
                    if (!CollectionUtils.isEmpty(invDateChangeLogs)) {
                        vo.setInvDateChangeLogs(invDateChangeLogs);
                    }
                }
            }
        }
        return paging;
    }

    private void getPermissionParams(SaleConContractQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        // 获取角色
        List<String> userSystemRoleCodes = cacheUtil.getSystemRoleCodes(loginUserId);
        // 销售副总裁(SALES_VP)、销售合同管理员(SALES_CONTRACT_ADMIN)、系统管理员(SYS)、财务负责人(FIN_PIC)、商务负责人(BUSINESS_MANAGER)、合同归档管理员(CONTRACT_FILING)、平台财务负责人(PLAT_FIN_PIC)、运营总裁(OPERATION_PRESIDENT)、财务核定(FIN_CHECK_PIC)可以看到全部
        List<String> roles = Arrays.asList("SALES_VP", "SALES_CONTRACT_ADMIN", "SYS", "FIN_PIC", "BUSINESS_MANAGER", "CONTRACT_FILING", "PLAT_FIN_PIC", "OPERATION_PRESIDENT", "FIN_CHECK_PIC", "PLAT_FINANCIAL_PERFORMANCE_STATISTICS");
        if ((!CollectionUtils.isEmpty(userSystemRoleCodes)) && CollectionUtils.containsAny(userSystemRoleCodes, roles)) {
            return;
        }
        // 查看当前登录人是哪个bu的leader
        PrdOrgOrganizationQuery orgQuery = new PrdOrgOrganizationQuery();
        orgQuery.setManageId(loginUserId);
        orgQuery.setSize(Integer.MAX_VALUE);
        PagingVO<PrdOrgOrganizationVO> paging = orgService.paging(orgQuery);
        List<PrdOrgOrganizationVO> records = paging.getRecords();
        if (!CollectionUtils.isEmpty(records)) {
            List<Long> orgIds = records.stream().map(PrdOrgOrganizationVO::getId).collect(Collectors.toList());
            query.setOrgIdsByPermission(orgIds);
        } else {
            query.setOrgIdsByPermission(new ArrayList<Long>());
        }
        // 设置负责人是当前登录人
        query.setUserIdsByPermission(Collections.singletonList(loginUserId));
    }

    @Override
    public List<ConReceivablePlanVO> queryList(ConReceivablePlanQuery query) {
        return ConReceivablePlanConvert.INSTANCE.toVoList(
                conReceivablePlanRepo.findAll(
                        (root, criteriaQuery, criteriaBuilder)
                                -> QueryHelp.getPredicate(root, query, criteriaBuilder)
                        , query.getPageRequest().getSort()
                )
        );
    }

    @Override
    public List<ConReceivablePlanVO> queryListDynamic(ConReceivablePlanQuery query) {
        return conReceivablePlanDAO.queryListDynamic(query);
    }

    @Override
    public Long countListDynamic(ConReceivablePlanQuery query) {
        return conReceivablePlanDAO.count(query);
    }

    @Override
    public ConReceivablePlanVO queryByKey(Long key) {
        ConReceivablePlanVO vo = conReceivablePlanDAO.queryByKey(key);
        if (ObjectUtils.isEmpty(vo)) {
            throw new BusinessException(ApiCode.NOT_FOUND, "数据不存在！");
        }
        Assert.notNull(vo.getId(), "不存在");
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConReceivablePlanVO insert(ConReceivablePlanPayload payload) {
        // 校验数据
        dataCheck(payload, false);
        ConReceivablePlanDO entityDo = ConReceivablePlanConvert.INSTANCE.toDo(payload);
        String code = generateSeqNum("CON_PLAN");
        entityDo.setReceNo(code);
        logService.saveNewLog(payload.getSaleConId(), PrdSystemObjectEnum.SaleConContract.getCode(), "新建收款计划");
        return ConReceivablePlanConvert.INSTANCE.toVo(conReceivablePlanRepo.save(entityDo));
    }

    @Override
    public int saveContractRecvPlans(ConReceivablePlanSavePayload payload) {
        List<Long> delList = payload.getDelList();
        List<ConReceivablePlanPayload> payloads = payload.getPayloads();
        if (!CollectionUtils.isEmpty(delList)) {
            conReceivablePlanDAO.deleteSoft(delList);
        }
        if (!CollectionUtils.isEmpty(payloads)) {
            List<ConReceivablePlanDO> planDOS = payloads.stream().map(ConReceivablePlanConvert.INSTANCE::toDo).collect(Collectors.toList());
            conReceivablePlanRepo.saveAll(planDOS);
        }
        return 1;
    }

    /**
     * 数据校验
     *
     * @param payload 新增/修改的对象
     */
    private void dataCheck(ConReceivablePlanPayload payload, boolean flag) {
        // 预计收款日期
        LocalDate expectReceDate = payload.getExpectReceDate();
        // 预计开票日期
        LocalDate expectInvDate = payload.getExpectInvDate();
        // 是否已收款
        String receStatus = payload.getReceStatus();
        // 预计收款日期晚于开票日期
        if (StringUtils.hasText(receStatus) && (receStatus.equals("2") || receStatus.equals("3") || receStatus.equals("4"))) {
            //查询开票日期
            ConReceivablePlanVO conReceivablePlanVO = queryByKey(payload.getId());
            LocalDate invDate = conReceivablePlanVO.getInvDate();
            if (expectReceDate != null && invDate != null && (expectReceDate.isBefore(invDate) || expectInvDate.equals(invDate))) {
                throw TwException.error("", "已开票的收款计划，预计收款日期必须晚于实际开票日期！");
            }
        } else {
            if (expectReceDate != null && expectInvDate != null && (expectReceDate.isBefore(expectInvDate) || expectInvDate.equals(expectReceDate))) {
                throw TwException.error("", "预计收款日期必须晚于预计开票日期！");
            }
        }
        List<ConReceivablePlanVO> conReceivablePlanVOS = queryBySaleConId(payload.getSaleConId());
        // 预计收款日期集合
        Set<LocalDate> expectReceDateSet = new HashSet<>();
        // 预计开票日期集合
        Set<LocalDate> expectInvDateSet = new HashSet<>();
        BigDecimal oriPlanAmt = BigDecimal.ZERO;
        // 遍历现有收款计划，初始化日期集合
        for (ConReceivablePlanVO planVO : conReceivablePlanVOS) {
            expectReceDateSet.add(planVO.getExpectReceDate());
            expectInvDateSet.add(planVO.getExpectInvDate());
            //更新时，不添加自己这条数据
            if (flag && payload.getId().equals(planVO.getId())) {
                continue;
            }
            oriPlanAmt = oriPlanAmt.add(planVO.getReceAmt());
        }
        // 修改操作时，在集合中删除修改前的日期
        if (payload.getId() != null) {
            Optional<ConReceivablePlanDO> byId = conReceivablePlanRepo.findByIdAndDeleteFlag(payload.getId(), 0);
            if (byId.isPresent()) {
                expectReceDateSet.remove(byId.get().getExpectReceDate());
                expectInvDateSet.remove(byId.get().getExpectInvDate());
            }
        }
        // 判断新增日期是否与现有日期重复
        if (!expectReceDateSet.add(expectReceDate)) {
            throw TwException.error("", "同一个合同的不同收款计划的预计收款日期不能相同！");
        }
        if (!expectInvDateSet.add(expectInvDate)) {
            throw TwException.error("", "同一个合同的不同收款计划的预计开票日期不能相同！");
        }
        //闭口合同----激活时需要确保收款计划总金额=子合同含税总金额
        Optional<SaleConContractDO> byId = saleConContractRepo.findById(payload.getSaleConId());
        if (byId.isPresent() && SaleConEnum.CLOSED.getCode().equals(byId.get().getRangeProp())) {
            oriPlanAmt = oriPlanAmt.add(payload.getReceAmt());
            SaleConContractDO conContractDO = byId.get();
            if (oriPlanAmt.compareTo(conContractDO.getAmt()) > 0) {
                throw TwException.error("", "收款计划总金额超出了子合同含税总金额");
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<ConReceivablePlanVO> insertAll(List<ConReceivablePlanPayload> payloadList) {
        List<ConReceivablePlanDO> entityDoList = new ArrayList<>();
        for (ConReceivablePlanPayload payload : payloadList) {
            ConReceivablePlanDO entityDo = ConReceivablePlanConvert.INSTANCE.toDo(payload);
            entityDoList.add(entityDo);
            String code = generateSeqNum("CON_PLAN");
            entityDo.setReceNo(code);
            logService.saveNewLog(payload.getSaleConId(), PrdSystemObjectEnum.SaleConContract.getCode(), "新建收款计划");
        }
        return ConReceivablePlanConvert.INSTANCE.toVo(conReceivablePlanRepo.saveAll(entityDoList));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConReceivablePlanVO update(ConReceivablePlanPayload payload) {
        dataCheck(payload, true);
        ConReceivablePlanDO entity = conReceivablePlanRepo.findById(payload.getId()).orElseGet(ConReceivablePlanDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConReceivablePlanDO entityDo = ConReceivablePlanConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ConReceivablePlanConvert.INSTANCE.toVo(conReceivablePlanRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            conReceivablePlanDAO.deleteSoft(keys);
        }
    }

    @Override
    public List<ConReceivablePlanVO> queryBySaleConId(Long saleConId) {
        return conReceivablePlanDAO.queryBySaleConId(saleConId);
    }

    @Override
    public PagingVO<ConReceivablePlanVO> queryBySaleConId(Long saleConId, ConReceivablePlanQuery query) {
        query.setSaleConId(saleConId);
        PagingVO<ConReceivablePlanVO> conReceivablePlanVOPagingVO = conReceivablePlanDAO.queryPaging(query);
        if (!CollectionUtils.isEmpty(conReceivablePlanVOPagingVO.getRecords())) {
            List<Long> partnerIdList = conReceivablePlanVOPagingVO.getRecords().stream().filter(p -> p.getPartnerId() != null).map(e -> e.getPartnerId()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(partnerIdList)) {
                BusinessCustomerInfoQuery businessCustomerInfoQuery = new BusinessCustomerInfoQuery();
                businessCustomerInfoQuery.setPartnerIdList(partnerIdList);
                List<BusinessCustomerInfoVO> businessCustomerInfoVOS = businessCustomerInfoService.queryListDynamic(businessCustomerInfoQuery);
                if (!CollectionUtils.isEmpty(businessCustomerInfoVOS)) {
                    final Map<Long, List<BusinessCustomerInfoVO>> map = businessCustomerInfoVOS.stream().collect(Collectors.groupingBy(BusinessCustomerInfoVO::getPartnerId, Collectors.toList()));
                    conReceivablePlanVOPagingVO.getRecords().forEach(p -> {
                        if (p.getPartnerId() != null && map.containsKey(p.getPartnerId())) {
                            p.setCustomerNo(map.get(p.getPartnerId()).get(0).getCustomerNo());
                        }
                    });
                }
            }
        }
        return conReceivablePlanVOPagingVO;
    }

    @Override
    public void batchReceivablePlanExport(HttpServletResponse response, ConReceivablePlanQuery query) {
        try {
            log.info("=============================开始查询=======================================");
            PagingVO<ConReceivablePlanVO> paging = queryPaging(query);
            log.info("=============================结束查询=======================================");
            List<ConReceivablePlanVO> records = paging.getRecords();
            downloadReceivablePlanList(udcUtil.translateList(records), response);
//            ExcelUtil.writeResponse(response, fileName, workbook);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void downloadBatch(HttpServletResponse response, ConReceivablePlanQuery query) {
        try {
            Workbook workbook = null;
            String fileName = "";
            if (StringUtils.hasText(query.getDownloadType()) && query.getDownloadType().equals("model")) {
                workbook = getVol();
                fileName = "收款计划导入模板-" + LocalDate.now();
                ExcelUtil.writeResponse(response, fileName, workbook);
            } else {
                fileName = "收款计划数据-" + LocalDate.now();
//                List<OrderItem> orderItems = new ArrayList<>();
//                OrderItem openseaId = OrderItem.desc("opensea_id");
//                orderItems.add(openseaId);
//                query.setOrders(orderItems);
                log.info("=============================开始查询=======================================");
                PagingVO<ConReceivablePlanVO> paging = queryPaging(query);
                log.info("=============================结束查询=======================================");
                List<ConReceivablePlanVO> records = paging.getRecords();
                download(records, response);
            }
//            ExcelUtil.writeResponse(response, fileName, workbook);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<String, Object> importBatchPro(MultipartFile file, Boolean force, Long saleConId) throws InterruptedException {
        ExcelEntityDataListener<ConReceivablePlanPayload> dataListener = new ExcelEntityDataListener<>();
        try {
            EasyExcel.read(file.getInputStream(), ConReceivablePlanPayload.class, dataListener).sheet(0).headRowNumber(1).doRead();
        } catch (Exception e) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "导入数据异常，请检查导入 excel的列值是否与模板对应");
        }
        List<ConReceivablePlanPayload> conReceivablePlanPayloadList = dataListener.getDatas();
        if (CollectionUtils.isEmpty(conReceivablePlanPayloadList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "导入数据不能为空！");
        }
        // 校验数据是否有效
        int warnNum = 0;
        int errorNum = 0;
        for (ConReceivablePlanPayload payload : conReceivablePlanPayloadList) {
            StringBuilder importError = new StringBuilder();
            StringBuilder importWarn = new StringBuilder();
            payload.setSaleConId(saleConId);
            String expectReceDateStr = payload.getExpectReceDateStr();
            if (StringUtils.hasText(expectReceDateStr)) {
                try {
                    LocalDate parse = LocalDate.parse(expectReceDateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    payload.setExpectReceDate(parse);
                } catch (Exception e) {
                    importError.append("预计收款日期必须是日期类型");
                }
            }
            String expectInvDateStr = payload.getExpectInvDateStr();
            if (StringUtils.hasText(expectInvDateStr)) {
                try {
                    LocalDate parse = LocalDate.parse(expectInvDateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    payload.setExpectInvDate(parse);
                } catch (Exception e) {
                    importError.append("预计开票日期必须是日期类型");
                }
            }
            // 设置默认值
            payload.setTaxRate(BigDecimal.valueOf(0.06));
            payload.setNotInvAmt(ObjectUtils.isEmpty(payload.getReceAmt()) ? BigDecimal.ZERO : payload.getReceAmt());
            payload.setNotReceAmt(ObjectUtils.isEmpty(payload.getReceAmt()) ? BigDecimal.ZERO : payload.getReceAmt());
            payload.setImoprtError(importError.toString());
            payload.setImportWarn(importWarn.toString());
            payload.setReceStatus(ReceStatusEnum.NO_INVOICE.getCode());
            if (StringUtils.hasText(importError) && importError.length() > 0) {
                errorNum++;
            }
            if ((StringUtils.hasText(importWarn) || importWarn.length() > 0) && !force) {
                warnNum++;
            }

        }

        Map<String, Object> resultMap = new HashMap<>();
        if (errorNum > 0) {
            resultMap.put("ok", "error");
            resultMap.put("errorNum", errorNum);
            resultMap.put("warnNum", warnNum);
            resultMap.put("downloadUrl", downloadModelWithData(conReceivablePlanPayloadList));
        } else {
            insertAll(conReceivablePlanPayloadList);
            resultMap.put("ok", "ok");
        }
        return resultMap;
    }

    @Override
    public void syncContractRecvplanTo4(String param) {
        String syncType = "contract_recvplan_to4";
        LocalDateTime syncTime;
        if (StringUtils.hasText(param)) {
            syncTime = LocalDateTime.parse(param);
        } else {
            syncTime = daoLog.queryOrgSyncLog(syncType);
            if (syncTime == null) {
                syncTime = LocalDateTime.of(2023, 7, 1, 0, 0);
            } else {
                //将同步时间提前10秒，防止拉数据遗漏
                syncTime = syncTime.minusSeconds(120);
            }
        }
        XxlJobLogger.log("合同收款计划同步到4.0开始...");
        XxlJobLogger.log("syncContractRecvplanTo4 localDateTime：" + syncTime);

        // 查询待同步数据
        String format = DateUtil.format(syncTime, "yyyy-MM-dd HH:mm:ss");
        List<ConReceivablePlanDO> receivablePlanDOS = conReceivablePlanRepo.findByModifyTimeStart(format);
//        // 开票批次列表
//        List<ConInvBatchDO> invBatchDOS = conInvBatchRepo.findAll();
//        Map<Long, Long> invBatchMap = invBatchDOS.stream().collect(HashMap::new,(empMap,item) ->empMap.put(item.getId(),item.getInvBatchIdV4()),HashMap::putAll);
        // 同步内容
        String syncData = "";
        LocalDateTime syncNow = LocalDateTime.now();
        if (!ObjectUtils.isEmpty(receivablePlanDOS)) {
            Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            // 组装同步的合同数据
            List<TwContractRecvplanEntity> copy = new ArrayList<>();
            for (ConReceivablePlanDO tempDo : receivablePlanDOS) {
                TwContractRecvplanEntity e = new TwContractRecvplanEntity();
                e.setInvbatchId(tempDo.getInvBatchId());
                e.setContractId(tempDo.getSaleConId());
                e.setPhaseDesc(tempDo.getReceStage());
                e.setRecvNo(tempDo.getReceNo());
                e.setRecvStatus(tempDo.getReceStatus());
                if (tempDo.getReceRatio() != null) {
                    e.setRecvRatio(tempDo.getReceRatio().divide(new BigDecimal(100)));
                }
                e.setRecvAmt(tempDo.getReceAmt());
                e.setExpectRecvDate(tempDo.getExpectReceDate());
                e.setInvAmt(tempDo.getAlreadyInvAmt());
                e.setExpectInvDate(tempDo.getExpectInvDate());
                e.setInvDate(tempDo.getInvDate());
                e.setActualRecvAmt(tempDo.getActualRecvAmt());
                e.setActualRecvDate(tempDo.getActualRecvDate());
                e.setConfirmedAmt(tempDo.getConfirmedAmt());
                e.setRemark(tempDo.getRemark());
                e.setRecvplanIdV5(tempDo.getId());
                e.setRecvplanIdV4(tempDo.getReceivePlanIdV4());
                e.setDelFlag(tempDo.getDeleteFlag().longValue());
                e.setCreateUserId(v4AndV5UserIds.get(tempDo.getCreateUserId()));
                e.setModifyUserId(v4AndV5UserIds.get(tempDo.getModifyUserId()));
                e.setCreateTime(tempDo.getCreateTime());
                e.setModifyTime(tempDo.getModifyTime());
                copy.add(e);
            }
            // 循环调用同步新增接口
            if (!ObjectUtils.isEmpty(copy)) {
                int failNum = 0;
                for (TwContractRecvplanEntity temDo : copy) {
                    LocalDateTime syncStartTime = LocalDateTime.now();
                    try {
//                        Map<String, Object> map = BeanUtil.beanToMap(temDo);
//                        String resultMain = httpUtil.sendPost(tw4_url + contractRecvplan, map);
//                        Map<String, Object> data = (Map) JSON.parse(resultMain);
                        Map<String, Object> data = new HashMap<>();
                        if (!(data.get("ok") + "").equals("true")) {
                            LocalDateTime syncEndTime = LocalDateTime.now();
                            this.saveSyncLog(syncType + "_exception", "合同收款计划id" + temDo.getId() + "同步异常，" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "详情：" + data.get("datum"), null);
                            //更新该条合同的更新时间，下一次处理;
                            conInvBatchRepo.updateRemark(temDo.getRecvplanIdV5());
                            failNum++;
                        }
                    } catch (Exception e) {
                        XxlJobLogger.log("合同收款计划" + temDo.getRecvplanIdV5() + "同步异常......" + e);
                        LocalDateTime syncEndTime = LocalDateTime.now();
                        this.saveSyncLog(syncType + "_exception", "合同收款计划id" + temDo.getRecvplanIdV5() + "同步异常，" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "详情：" + e, null);
                        failNum++;
                        //更新该条合同的更新时间，下一次处理;
                        conReceivablePlanRepo.updateRemark(temDo.getRecvplanIdV5());
                    }
                }
                syncData = "更新了" + (copy.size() - failNum) + "数据,有" + failNum + "条数据更新失败！";
            } else {
                syncData = "合同收款计划数据未变化";
            }
        } else {
            syncData = "合同收款计划数据未变化";
        }
        // 记录同步日志
        PrdOrgSyncLogDO logDO = this.saveSyncLog(syncType, syncData, syncNow);
        XxlJobLogger.log("同步合同收款计划结束..." + logDO);
    }

    @Override
    @Transactional
    public void invalidRecvplan(List<Long> ids, String remark) {
        // 修改收款状态为作废
        conReceivablePlanDAO.updateStatusAndRemarkByKeys(ids, "5", remark);
    }

    @Override
    public Boolean updateRecvOrInvDate(ConRecvplanChangeLogPayload payload) {
        Long recvplanId = payload.getRecvplanId();
        Optional<ConReceivablePlanDO> optional = conReceivablePlanRepo.findById(recvplanId);
        if (!optional.isPresent()) {
            return false;
        }
        ConReceivablePlanDO conReceivablePlanDO = optional.get();
        if (ObjectUtils.isEmpty(conReceivablePlanDO)) {
            return false;
        }
        if (payload.getType().equals("RECV")) {
            conReceivablePlanDO.setExpectReceDate(payload.getRecvOrInvDate());
        } else {
            conReceivablePlanDO.setExpectInvDate(payload.getRecvOrInvDate());
        }
        conReceivablePlanDAO.save(conReceivablePlanDO);
        conRecvplanChangeLogDAO.save(ConRecvplanChangeLogConvert.INSTANCE.toDo(payload));
        return true;
    }

    @Override
    @Transactional
    public void updateExpectReceDate(Map<Long, String> updateData) {
        for (Long id : updateData.keySet()) {
            conReceivablePlanDAO.updateExpectReceDate(id, LocalDate.parse(updateData.get(id)));
        }
    }

    @Override
    public List<ContractNodeVO> findConNodeByConId(Long saleConId) {
        return conReceivablePlanDAO.findConNodeByConId(saleConId);
    }


    private PrdOrgSyncLogDO saveSyncLog(String syncType, String syncData, LocalDateTime currentTime) {
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        daoLog.save(logDO);
        return logDO;
    }

    public Workbook getVol() {
        ClassPathResource classPathResource = new ClassPathResource("template/conReceivablePlan.xlsx");
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create(inputStream);
//            XSSFSheet pCustomerSheet = (XSSFSheet) workbook.getSheet("潜在客户数据");

            return workbook;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void downloadReceivablePlanList(List<ConReceivablePlanVO> records, HttpServletResponse response) throws IOException {
        int order = 1;
        //定义文件名称
        String sheetName = "采购需求数据";
        //对文件名进行固定格式编码
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        //设置请求响应内容类型
        //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        //设置请求响应内容编码方式
        response.setCharacterEncoding("utf-8");
        //文件下载，指定默认名
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

        final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), ConReceivablePlanVO.class)
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .sheet(sheetName);
        // 列
        com.elitesland.tw.tw5.server.common.excel.ExcelUtil.excelHelper(sheet, ConReceivablePlanVO.class, null);
        //写入
        sheet.doWrite(records);
    }

    private void download(List<ConReceivablePlanVO> records, HttpServletResponse response) throws IOException {
        int order = 1;
        records = udcUtil.translateList(records);
        //定义文件名称
        String sheetName = "收款计划数据";
        List<ConReceivablePlanListExcelExport> resultList = ConReceivablePlanConvert.INSTANCE.voListVoExcelExport(records);
        for (ConReceivablePlanListExcelExport record : resultList) {
            record.setOrder(String.valueOf(order));
            order++;
        }

        //对文件名进行固定格式编码
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        //设置请求响应内容类型
        //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        //设置请求响应内容编码方式
        response.setCharacterEncoding("utf-8");
        //文件下载，指定默认名
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

        final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), ConReceivablePlanListExcelExport.class)
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .sheet(sheetName);
        // 列
        com.elitesland.tw.tw5.server.common.excel.ExcelUtil.excelHelper(sheet, ConReceivablePlanListExcelExport.class, null);
        //写入
        sheet.doWrite(resultList);
    }

    private Object downloadModelWithData(List<ConReceivablePlanPayload> records) {
        Workbook workbook = getVol();
        try {
            XSSFSheet planSheet = (XSSFSheet) workbook.getSheet("导入");
            if (!CollectionUtils.isEmpty(records) && planSheet != null) {
                XSSFCell errorCell = planSheet.getRow(0).getCell(7) == null ? planSheet.getRow(0).createCell(7) : planSheet.getRow(0).getCell(7);
                errorCell.setCellValue("导入错误");
                XSSFCell warnCell = planSheet.getRow(0).getCell(8) == null ? planSheet.getRow(0).createCell(8) : planSheet.getRow(0).getCell(8);
                warnCell.setCellValue("导入警告");
                int nextRow = 1;
                for (ConReceivablePlanPayload dataPayload : records) {
//                    Row row = batchProjectSheet.createRow(nextRow);
                    Row row = planSheet.getRow(nextRow);
                    if (row == null) {
                        row = planSheet.createRow(nextRow);
                    }
//                    excelUtil.setCellValueNew(row, 0, nextRow); // 序号
                    excelUtil.setCellValueNew(row, 0, dataPayload.getReceNo()); // 收款号
                    excelUtil.setCellValueNew(row, 1, dataPayload.getReceStage());// 收款阶段
                    excelUtil.setCellValueNew(row, 2, dataPayload.getReceAmt());// 当期收款金额
                    excelUtil.setCellValueNew(row, 3, dataPayload.getReceRatio());// 当期收款比例
                    excelUtil.setCellValueNew(row, 4, dataPayload.getExpectReceDateStr());// 预计收款日期
                    excelUtil.setCellValueNew(row, 5, dataPayload.getExpectInvDateStr());// 预计开票日期
                    excelUtil.setCellValueNew(row, 6, dataPayload.getRemark());// 备注
                    excelUtil.setCellValueNew(row, 7, dataPayload.getImoprtError());//导入错误
                    excelUtil.setCellValueNew(row, 8, dataPayload.getImportWarn());//导入警告
                    nextRow++;
                }
            }
            String fileName = "导入-" + UUID.randomUUID() + ".xlsx";
            File file = ExcelUtil.workbookToFile(workbook, fileName);
            ApiResult upload = fileService.upload(file);
            return upload.getData();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return -1;
    }


//    @Override
//    public Integer taskPrdConPrompt() {
//        // 根据配置查询需要提醒的日期
//        LocalDate endDate = LocalDate.now().plusDays(this.getSysWarmRecvDtLt());
//        // 查询需要发送提醒的收款计划
//        List<ConReceivablePlanVO>  conReceivablePlanVOS = conReceivablePlanDAO.findByExpectReceDate(endDate);
//        conReceivablePlanVOS.forEach(conReceivablePlanVO -> {
//            XxlJobLogger.log("处理收款计划： " + conReceivablePlanVO.getReceNo());
//            // 销售人员
//            Long saleManUserId = conReceivablePlanVO.getSaleManUserId();
//            // 如果销售人员为空或者销售人员处于离职状态，则跳过销售填写的阶段
//
//
//        });
//
//        return null;
//    }


//    /**
//     * 系统自动提醒临近收款计划的提前天数，即此天数阈值内的收款计划，都将做为需要提醒收款的对象
//     * @return 提前的天数
//     */
//    private int getSysWarmRecvDtLt() {
//        int sys_warm_recv_dt_lt = 14;
//        PrdSystemSettingVO systemSettingByKey = prdSystemSettingService.getSystemSettingByKey(SystemSettingsItemEnum.SYS_WARM_RECV_DT_LT.getCode());
//        if (systemSettingByKey != null) {
//            String settingValue = systemSettingByKey.getSettingValue();
//            try {
//                sys_warm_recv_dt_lt = Integer.parseInt(settingValue);
//            }catch (NumberFormatException ignored) {
//                log.error("系统设置项-【SYS_WARM_RECV_DT_LT】配置有误，请检查");
//            }
//        }
//        return sys_warm_recv_dt_lt;
//    }
}
