package com.elitesland.tw.tw5.server.prd.salecon.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.OrgGrossProfitRateSettingPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.OrgGrossProfitRateSettingQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.OrgGrossProfitRateSettingService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.OrgGrossProfitRateSettingVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.salecon.convert.OrgGrossProfitRateSettingConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.OrgGrossProfitRateSettingDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.OrgGrossProfitRateSettingDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.OrgGrossProfitRateSettingRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;

/**
 * 部门毛利率配置
 *
 * @author wangly
 * @date 2024-04-01
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class OrgGrossProfitRateSettingServiceImpl extends BaseServiceImpl implements OrgGrossProfitRateSettingService {

    private final OrgGrossProfitRateSettingRepo orgGrossProfitRateSettingRepo;
    private final OrgGrossProfitRateSettingDAO orgGrossProfitRateSettingDAO;

    @Override
    public PagingVO<OrgGrossProfitRateSettingVO> queryPaging(OrgGrossProfitRateSettingQuery query){
        return orgGrossProfitRateSettingDAO.queryPaging(query);
    }

    @Override
    public List<OrgGrossProfitRateSettingVO> queryListDynamic(OrgGrossProfitRateSettingQuery query){
        return orgGrossProfitRateSettingDAO.queryListDynamic(query);
    }

    @Override
    public OrgGrossProfitRateSettingVO queryByKey(Long key) {
        OrgGrossProfitRateSettingDO entity = orgGrossProfitRateSettingRepo.findById(key).orElseGet(OrgGrossProfitRateSettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        OrgGrossProfitRateSettingVO vo = OrgGrossProfitRateSettingConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public OrgGrossProfitRateSettingVO insert(OrgGrossProfitRateSettingPayload payload) {
        // 校验是否有交叉的时间
        checkDate(payload);
        OrgGrossProfitRateSettingDO entityDo = OrgGrossProfitRateSettingConvert.INSTANCE.toDo(payload);
        return OrgGrossProfitRateSettingConvert.INSTANCE.toVo(orgGrossProfitRateSettingRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public OrgGrossProfitRateSettingVO update(OrgGrossProfitRateSettingPayload payload) {
        // 校验是否有交叉的时间
        checkDate(payload);
        OrgGrossProfitRateSettingDO entity = orgGrossProfitRateSettingRepo.findById(payload.getId()).orElseGet(OrgGrossProfitRateSettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        OrgGrossProfitRateSettingDO entityDo = OrgGrossProfitRateSettingConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return OrgGrossProfitRateSettingConvert.INSTANCE.toVo(orgGrossProfitRateSettingRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(OrgGrossProfitRateSettingPayload payload) {
        // 校验是否有交叉的时间
        checkDate(payload);
        OrgGrossProfitRateSettingDO entity = orgGrossProfitRateSettingRepo.findById(payload.getId()).orElseGet(OrgGrossProfitRateSettingDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = orgGrossProfitRateSettingDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            orgGrossProfitRateSettingDAO.deleteSoft(keys);
        }
    }

    // 校验时间是否有交叉
    private void checkDate(OrgGrossProfitRateSettingPayload payload){
        LocalDate startDate = payload.getStartDate();
        LocalDate endDate = payload.getEndDate();
        OrgGrossProfitRateSettingQuery query = new OrgGrossProfitRateSettingQuery();
        query.setWorkType(payload.getWorkType());
        query.setOrgId(payload.getOrgId());
        // 排除自己
        if(payload.getId()!=null){
            query.setNotInIds(Arrays.asList(payload.getId()));
        }
        List<OrgGrossProfitRateSettingVO> orgGrossProfitRateSettingVOS = queryListDynamic(query);
        orgGrossProfitRateSettingVOS.stream().forEach(vo->{

            // 如果当前时间段的结束时间在另一个时间段开始时间之前 或者当前时间段的开始时间在另一个时间段结束时间之后
            if (endDate.isBefore(vo.getStartDate()) || startDate.isAfter(vo.getEndDate())) {
                return;
            }
            // 其他情况说明至少有一个时间点落在另一个时间段内，即存在交集
            throw TwException.error("","该数据存在时间交叉，请修改后重新保存");
        });
    }
}
