package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemPermissionFieldObjRoleFunctionPayload;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemRolePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemPermissionFieldObjRoleFunctionQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRoleFunctionQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRoleQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 系统角色管理
 *
 * @author wangding
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/system")
@Slf4j
public class PrdSystemRoleController {

    private final PrdSystemRoleService service;
    private final CacheUtil cacheUtil;

    /**
     * 新建
     *
     * @param entity po类
     * @return result
     */
    @PostMapping("/role/insert")
    public TwOutputUtil insert(@RequestBody PrdSystemRolePayload entity) {
        PrdSystemRoleVO vo = service.insert(entity);
        cacheUtil.clearSystemCache(2);
        return TwOutputUtil.ok(vo);
    }


    /**
     * 状态修改
     *
     * @param id      主键
     * @param enabled 状态
     * @return result
     */
    @PutMapping("/role/updateStatus")
    public TwOutputUtil updateStatus(Long id, Boolean enabled) {
        service.updateStatus(id, enabled);
        cacheUtil.clearSystemCache(2);
        return TwOutputUtil.ok();
    }

    /**
     * 修改
     *
     * @param entity po类
     * @return result
     */
    @PutMapping("/role/update")
    public TwOutputUtil update(@RequestBody PrdSystemRolePayload entity) {
        service.update(entity);
        cacheUtil.clearSystemCache(2);
        return TwOutputUtil.ok();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return result
     */
    @DeleteMapping("/role/deleteSoft")
    public TwOutputUtil delete(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        cacheUtil.clearSystemCache(2);
        return TwOutputUtil.ok();
    }


    /**
     * 根据主键查询
     *
     * @param key 主键
     * @return result
     */
    @GetMapping("/role/{key}")
    public TwOutputUtil findByKey(@PathVariable Long key) {
        PrdSystemRoleVO vo = service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 列表查询
     *
     * @return result
     */
    @ApiOperation("列表查询")
    @GetMapping("/role/list")
    public TwOutputUtil queryList() {
        List<PrdSystemRoleVO> paging = service.queryList();
        return TwOutputUtil.ok(paging);
    }

    /**
     * 业务/管理角色列表查询
     *
     * @param query
     * @return
     */
    @ApiOperation("业务/管理角色列表查询")
    @GetMapping("/role/differentList")
    public TwOutputUtil differentList(PrdSystemRoleQuery query) {
        List<PrdSystemRoleVO> paging = service.differentList(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 分页查询
     *
     * @return result
     */
    @GetMapping("/role/paging")
    public TwOutputUtil usableList(PrdSystemRoleQuery query) {
        return TwOutputUtil.ok(service.paging(query));
    }

    /**
     * 获取角色下的用户列表 模糊分页
     *
     * @param query
     * @return
     */
    @GetMapping("/role/pagingUserList")
    public TwOutputUtil pagingUserList(PrdSystemRoleFunctionQuery query) {
        return TwOutputUtil.ok(service.pagingUserList(query));
    }

    /**
     * 角色下 展示的用户列表需要提供一个关系移除
     *
     * @param roleId
     * @param userId
     * @return
     */
    @DeleteMapping("/role/deleteUserList")
    public TwOutputUtil deleteUserList(Long roleId, Long userId) {
        service.deleteUserList(roleId, userId);
        cacheUtil.clearSystemCache(2);
        return TwOutputUtil.ok();
    }

    /**
     * 角色下 功能列表 模糊分页
     *
     * @param query
     * @return
     */
    @GetMapping("/role/pagingFunctionList")
    public TwOutputUtil pagingFunctionList(PrdSystemRoleFunctionQuery query) {
        return TwOutputUtil.ok(service.pagingFunctionList(query));
    }

    /**
     * 角色下 字段列表 模糊分页
     *
     * @param query
     * @return
     */
    @GetMapping("/role/pagingField")
    public TwOutputUtil pagingField(PrdSystemPermissionFieldObjRoleFunctionQuery query) {
        return TwOutputUtil.ok(service.pagingField(query));
    }

    /**
     * 角色下 字段列表 字段属性值更改
     *
     * @param payloads
     * @return
     */
    @PutMapping("/role/updateField")
    public TwOutputUtil updateField(@RequestBody List<PrdSystemPermissionFieldObjRoleFunctionPayload> payloads) {
        service.updateField(payloads);
        return TwOutputUtil.ok();
    }

}
