package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemMenuPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemMenuQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemMenuVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemMenuDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemMenuDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemMenuRepo;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * 系统选择项dao
 *
 * @author wangding
 */
@Repository
@RequiredArgsConstructor
public class PrdSystemMenuDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemMenuRepo repo;
    // private final QPrdSystemMenuDO qdo = QPrdSystemMenuDO.prdSystemMenuDO;
    private final QPrdSystemMenuDO qdo = new QPrdSystemMenuDO("prdSystemMenuDO");
    private final QPrdSystemMenuDO n_qdo = new QPrdSystemMenuDO("prdSystemMenuDO");

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdSystemMenuDO save(PrdSystemMenuDO ado) {
        return repo.save(ado);
    }

    /**
     * 拼装关联查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemMenuVO> getJpaQueryRelevanceSelect() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemMenuVO.class,
                qdo.id,
                qdo.parentId,
                qdo.menuCode,
                qdo.menuName,
                qdo.portalRoute,
                qdo.menuIcon,
                qdo.sortIndex,
                qdo.menuStatus,
                n_qdo.menuName.as("parentMenuName"),
                qdo.remark,
                qdo.deleteFlag,
                qdo.createUserId,
                qdo.createTime
        )).from(qdo).leftJoin(n_qdo).on(qdo.parentId.longValue().eq(n_qdo.id));
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemMenuVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemMenuVO.class,
                qdo.id,
                qdo.parentId,
                qdo.menuCode,
                qdo.menuName,
                qdo.menuStatus,
                qdo.portalRoute,
                qdo.menuIcon,
                qdo.sortIndex,
                qdo.remark,
                qdo.deleteFlag,
                qdo.createUserId,
                qdo.createTime,
                qdo.menuType
        )).from(qdo);
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PrdSystemMenuVO> queryList(PrdSystemMenuQuery query) {
        JPAQuery<PrdSystemMenuVO> jpaQuery = getJpaQuerySelect();
        if (!ObjectUtils.isEmpty(query.getMenuCode())) {
            jpaQuery.where(qdo.menuCode.eq(query.getMenuCode()));
        }
        if (!ObjectUtils.isEmpty(query.getParentId())) {
            jpaQuery.where(qdo.parentId.eq(query.getParentId()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, SqlUtil.getOrderse()));
        return jpaQuery.fetch();
    }

    /**
     * 动态查询集合
     *
     * @return 结果集合
     */
    public List<PrdSystemMenuVO> usableList(PrdSystemMenuQuery query) {
        JPAQuery<PrdSystemMenuVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.menuStatus.eq(0));
        if (StringUtils.hasText(query.getMenuType())) {
            jpaQuery.where(qdo.menuType.eq(query.getMenuType())
                    .or(qdo.menuType.isNull()));
        }
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, SqlUtil.getOrderse()));
        return jpaQuery.fetch();
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(PrdSystemMenuPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));

        if (payload.getParentId() != null) {
            update.set(qdo.parentId, payload.getParentId());
        }
        if (payload.getMenuName() != null) {
            update.set(qdo.menuName, payload.getMenuName());
        }
        if (payload.getMenuCode() != null) {
            update.set(qdo.menuCode, payload.getMenuCode());
        }

        if (payload.getPortalRoute() != null) {
            update.set(qdo.portalRoute, payload.getPortalRoute());
        }
        if (payload.getMenuIcon() != null) {
            update.set(qdo.menuIcon, payload.getMenuIcon());
        }
        if (payload.getSortIndex() != null) {
            update.set(qdo.sortIndex, payload.getSortIndex());
        }
        if (payload.getMenuStatus() != null) {
            update.set(qdo.menuStatus, payload.getMenuStatus());
        }

        // 处理要设置成空的字段
//        List<String> nullFields = payload.getNullFields();
//        if (nullFields != null && nullFields.size() > 0) {
//
////            if (nullFields.contains("remindContent")) {
////                update.setNull(qdo.remindContent);
////            }
////            if (nullFields.contains("remindContentLocale")) {
////                update.setNull(qdo.remindContentLocale);
////            }
//            if (nullFields.contains("remark")) {
//                update.setNull(qdo.remark);
//            }
//        }
        // 执行修改
        return update.execute();
    }

    /**
     * 物理删除
     *
     * @param key 主键
     * @return 删除的行数
     */
    public long delete(Long key) {
        JPADeleteClause delete = jpaQueryFactory.delete(qdo).where(qdo.id.eq(key));

        return delete.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

    /**
     * 更新状态
     *
     * @param ids 主键 status状态
     * @return 删除的行数
     */
    public long updateStatus(List<Long> ids, Integer status) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.menuStatus, status)
                .where(qdo.id.in(ids));
        return update.execute();
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PrdSystemMenuVO queryByKey(Long id) {
        JPAQuery<PrdSystemMenuVO> jpaQuery = getJpaQueryRelevanceSelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }


}
