package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemHelpPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemHelpQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemHelpService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemHelpVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemHelpConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemHelpDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemHelpDO;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.stream.Collectors;


@Service
@RequiredArgsConstructor
@Slf4j
public class PrdSystemHelpServiceImpl implements PrdSystemHelpService {
    private final PrdSystemHelpDAO dao;

    @Override
    public PrdSystemHelpVO insert(PrdSystemHelpPayload payload) {
        PrdSystemHelpDO ado = PrdSystemHelpConvert.INSTANCE.toDo(payload);
        // 数据校验，标题不可以重复
        String helpTitle = ado.getHelpTitle();
        if (StringUtils.hasText(helpTitle)) {
            List<PrdSystemHelpVO> prdSystemHelpVOS = dao.queryByTitle(helpTitle);
            if (!CollectionUtils.isEmpty(prdSystemHelpVOS)) {
                throw TwException.error("",helpTitle + "-标题不可以重复！");
            }
        }
        ado = dao.save(ado);
        return PrdSystemHelpConvert.INSTANCE.toVo(ado);
    }

    @Override
    public PrdSystemHelpVO update(PrdSystemHelpPayload payload) {
        PrdSystemHelpDO ado = PrdSystemHelpConvert.INSTANCE.toDo(payload);
        // 数据校验，标题不可以重复
        String helpTitle = ado.getHelpTitle();
        Long id = ado.getId();
        if (StringUtils.hasText(helpTitle)) {
            List<PrdSystemHelpVO> prdSystemHelpVOS = dao.queryByTitle(helpTitle);
            if (!CollectionUtils.isEmpty(prdSystemHelpVOS)) {
                List<PrdSystemHelpVO> otherHelpVOS = prdSystemHelpVOS.stream().filter(e -> e.getId().compareTo(id) != 0).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(otherHelpVOS)) {
                    throw TwException.error("",helpTitle + "-标题不可以重复！");
                }

            }
        }
        ado = dao.save(ado);
        return PrdSystemHelpConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    @Override
    public void deleteSoft(Long... key) {
        for (int i = 0; i < key.length; i++) {
            dao.deleteSoft(key[i]);
        }
    }

    @Override
    public PrdSystemHelpVO queryByKey(Long key) {
        return dao.queryByKey(key);
    }

    @Override
    public PagingVO<PrdSystemHelpVO> paging(PrdSystemHelpQuery query) {
        return dao.queryPaging(query);
    }

    @Override
    public List<PrdSystemHelpVO> queryList(PrdSystemHelpQuery query) {
        return dao.queryListDynamic(query);
    }



}
