package com.elitesland.tw.tw5.server.prd.ts.service;


import com.elitesland.tw.tw5.api.prd.acc.query.AccBusinessItemQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccBusinessItemVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingTypeVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsNotaskApprovalConfigRulePayload;
import com.elitesland.tw.tw5.api.prd.ts.query.TsNotaskApprovalConfigRuleQuery;
import com.elitesland.tw.tw5.api.prd.ts.service.TsNotaskApprovalConfigRuleService;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsNotaskApprovalConfigRuleVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConInvSettingTypeConvert;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvSettingTypeDO;
import com.elitesland.tw.tw5.server.prd.ts.convert.TsNotaskApprovalConfigRuleConvert;
import com.elitesland.tw.tw5.server.prd.ts.dao.TsNotaskApprovalConfigRuleDAO;
import com.elitesland.tw.tw5.server.prd.ts.entity.TsNotaskApprovalConfigRuleDO;
import com.elitesland.tw.tw5.server.prd.ts.repo.TsNotaskApprovalConfigRuleRepo;
import org.springframework.stereotype.Service;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

/**
 * notask_approval_1
 *
 * @author zoey
 * @date 2024-04-30
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TsNotaskApprovalConfigRuleServiceImpl extends BaseServiceImpl implements TsNotaskApprovalConfigRuleService {

    private final TsNotaskApprovalConfigRuleRepo tsNotaskApprovalConfigRuleRepo;
    private final TsNotaskApprovalConfigRuleDAO tsNotaskApprovalConfigRuleDAO;
    private final CacheUtil cacheUtil;

    @Override
    public PagingVO<TsNotaskApprovalConfigRuleVO> queryPaging(TsNotaskApprovalConfigRuleQuery query){
        return tsNotaskApprovalConfigRuleDAO.queryPaging(query);
    }

    @Override
    public List<TsNotaskApprovalConfigRuleVO> queryListDynamic(TsNotaskApprovalConfigRuleQuery query){
        List<TsNotaskApprovalConfigRuleVO> tsNotaskApprovalConfigRuleVOS = tsNotaskApprovalConfigRuleDAO.queryListDynamic(query);
        if(!CollectionUtils.isEmpty(tsNotaskApprovalConfigRuleVOS)){
            translateList(tsNotaskApprovalConfigRuleVOS);
        }
        return tsNotaskApprovalConfigRuleVOS;
    }

    @Override
    public TsNotaskApprovalConfigRuleVO queryByKey(Long key) {
        TsNotaskApprovalConfigRuleDO entity = tsNotaskApprovalConfigRuleRepo.findById(key).orElseGet(TsNotaskApprovalConfigRuleDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TsNotaskApprovalConfigRuleVO vo = TsNotaskApprovalConfigRuleConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TsNotaskApprovalConfigRuleVO insert(TsNotaskApprovalConfigRulePayload payload) {
        TsNotaskApprovalConfigRuleDO entityDo = TsNotaskApprovalConfigRuleConvert.INSTANCE.toDo(payload);
        return TsNotaskApprovalConfigRuleConvert.INSTANCE.toVo(tsNotaskApprovalConfigRuleRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TsNotaskApprovalConfigRuleVO update(TsNotaskApprovalConfigRulePayload payload) {
        TsNotaskApprovalConfigRuleDO entity = tsNotaskApprovalConfigRuleRepo.findById(payload.getId()).orElseGet(TsNotaskApprovalConfigRuleDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TsNotaskApprovalConfigRuleDO entityDo = TsNotaskApprovalConfigRuleConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TsNotaskApprovalConfigRuleConvert.INSTANCE.toVo(tsNotaskApprovalConfigRuleRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TsNotaskApprovalConfigRulePayload payload) {
        TsNotaskApprovalConfigRuleDO entity = tsNotaskApprovalConfigRuleRepo.findById(payload.getId()).orElseGet(TsNotaskApprovalConfigRuleDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = tsNotaskApprovalConfigRuleDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            tsNotaskApprovalConfigRuleDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoftByConfigId(List<Long> configIds) {
        if (!configIds.isEmpty()) {
            tsNotaskApprovalConfigRuleDAO.deleteSoftByConfigId(configIds);
        }
    }

    /**
     * 查询配置下的规则列表
     * @param key
     * @return
     */
    @Override
    public List<TsNotaskApprovalConfigRuleVO> queryByConfigId(Long key) {
        List<TsNotaskApprovalConfigRuleVO> vo = new ArrayList<>();
        TsNotaskApprovalConfigRuleQuery query = new TsNotaskApprovalConfigRuleQuery();
        query.setConfigId(key);
        return queryListDynamic(query);
    }

    private void translateList(List<TsNotaskApprovalConfigRuleVO> voList){
        for (TsNotaskApprovalConfigRuleVO vo : voList) {

            if(StringUtils.hasText(vo.getUsers())){
                // 翻译用户
                List<String> userNames = new ArrayList<>();
                for (String sourceId : vo.getUsers().split(",")) {
                    String userName = cacheUtil.getUserName(Long.parseLong(sourceId));
                    userNames.add(userName);
                }
                String userName = String.join(",", userNames);
                vo.setUsersName(userName);
            }

            if(StringUtils.hasText(vo.getActivity())){
                PrdSystemSelectionVO systemSelection = cacheUtil.getSystemSelection("prd:timesheet:notask");
                List<PrdSystemSelectionVO> selectionChildren = systemSelection.getChildren();
                // 翻译活动
                List<String> activitys = new ArrayList<>();
                for (String activity : vo.getActivity().split(",")) {
                    for (PrdSystemSelectionVO selectionChild : selectionChildren) {
                        if(selectionChild.getSelectionValue().equals(activity)){
                            activitys.add(selectionChild.getSelectionName());
                        }
                    }
                }
                String activityName = String.join(",", activitys);
                vo.setActivityName(activityName);
            }
        }
    }

}
