/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.acc.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimDetailMealPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimDetailMealQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimDetailMealService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimDetailMealVO;
import com.elitesland.tw.tw5.api.prd.my.query.TAttendanceNormalQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TAttendanceNormalService;
import com.elitesland.tw.tw5.api.prd.my.service.TAttendanceRuleService;
import com.elitesland.tw.tw5.api.prd.my.service.VacationService;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceNormalVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimDetailMealConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimDetailMealDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimDetailMealDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimDetailMealRepo;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class AccReimDetailMealServiceImpl
extends BaseServiceImpl
implements AccReimDetailMealService {
    private static final Logger log = LoggerFactory.getLogger(AccReimDetailMealServiceImpl.class);
    private final AccReimDetailMealRepo accReimDetailMealRepo;
    private final AccReimDetailMealDAO accReimDetailMealDAO;
    private final VacationService vacationService;
    private final TAttendanceRuleService attendanceRuleService;
    private final TAttendanceNormalService attendanceNormalService;
    private final FileUtil fileUtil;

    public PagingVO<AccReimDetailMealVO> queryPaging(AccReimDetailMealQuery query) {
        return this.accReimDetailMealDAO.queryPaging(query);
    }

    public List<AccReimDetailMealVO> queryListDynamic(AccReimDetailMealQuery query) {
        List<AccReimDetailMealVO> reimDetailMealVOS = this.accReimDetailMealDAO.queryListDynamic(query);
        for (AccReimDetailMealVO reimDetailMealVO : reimDetailMealVOS) {
            if (ObjectUtils.isEmpty((Object)reimDetailMealVO.getFileCode())) continue;
            Object fileData = this.fileUtil.getFileDatas(reimDetailMealVO.getFileCode());
            reimDetailMealVO.setFileData(fileData);
        }
        return reimDetailMealVOS;
    }

    public List<AccReimDetailMealVO> queryListInit(AccReimDetailMealQuery query) {
        AccReimDetailMealVO accReimDetailMealVO;
        Long userId = query.getUserId() == null ? GlobalUtil.getLoginUserId() : query.getUserId();
        List mealDate = query.getMealDate();
        if (CollectionUtils.isEmpty((Collection)mealDate)) {
            throw TwException.error("", "\u8bf7\u9009\u62e9\u65e5\u671f\u533a\u95f4");
        }
        List vacationDays = this.vacationService.findVacationDay((LocalDate)mealDate.get(0), (LocalDate)mealDate.get(1));
        TAttendanceNormalQuery attendanceNormalQuery = new TAttendanceNormalQuery();
        attendanceNormalQuery.setAttendanceResId(userId);
        attendanceNormalQuery.setAttendanceDates(mealDate);
        List tAttendanceNormalVOS = this.attendanceNormalService.queryListDynamic(attendanceNormalQuery);
        ArrayList<AccReimDetailMealVO> reimDetailMealVOS = new ArrayList<AccReimDetailMealVO>();
        if (!CollectionUtils.isEmpty((Collection)vacationDays)) {
            for (LocalDate vacationDay : vacationDays) {
                accReimDetailMealVO = new AccReimDetailMealVO();
                accReimDetailMealVO.setMealDate(vacationDay);
                reimDetailMealVOS.add(accReimDetailMealVO);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)tAttendanceNormalVOS)) {
            for (TAttendanceNormalVO attendanceNormalVO : tAttendanceNormalVOS) {
                accReimDetailMealVO = new AccReimDetailMealVO();
                if (attendanceNormalVO.getAttendanceTimeEnd() == null || Integer.parseInt(attendanceNormalVO.getAttendanceTimeEnd().split(":")[0]) <= 20) continue;
                accReimDetailMealVO.setMealDate(attendanceNormalVO.getAttendanceDate());
                accReimDetailMealVO.setAttendanceId(attendanceNormalVO.getId());
                accReimDetailMealVO.setAttendanceTimeStart(attendanceNormalVO.getAttendanceTimeStart());
                accReimDetailMealVO.setAttendanceTimeEnd(attendanceNormalVO.getAttendanceTimeEnd());
                accReimDetailMealVO.setAttendanceCity(attendanceNormalVO.getAttendanceCity());
                reimDetailMealVOS.add(accReimDetailMealVO);
            }
        }
        Collections.sort(reimDetailMealVOS, new Comparator<AccReimDetailMealVO>(){

            @Override
            public int compare(AccReimDetailMealVO vo1, AccReimDetailMealVO vo2) {
                return vo1.getMealDate().compareTo(vo2.getMealDate());
            }
        });
        HashSet<LocalDate> uniqueMealDates = new HashSet<LocalDate>();
        ArrayList<AccReimDetailMealVO> sortedAndDistinctList = new ArrayList<AccReimDetailMealVO>();
        for (AccReimDetailMealVO vo : reimDetailMealVOS) {
            if (vo.getAttendanceId() != null && !uniqueMealDates.add(vo.getMealDate())) continue;
            sortedAndDistinctList.add(vo);
        }
        return sortedAndDistinctList;
    }

    public AccReimDetailMealVO queryByKey(Long key) {
        AccReimDetailMealDO entity = this.accReimDetailMealRepo.findById(key).orElseGet(AccReimDetailMealDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AccReimDetailMealVO vo = AccReimDetailMealConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public AccReimDetailMealVO insert(AccReimDetailMealPayload payload) {
        AccReimDetailMealDO entityDo = AccReimDetailMealConvert.INSTANCE.toDo(payload);
        return AccReimDetailMealConvert.INSTANCE.toVo((AccReimDetailMealDO)this.accReimDetailMealRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public List<AccReimDetailMealVO> insertList(List<AccReimDetailMealPayload> payloads) {
        List<AccReimDetailMealDO> entityDos = AccReimDetailMealConvert.INSTANCE.toDoList(payloads);
        return AccReimDetailMealConvert.INSTANCE.toVoList(this.accReimDetailMealRepo.saveAll(entityDos));
    }

    @Transactional(rollbackFor={Exception.class})
    public AccReimDetailMealVO update(AccReimDetailMealPayload payload) {
        AccReimDetailMealDO entity = this.accReimDetailMealRepo.findById(payload.getId()).orElseGet(AccReimDetailMealDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AccReimDetailMealDO entityDo = AccReimDetailMealConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AccReimDetailMealConvert.INSTANCE.toVo((AccReimDetailMealDO)this.accReimDetailMealRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(AccReimDetailMealPayload payload) {
        AccReimDetailMealDO entity = this.accReimDetailMealRepo.findById(payload.getId()).orElseGet(AccReimDetailMealDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.accReimDetailMealDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.accReimDetailMealDAO.deleteSoft(keys);
        }
    }

    public AccReimDetailMealServiceImpl(AccReimDetailMealRepo accReimDetailMealRepo, AccReimDetailMealDAO accReimDetailMealDAO, VacationService vacationService, TAttendanceRuleService attendanceRuleService, TAttendanceNormalService attendanceNormalService, FileUtil fileUtil) {
        this.accReimDetailMealRepo = accReimDetailMealRepo;
        this.accReimDetailMealDAO = accReimDetailMealDAO;
        this.vacationService = vacationService;
        this.attendanceRuleService = attendanceRuleService;
        this.attendanceNormalService = attendanceNormalService;
        this.fileUtil = fileUtil;
    }
}

