/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.budget.service;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.change.query.ComChangeQuery;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccSubjectTemplateService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccBudgetItemVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimDetailVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimVO;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetCommonService;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetCommonVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetSubjectDetailVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetVO;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectActivityService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectActivityVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseContractManagerQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractManagerVO;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConPurchaseDemandDService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConPurchaseDemandDVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskSettleTimesheetVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.common.constants.PurchaseDemandTypeEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimDocStatusEnum;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimDAO;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimDetailDAO;
import com.elitesland.tw.tw5.server.prd.budget.common.functionEnum.BudgetControlType;
import com.elitesland.tw.tw5.server.prd.budget.dao.BudgetDAO;
import com.elitesland.tw.tw5.server.prd.budget.dao.BudgetSubjectDetailDAO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus;
import com.elitesland.tw.tw5.server.prd.my.dao.TimesheetDAO;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchaseContractManagerDAO;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchaseContractEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskInfoDAO;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskSettleTimesheetDAO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class BudgetCommonServiceImpl
extends BaseServiceImpl
implements BudgetCommonService {
    private static final Logger log = LoggerFactory.getLogger(BudgetCommonServiceImpl.class);
    private final BudgetDAO budgetDAO;
    private final PmsProjectActivityService pmsProjectActivityService;
    private final BudgetSubjectDetailDAO budgetSubjectDetailDAO;
    private final TransactionUtilService transactionUtilService;
    private final ConReceivablePlanService conReceivablePlanService;
    private final PrdSystemRoleDAO daoRole;
    private final PrdMessageConfigService messageConfigService;
    private final ComChangeService changeService;
    private final PmsProjectService pmsProjectService;
    private final BuProjectService buProjectService;
    private final PurchaseContractManagerDAO purchaseContractManagerDAO;
    private final AccSubjectTemplateService accSubjectTemplateService;
    private final TaskInfoDAO taskInfoDAO;
    private final AccReimDAO accReimDAO;
    private final AccReimDetailDAO detailDAO;
    private final TaskSettleTimesheetDAO taskSettleTimesheetDAO;
    private final CacheUtil cacheUtil;
    private final ConPurchaseDemandDService conPurchaseDemandDService;
    private final TimesheetDAO timesheetDAO;

    public BudgetVO querySimpleBySource(Long sourceId, String sourceType) {
        if (ObjectUtils.isEmpty((Object)sourceId)) {
            throw TwException.error("", "\u9884\u7b97\u7c7b\u578bID\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        if (ObjectUtils.isEmpty((Object)sourceType)) {
            throw TwException.error("", "\u9884\u7b97\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        if (!(PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(sourceType) || PmsReasonTypeEnum.PROJ_OPPO.getCode().equals(sourceType) || PmsReasonTypeEnum.PROJ_BU.getCode().equals(sourceType))) {
            throw TwException.error("", "\u9884\u7b97\u7c7b\u578b\u4e0d\u7b26\u5408\u8981\u6c42 !");
        }
        return this.budgetDAO.querySimpleBySource(sourceId, sourceType);
    }

    public BudgetVO initBudget(Long sourceId, String sourceType) {
        BudgetVO budgetVO = new BudgetVO();
        budgetVO.setCreateUserId(GlobalUtil.getLoginUserId());
        budgetVO.setBudgetStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
        budgetVO.setVersionNo(Integer.valueOf(0));
        budgetVO.setControlType(BudgetControlType.STIFFNESS.getCode());
        budgetVO.setPlanAmt(BigDecimal.ZERO);
        budgetVO.setPlanEqva(BigDecimal.ZERO);
        budgetVO.setPlanEqvaAmt(BigDecimal.ZERO);
        budgetVO.setTotalAmt(BigDecimal.ZERO);
        budgetVO.setSourceId(sourceId);
        budgetVO.setSourceType(sourceType);
        this.addProjectInfo(budgetVO);
        return budgetVO;
    }

    public void addProjectInfo(BudgetVO budgetVO) {
        Long sourceId = budgetVO.getSourceId();
        String sourceType = budgetVO.getSourceType();
        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(sourceType)) {
            PmsProjectVO projectVO = this.pmsProjectService.querySimpleProjectByKey(sourceId);
            budgetVO.setSourceCode(projectVO.getProjNo());
            budgetVO.setSourceName(projectVO.getProjName());
            budgetVO.setDeliBuId(projectVO.getDeliBuId());
            budgetVO.setSignBuId(projectVO.getSignBuId());
            budgetVO.setExpenseBuId(projectVO.getExpenseBuId());
            if (ObjectUtils.isEmpty((Object)budgetVO.getEqvaPrice())) {
                budgetVO.setEqvaPrice(projectVO.getEqvaPrice() == null ? new BigDecimal(2000) : projectVO.getEqvaPrice());
            }
            if (budgetVO.getSubjectTempId() == null) {
                budgetVO.setSubjectTempId(projectVO.getSubjectTempId());
            }
            budgetVO.setTotalEqva(projectVO.getTotalEqva());
            budgetVO.setTotalReimbursement(projectVO.getTotalReimbursement());
            budgetVO.setDeliUserId(projectVO.getDeliUserId());
            if (ObjectUtils.isEmpty((Object)budgetVO.getFinYear())) {
                budgetVO.setFinYear(projectVO.getPlanStartDate() == null ? null : "" + projectVO.getPlanStartDate().getYear());
            }
            budgetVO.setContractId(projectVO.getContractId());
            budgetVO.setContractStatus(projectVO.getContractStatus());
            budgetVO.setAmt(projectVO.getSumAmt());
            budgetVO.setTaxRate(projectVO.getTaxRate());
            budgetVO.setPercentage(projectVO.getPercentage());
            budgetVO.setEffectiveAmt(projectVO.getEffectiveAmt());
            budgetVO.setSaleManUserId(projectVO.getSaleManUserId());
            budgetVO.setPlatType(projectVO.getPlatType());
            budgetVO.setWorkType(projectVO.getWorkType());
            budgetVO.setPmoResId(projectVO.getPmoResId());
            this.queryTotalLastCost(budgetVO);
        } else if (PmsReasonTypeEnum.PROJ_BU.getCode().equals(sourceType)) {
            BuProjectVO projectVO = this.buProjectService.queryByKey(sourceId);
            budgetVO.setSourceCode(projectVO.getProjNo());
            budgetVO.setSourceName(projectVO.getProjName());
            budgetVO.setDeliBuId(projectVO.getDeliBuId());
            budgetVO.setTotalEqva(projectVO.getTotalEqva());
            budgetVO.setTotalReimbursement(projectVO.getTotalReimbursement());
            budgetVO.setDeliUserId(projectVO.getDeliUserId());
            if (ObjectUtils.isEmpty((Object)budgetVO.getFinYear())) {
                budgetVO.setFinYear(projectVO.getPlanStartDate() == null ? null : "" + projectVO.getPlanStartDate().getYear());
            }
        }
        if (ObjectUtils.isEmpty((Object)budgetVO.getBudgetName())) {
            budgetVO.setBudgetName(budgetVO.getSourceName());
        }
        if (ObjectUtils.isEmpty((Object)budgetVO.getEqvaPrice())) {
            budgetVO.setEqvaPrice(new BigDecimal(2000));
        }
    }

    void queryTotalLastCost(BudgetVO budgetVO) {
        List conPurchaseDemandDVOS = this.conPurchaseDemandDService.queryListBySaleConIds(Arrays.asList(budgetVO.getContractId()));
        if (!ObjectUtils.isEmpty((Object)conPurchaseDemandDVOS)) {
            List<String> types = Arrays.asList(PurchaseDemandTypeEnum.PURCHASING_AGENT.getCode(), PurchaseDemandTypeEnum.AGENCY_FEE.getCode());
            BigDecimal taxAmt = conPurchaseDemandDVOS.stream().filter(vo -> StringUtils.hasText((String)vo.getDemandType()) && types.contains(vo.getDemandType())).map(ConPurchaseDemandDVO::getTaxAmt).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal amt = budgetVO.getAmt() == null ? BigDecimal.ZERO : budgetVO.getAmt();
            BigDecimal taxRate = budgetVO.getTaxRate() == null ? BigDecimal.ZERO : budgetVO.getTaxRate();
            BigDecimal notTaxAmt = amt.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
            BigDecimal percentage = budgetVO.getPercentage() == null ? BigDecimal.ZERO : budgetVO.getPercentage().divide(BigDecimal.valueOf(100L));
            BigDecimal totalLastCost = notTaxAmt.subtract(taxAmt).multiply(BigDecimal.ONE.subtract(percentage));
            budgetVO.setTotalLastCost(totalLastCost);
        }
    }

    public List<BudgetSubjectDetailVO> queryBySubjectTemplateId(String sourceType, Long subjectTemplateId) {
        if (ObjectUtils.isEmpty((Object)sourceType) || ObjectUtils.isEmpty((Object)subjectTemplateId)) {
            throw TwException.error("", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList<BudgetSubjectDetailVO> subjectDetailVOS = new ArrayList<BudgetSubjectDetailVO>();
        List accTmpldVOS = this.accSubjectTemplateService.queryBudgetItemList(subjectTemplateId);
        for (AccBudgetItemVO accTmpldVO : accTmpldVOS) {
            BudgetSubjectDetailVO subjectDetailVO = new BudgetSubjectDetailVO();
            subjectDetailVO.setAccId(accTmpldVO.getId());
            subjectDetailVO.setAccParentId(accTmpldVO.getParentId());
            subjectDetailVO.setAccName(accTmpldVO.getBudgetName());
            subjectDetailVO.setBudgetAmt(BigDecimal.ZERO);
            subjectDetailVO.setDetailControlFlag(Boolean.valueOf(false));
            subjectDetailVOS.add(subjectDetailVO);
        }
        return subjectDetailVOS;
    }

    public List<BudgetCommonVO> queryBudgetEqvaAndAmts(List<String> reasonTypes, List<Long> reasonIds) {
        ArrayList<BudgetCommonVO> commonVOList = new ArrayList<BudgetCommonVO>();
        List<TaskSettleTimesheetVO> taskTimesheetVOS = this.taskSettleTimesheetDAO.queryTaskByReasons(reasonTypes, reasonIds);
        HashMap<String, List> infoVOSMap = new HashMap<String, List>();
        if (!ObjectUtils.isEmpty(taskTimesheetVOS)) {
            taskTimesheetVOS.forEach(vo -> {
                String key = vo.getReasonType() + "-" + vo.getReasonId();
                ArrayList<TaskSettleTimesheetVO> taskimesheetVOS1 = (ArrayList<TaskSettleTimesheetVO>)infoVOSMap.get(key);
                if (taskimesheetVOS1 == null) {
                    taskimesheetVOS1 = new ArrayList<TaskSettleTimesheetVO>();
                }
                taskimesheetVOS1.add((TaskSettleTimesheetVO)vo);
                infoVOSMap.put(key, taskimesheetVOS1);
            });
            infoVOSMap.forEach((key, taskimesheetVOS2) -> {
                String[] split = key.split("-");
                String reasonType = split[0];
                Long reasonId = Long.valueOf(split[1]);
                BudgetCommonVO commonVO = new BudgetCommonVO();
                commonVO.setReasonId(reasonId);
                commonVO.setReasonType(reasonType);
                this.queryBudgetEqva(commonVO, (List<TaskSettleTimesheetVO>)taskimesheetVOS2);
                commonVOList.add(commonVO);
            });
        }
        this.queryBudgetBatchReimAmt(reasonTypes, reasonIds, commonVOList);
        this.queryhBudgetBatchTimeSheetAmt(reasonTypes, reasonIds, commonVOList);
        this.quertyBatchPurchaseDemandAmt(reasonTypes, reasonIds, commonVOList);
        this.queryBatchPurchaseContractAmt(reasonTypes, reasonIds, commonVOList);
        return commonVOList;
    }

    void queryBatchBusitripApplyAmt(BudgetCommonVO commonVO) {
    }

    void queryBatchPurchaseContractAmt(List<String> reasonTypes, List<Long> reasonIds, List<BudgetCommonVO> commonVOList) {
        if (reasonTypes.contains(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            PurchaseContractManagerQuery query = new PurchaseContractManagerQuery();
            query.setRelatedProjectIdList(reasonIds);
            List<PurchaseContractManagerVO> purchaseContractManagerVOS = this.purchaseContractManagerDAO.queryPurContractInfo(query);
            if (!ObjectUtils.isEmpty(purchaseContractManagerVOS)) {
                HashMap<String, List> purchaseContractManagerMap = new HashMap<String, List>();
                purchaseContractManagerVOS.forEach(vo -> {
                    String key = PmsReasonTypeEnum.PROJ_CONTRACT.getCode() + "-" + vo.getRelatedProjectId();
                    ArrayList<PurchaseContractManagerVO> purchaseContractManagerVOS1 = (ArrayList<PurchaseContractManagerVO>)purchaseContractManagerMap.get(key);
                    if (purchaseContractManagerVOS1 == null) {
                        purchaseContractManagerVOS1 = new ArrayList<PurchaseContractManagerVO>();
                    }
                    purchaseContractManagerVOS1.add((PurchaseContractManagerVO)vo);
                    purchaseContractManagerMap.put(key, purchaseContractManagerVOS1);
                });
                purchaseContractManagerMap.forEach((key, purchaseDemandDVOS1) -> {
                    BudgetCommonVO commonVO;
                    String[] split = key.split("-");
                    String reasonType = split[0];
                    Long reasonId = Long.valueOf(split[1]);
                    Optional<BudgetCommonVO> first = commonVOList.stream().filter(vo -> vo.getReasonType().equals(reasonType) && vo.getReasonId().equals(reasonId)).findFirst();
                    if (first.isPresent()) {
                        commonVO = first.get();
                    } else {
                        commonVO = new BudgetCommonVO();
                        commonVO.setReasonId(reasonId);
                        commonVO.setReasonType(reasonType);
                        commonVOList.add(commonVO);
                    }
                    this.queryPurchaseContractAmt(commonVO, (List<PurchaseContractManagerVO>)purchaseDemandDVOS1, new Long[0]);
                });
            }
        }
    }

    void quertyBatchPurchaseDemandAmt(List<String> reasonTypes, List<Long> reasonIds, List<BudgetCommonVO> commonVOList) {
        List demandDVOS;
        List pmsProjectVOS;
        Map<Long, Long> conProjIdMap;
        if (reasonTypes.contains(PmsReasonTypeEnum.PROJ_CONTRACT.getCode()) && !(conProjIdMap = (pmsProjectVOS = this.pmsProjectService.queryByKeysSimple(reasonIds)).stream().collect(Collectors.toMap(PmsProjectVO::getContractId, PmsProjectVO::getId))).isEmpty() && !ObjectUtils.isEmpty((Object)(demandDVOS = this.conPurchaseDemandDService.queryListBySaleConIds(new ArrayList<Long>(conProjIdMap.keySet()))))) {
            HashMap<String, List> purchaseDemandDMap = new HashMap<String, List>();
            demandDVOS.forEach(vo -> {
                Long reasonId = (Long)conProjIdMap.get(vo.getSaleConId());
                String key = PmsReasonTypeEnum.PROJ_CONTRACT.getCode() + "-" + reasonId;
                ArrayList<ConPurchaseDemandDVO> purchaseDemandDVOS1 = (ArrayList<ConPurchaseDemandDVO>)purchaseDemandDMap.get(key);
                if (purchaseDemandDVOS1 == null) {
                    purchaseDemandDVOS1 = new ArrayList<ConPurchaseDemandDVO>();
                }
                purchaseDemandDVOS1.add((ConPurchaseDemandDVO)vo);
                purchaseDemandDMap.put(key, purchaseDemandDVOS1);
            });
            purchaseDemandDMap.forEach((key, purchaseDemandDVOS1) -> {
                BudgetCommonVO commonVO;
                String[] split = key.split("-");
                String reasonType = split[0];
                Long reasonId = Long.valueOf(split[1]);
                Optional<BudgetCommonVO> first = commonVOList.stream().filter(vo -> vo.getReasonType().equals(reasonType) && vo.getReasonId().equals(reasonId)).findFirst();
                PmsProjectVO pmsProjectVO = pmsProjectVOS.stream().filter(vo -> vo.getId().equals(reasonId)).findFirst().get();
                if (first.isPresent()) {
                    commonVO = first.get();
                } else {
                    commonVO = new BudgetCommonVO();
                    commonVO.setReasonId(reasonId);
                    commonVO.setReasonType(reasonType);
                    commonVOList.add(commonVO);
                }
                commonVO.setContractId(pmsProjectVO.getContractId());
                this.quertyPurchaseDemandAmt(commonVO, (List<ConPurchaseDemandDVO>)purchaseDemandDVOS1);
            });
        }
    }

    void queryhBudgetBatchTimeSheetAmt(List<String> reasonTypes, List<Long> reasonIds, List<BudgetCommonVO> commonVOList) {
        TimesheetQuery query = new TimesheetQuery();
        query.setReasonTypes(reasonTypes);
        query.setReasonIdList(reasonIds);
        query.setTsStatusList(Arrays.asList(TimesheetStatus.APPROVED.getCode(), TimesheetStatus.APPROVING.getCode(), TimesheetStatus.SETTLED.getCode()));
        List<TimesheetVO> timesheetVOS = this.timesheetDAO.queryList(query);
        if (!ObjectUtils.isEmpty(timesheetVOS)) {
            HashMap<String, List> timesheetMap = new HashMap<String, List>();
            timesheetVOS.forEach(vo -> {
                String key = vo.getReasonType() + "-" + vo.getReasonId();
                ArrayList<TimesheetVO> timesheetVOS1 = (ArrayList<TimesheetVO>)timesheetMap.get(key);
                if (timesheetVOS1 == null) {
                    timesheetVOS1 = new ArrayList<TimesheetVO>();
                }
                timesheetVOS1.add((TimesheetVO)vo);
                timesheetMap.put(key, timesheetVOS1);
            });
            timesheetMap.forEach((key, timesheetVOS1) -> {
                BudgetCommonVO commonVO;
                String[] split = key.split("-");
                String reasonType = split[0];
                Long reasonId = Long.valueOf(split[1]);
                Optional<BudgetCommonVO> first = commonVOList.stream().filter(vo -> vo.getReasonType().equals(reasonType) && vo.getReasonId().equals(reasonId)).findFirst();
                if (first.isPresent()) {
                    commonVO = first.get();
                } else {
                    commonVO = new BudgetCommonVO();
                    commonVO.setReasonId(reasonId);
                    commonVO.setReasonType(reasonType);
                    commonVOList.add(commonVO);
                }
                this.queryBudgetTimeSheetAmt(commonVO, (List<TimesheetVO>)timesheetVOS1);
            });
        }
    }

    void queryBudgetBatchReimAmt(List<String> reasonTypes, List<Long> reasonIds, List<BudgetCommonVO> commonVOList) {
        AccReimQuery query = new AccReimQuery();
        query.setReasonIdList(reasonIds);
        query.setReasonTypeList(reasonTypes);
        List<AccReimVO> accReimVOS = this.accReimDAO.queryListDynamic(query);
        HashMap<String, List> accReimVOSMap = new HashMap<String, List>();
        if (!ObjectUtils.isEmpty(accReimVOS)) {
            accReimVOS.forEach(vo -> {
                String key = vo.getReasonType() + "-" + vo.getReasonId();
                ArrayList<AccReimVO> accReimVOS1 = (ArrayList<AccReimVO>)accReimVOSMap.get(key);
                if (accReimVOS1 == null) {
                    accReimVOS1 = new ArrayList<AccReimVO>();
                }
                accReimVOS1.add((AccReimVO)vo);
                accReimVOSMap.put(key, accReimVOS1);
            });
            accReimVOSMap.forEach((key, accReimVOS1) -> {
                BudgetCommonVO commonVO;
                String[] split = key.split("-");
                String reasonType = split[0];
                Long reasonId = Long.valueOf(split[1]);
                Optional<BudgetCommonVO> first = commonVOList.stream().filter(vo -> vo.getReasonType().equals(reasonType) && vo.getReasonId().equals(reasonId)).findFirst();
                if (first.isPresent()) {
                    commonVO = first.get();
                } else {
                    commonVO = new BudgetCommonVO();
                    commonVO.setReasonId(reasonId);
                    commonVO.setReasonType(reasonType);
                    commonVOList.add(commonVO);
                }
                this.queryBudgetReimAmt(commonVO, (List<AccReimVO>)accReimVOS1, new Long[0]);
            });
        }
    }

    public BudgetCommonVO queryBudgetEqvaAndAmt(BudgetCommonVO commonVO) {
        this.queryBudgetEqva(commonVO, null);
        this.queryBudgetReimAmt(commonVO, null, new Long[0]);
        this.queryBudgetTimeSheetAmt(commonVO, null);
        this.quertyPurchaseDemandAmt(commonVO, null);
        this.queryPurchaseContractAmt(commonVO, null, new Long[0]);
        this.queryBusitripApplyAmt(commonVO);
        return commonVO;
    }

    void queryBusitripApplyAmt(BudgetCommonVO commonVO) {
    }

    void queryPurchaseContractAmt(BudgetCommonVO commonVO, List<PurchaseContractManagerVO> purchaseContractManagerVOS, Long ... purchaseContractId) {
        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(commonVO.getReasonType())) {
            if (ObjectUtils.isEmpty(purchaseContractManagerVOS)) {
                PurchaseContractManagerQuery query = new PurchaseContractManagerQuery();
                query.setRelatedProjectId(commonVO.getReasonId());
                purchaseContractManagerVOS = this.purchaseContractManagerDAO.queryPurContractInfo(query);
                if (purchaseContractId != null && purchaseContractId.length > 0) {
                    purchaseContractManagerVOS = purchaseContractManagerVOS.stream().filter(vo -> !vo.getId().equals(purchaseContractId[0])).collect(Collectors.toList());
                }
            }
            if (!ObjectUtils.isEmpty(purchaseContractManagerVOS)) {
                List costs;
                log.info("\u91c7\u8d2d\u5408\u540c\uff1a\u9879\u76ee\u623f\u79df&\u9879\u76ee\u6210\u672c\u5360\u7528\u53ca\u4f7f\u7528-\u524d\uff1a{}", (Object)commonVO);
                BigDecimal occupyAmt = commonVO.getOccupyAmt();
                Map accOccupyAmtMap = commonVO.getAccOccupyAmtMap();
                BigDecimal usedAmt = commonVO.getUsedAmt();
                Map accUsedAmtMap = commonVO.getAccUsedAmtMap();
                List<String> status = Arrays.asList("reject", "invalid", "create");
                List rents = purchaseContractManagerVOS.stream().filter(vo -> !status.contains(vo.getContractStatus()) && vo.getBusinessType().equals(PurchaseContractEnum.PurchaseConType.PROJECT_RENT.getCode())).collect(Collectors.toList());
                if (!ObjectUtils.isEmpty(rents)) {
                    PrdSystemSelectionVO systemSelection3 = this.cacheUtil.getSystemSelection("ACC:SUBJECT:REF3");
                    Long budgetItemId3 = 0L;
                    if (systemSelection3 != null && StringUtils.hasText((String)systemSelection3.getExtString1())) {
                        budgetItemId3 = Long.valueOf(systemSelection3.getExtString1());
                    }
                    BigDecimal amt = rents.stream().map(PurchaseContractManagerVO::getAmt).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    BigDecimal useAmt = rents.stream().map(PurchaseContractManagerVO::getPaymentAmt).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    occupyAmt = occupyAmt.add(amt);
                    usedAmt = usedAmt.add(useAmt);
                    BigDecimal accUsedAmt = (BigDecimal)accUsedAmtMap.get(budgetItemId3);
                    if (accUsedAmt == null) {
                        accUsedAmt = BigDecimal.ZERO;
                    }
                    accUsedAmtMap.put(budgetItemId3, accUsedAmt.add(useAmt));
                    BigDecimal accOccupyAmt = (BigDecimal)accOccupyAmtMap.get(budgetItemId3);
                    if (accOccupyAmt == null) {
                        accOccupyAmt = BigDecimal.ZERO;
                    }
                    accOccupyAmtMap.put(budgetItemId3, accOccupyAmt.add(amt));
                }
                if (!ObjectUtils.isEmpty(costs = purchaseContractManagerVOS.stream().filter(vo -> !status.contains(vo.getContractStatus()) && vo.getBusinessType().equals(PurchaseContractEnum.PurchaseConType.PROJECT_COST.getCode())).collect(Collectors.toList()))) {
                    PrdSystemSelectionVO systemSelection4 = this.cacheUtil.getSystemSelection("ACC:SUBJECT:REF4");
                    Long budgetItemId4 = 0L;
                    if (systemSelection4 != null && StringUtils.hasText((String)systemSelection4.getExtString1())) {
                        budgetItemId4 = Long.valueOf(systemSelection4.getExtString1());
                    }
                    BigDecimal amt = rents.stream().map(PurchaseContractManagerVO::getAmt).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    BigDecimal useAmt = rents.stream().map(PurchaseContractManagerVO::getPaymentAmt).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    occupyAmt = occupyAmt.add(amt);
                    usedAmt = usedAmt.add(useAmt);
                    BigDecimal accUsedAmt = (BigDecimal)accUsedAmtMap.get(budgetItemId4);
                    if (accUsedAmt == null) {
                        accUsedAmt = BigDecimal.ZERO;
                    }
                    accUsedAmtMap.put(budgetItemId4, accUsedAmt.add(useAmt));
                    BigDecimal accOccupyAmt = (BigDecimal)accOccupyAmtMap.get(budgetItemId4);
                    if (accOccupyAmt == null) {
                        accOccupyAmt = BigDecimal.ZERO;
                    }
                    accOccupyAmtMap.put(budgetItemId4, accOccupyAmt.add(amt));
                }
                commonVO.setAccOccupyAmtMap(accOccupyAmtMap);
                commonVO.setAccUsedAmtMap(accUsedAmtMap);
                commonVO.setOccupyAmt(occupyAmt);
                commonVO.setUsedAmt(usedAmt);
                log.info("\u91c7\u8d2d\u5408\u540c\uff1a\u9879\u76ee\u623f\u79df&\u9879\u76ee\u6210\u672c\u5360\u7528\u53ca\u4f7f\u7528-\u540e\uff1a{}", (Object)commonVO);
            }
        }
    }

    void quertyPurchaseDemandAmt(BudgetCommonVO commonVO, List<ConPurchaseDemandDVO> conPurchaseDemandDVOS) {
        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(commonVO.getReasonType())) {
            if (ObjectUtils.isEmpty(conPurchaseDemandDVOS) && commonVO.getContractId() != null) {
                conPurchaseDemandDVOS = this.conPurchaseDemandDService.queryListBySaleConIds(Arrays.asList(commonVO.getContractId()));
            }
            log.info("\u9500\u552e\u5408\u540c\u91c7\u8d2d\u9700\u6c42\uff1a\u5916\u5305\u5360\u7528\u53ca\u4f7f\u7528-\u524d\uff1a{}", (Object)commonVO);
            BigDecimal occupyAmt = commonVO.getOccupyAmt();
            Map accOccupyAmtMap = commonVO.getAccOccupyAmtMap();
            BigDecimal usedAmt = commonVO.getUsedAmt();
            Map accUsedAmtMap = commonVO.getAccUsedAmtMap();
            if (!ObjectUtils.isEmpty((Object)conPurchaseDemandDVOS)) {
                PrdSystemSelectionVO systemSelection = this.cacheUtil.getSystemSelection("ACC:SUBJECT:REF2");
                Long budgetItemId = 0L;
                if (systemSelection != null && StringUtils.hasText((String)systemSelection.getExtString1())) {
                    budgetItemId = Long.valueOf(systemSelection.getExtString1());
                }
                BigDecimal taxAmt = conPurchaseDemandDVOS.stream().filter(vo -> StringUtils.hasText((String)vo.getDemandType()) && PurchaseDemandTypeEnum.OUTSOURCING.getCode().equals(vo.getDemandType())).map(ConPurchaseDemandDVO::getTaxAmt).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                usedAmt = usedAmt.add(taxAmt);
                occupyAmt = occupyAmt.add(taxAmt);
                BigDecimal accUsedAmt = (BigDecimal)accUsedAmtMap.get(budgetItemId);
                if (accUsedAmt == null) {
                    accUsedAmt = BigDecimal.ZERO;
                }
                accUsedAmtMap.put(budgetItemId, accUsedAmt.add(taxAmt));
                BigDecimal accOccupyAmt = (BigDecimal)accOccupyAmtMap.get(budgetItemId);
                if (accOccupyAmt == null) {
                    accOccupyAmt = BigDecimal.ZERO;
                }
                accOccupyAmtMap.put(budgetItemId, accOccupyAmt.add(taxAmt));
                commonVO.setAccOccupyAmtMap(accOccupyAmtMap);
                commonVO.setAccUsedAmtMap(accUsedAmtMap);
                commonVO.setOccupyAmt(occupyAmt);
                commonVO.setUsedAmt(usedAmt);
                log.info("\u9500\u552e\u5408\u540c\u91c7\u8d2d\u9700\u6c42\uff1a\u5916\u5305\u5360\u7528\u53ca\u4f7f\u7528-\u540e\uff1a{}", (Object)commonVO);
            }
        }
    }

    void queryBudgetTimeSheetAmt(BudgetCommonVO commonVO, List<TimesheetVO> timesheetVOS) {
        if (ObjectUtils.isEmpty(timesheetVOS)) {
            TimesheetQuery query = new TimesheetQuery();
            query.setReasonType(commonVO.getReasonType());
            query.setReasonId(commonVO.getReasonId());
            query.setTsStatusList(Arrays.asList(TimesheetStatus.APPROVED.getCode(), TimesheetStatus.APPROVING.getCode(), TimesheetStatus.SETTLED.getCode()));
            timesheetVOS = this.timesheetDAO.queryList(query);
        }
        log.info("\u83b7\u5de5\u65f6\u9879\u76ee\u8865\u8d34\u5360\u7528\u53ca\u4f7f\u7528-\u524d\uff1a{}", (Object)commonVO);
        BigDecimal occupyAmt = commonVO.getOccupyAmt();
        Map accOccupyAmtMap = commonVO.getAccOccupyAmtMap();
        BigDecimal usedAmt = commonVO.getUsedAmt();
        Map accUsedAmtMap = commonVO.getAccUsedAmtMap();
        if (!ObjectUtils.isEmpty(timesheetVOS)) {
            PrdSystemSelectionVO systemSelection = this.cacheUtil.getSystemSelection("ACC:SUBJECT:REF1");
            Long budgetItemId = 0L;
            if (systemSelection != null && StringUtils.hasText((String)systemSelection.getExtString1())) {
                budgetItemId = Long.valueOf(systemSelection.getExtString1());
            }
            BigDecimal taxAmt = timesheetVOS.stream().map(TimesheetVO::getSubsidyAmt).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            usedAmt = usedAmt.add(taxAmt);
            occupyAmt = occupyAmt.add(taxAmt);
            BigDecimal accUsedAmt = (BigDecimal)accUsedAmtMap.get(budgetItemId);
            if (accUsedAmt == null) {
                accUsedAmt = BigDecimal.ZERO;
            }
            accUsedAmtMap.put(budgetItemId, accUsedAmt.add(taxAmt));
            BigDecimal accOccupyAmt = (BigDecimal)accOccupyAmtMap.get(budgetItemId);
            if (accOccupyAmt == null) {
                accOccupyAmt = BigDecimal.ZERO;
            }
            accOccupyAmtMap.put(budgetItemId, accOccupyAmt.add(taxAmt));
            commonVO.setAccOccupyAmtMap(accOccupyAmtMap);
            commonVO.setAccUsedAmtMap(accUsedAmtMap);
            commonVO.setOccupyAmt(occupyAmt);
            commonVO.setUsedAmt(usedAmt);
            log.info("\u83b7\u5de5\u65f6\u9879\u76ee\u8865\u8d34\u5360\u7528\u53ca\u4f7f\u7528-\u540e\uff1a{}", (Object)commonVO);
        }
    }

    void queryBudgetReimAmt(BudgetCommonVO commonVO, List<AccReimVO> accReimVOS, Long ... reimId) {
        List<Long> reimIds;
        if (ObjectUtils.isEmpty(accReimVOS)) {
            AccReimQuery query = new AccReimQuery();
            query.setReasonId(commonVO.getReasonId());
            query.setReasonType(commonVO.getReasonType());
            if (reimId != null && reimId.length > 0) {
                query.setNotId(reimId[0]);
            }
            query.setNotReimStatusList(Arrays.asList(AccReimDocStatusEnum.CREATE.getCode()));
            accReimVOS = this.accReimDAO.queryListDynamic(query);
        }
        log.info("\u83b7\u53d6\u62a5\u9500\u8d39\u7528\u5360\u7528\u53ca\u4f7f\u7528-\u524d\uff1a{}", (Object)commonVO);
        BigDecimal occupyAmt = commonVO.getOccupyAmt();
        Map accOccupyAmtMap = commonVO.getAccOccupyAmtMap();
        BigDecimal usedAmt = commonVO.getUsedAmt();
        Map accUsedAmtMap = commonVO.getAccUsedAmtMap();
        if (!ObjectUtils.isEmpty(accReimVOS) && !ObjectUtils.isEmpty(reimIds = accReimVOS.stream().filter(vo -> !vo.getReimStatus().equals(AccReimDocStatusEnum.CREATE.getCode())).map(BaseViewModel::getId).collect(Collectors.toList()))) {
            BigDecimal amt;
            List<AccReimDetailVO> accReimDetailVOS = this.detailDAO.queryByMasIds(reimIds);
            ArrayList usedDetails = new ArrayList();
            ArrayList occupyDetails = new ArrayList();
            accReimVOS.forEach(vo -> {
                List details = accReimDetailVOS.stream().filter(detailVO -> detailVO.getMasId().equals(vo.getId())).collect(Collectors.toList());
                occupyDetails.addAll(details);
                if (vo.getReimStatus().equals(AccReimDocStatusEnum.APPROVED.getCode())) {
                    usedDetails.addAll(details);
                }
            });
            for (AccReimDetailVO infoVO : usedDetails) {
                amt = infoVO.getReimAmt();
                if (infoVO.getAdjustAmt() != null) {
                    amt = infoVO.getAdjustAmt();
                }
                usedAmt = usedAmt.add(amt);
                if (infoVO.getBudgetItemId() == null) continue;
                BigDecimal accUsedAmt = (BigDecimal)accUsedAmtMap.get(infoVO.getBudgetItemId());
                if (accUsedAmt == null) {
                    accUsedAmt = BigDecimal.ZERO;
                }
                accUsedAmtMap.put(infoVO.getBudgetItemId(), accUsedAmt.add(amt));
            }
            for (AccReimDetailVO infoVO : occupyDetails) {
                amt = infoVO.getReimAmt();
                if (infoVO.getAdjustAmt() != null) {
                    amt = infoVO.getAdjustAmt();
                }
                occupyAmt = occupyAmt.add(amt);
                if (infoVO.getBudgetItemId() == null) continue;
                BigDecimal accOccupyAmt = (BigDecimal)accOccupyAmtMap.get(infoVO.getBudgetItemId());
                if (accOccupyAmt == null) {
                    accOccupyAmt = BigDecimal.ZERO;
                }
                accOccupyAmtMap.put(infoVO.getBudgetItemId(), accOccupyAmt.add(amt));
            }
        }
        commonVO.setAccOccupyAmtMap(accOccupyAmtMap);
        commonVO.setAccUsedAmtMap(accUsedAmtMap);
        commonVO.setOccupyAmt(occupyAmt);
        commonVO.setUsedAmt(usedAmt);
        log.info("\u83b7\u53d6\u62a5\u9500\u8d39\u7528\u5360\u7528\u53ca\u4f7f\u7528-\u540e\uff1a{}", (Object)commonVO);
    }

    public void queryBudgetEqva(BudgetCommonVO commonVO, List<TaskSettleTimesheetVO> taskTimesheetVOS) {
        if (taskTimesheetVOS == null) {
            taskTimesheetVOS = this.taskSettleTimesheetDAO.queryTaskByReason(commonVO.getReasonType(), commonVO.getReasonId());
        }
        BigDecimal occupyEqva = BigDecimal.ZERO;
        BigDecimal usedEqva = BigDecimal.ZERO;
        HashMap<Long, BigDecimal> actOccupyEqvaMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> actUsedEqvaMap = new HashMap<Long, BigDecimal>();
        if (!ObjectUtils.isEmpty(taskTimesheetVOS)) {
            for (TaskSettleTimesheetVO infoVO : taskTimesheetVOS) {
                BigDecimal totalEqva = infoVO.getEqva() == null ? BigDecimal.ZERO : infoVO.getEqva();
                occupyEqva = occupyEqva.add(totalEqva);
                BigDecimal useEqva = BigDecimal.ZERO;
                if (infoVO.getSettleFlag() != null && (infoVO.getSettleFlag() == 0 || infoVO.getSettleFlag() == 1)) {
                    useEqva = totalEqva;
                }
                usedEqva = usedEqva.add(useEqva);
                if (infoVO.getRelatedActId() == null) continue;
                BigDecimal actOccupyEqva = (BigDecimal)actOccupyEqvaMap.get(infoVO.getRelatedActId());
                if (actOccupyEqva == null) {
                    actOccupyEqva = BigDecimal.ZERO;
                }
                actOccupyEqvaMap.put(infoVO.getRelatedActId(), actOccupyEqva.add(totalEqva));
                BigDecimal actUsedEqva = (BigDecimal)actUsedEqvaMap.get(infoVO.getRelatedActId());
                if (actUsedEqva == null) {
                    actUsedEqva = BigDecimal.ZERO;
                }
                actUsedEqvaMap.put(infoVO.getRelatedActId(), actUsedEqva.add(usedEqva));
            }
        }
        commonVO.setActOccupyEqvaMap(actOccupyEqvaMap);
        commonVO.setActUsedEqvaMap(actUsedEqvaMap);
        commonVO.setOccupyEqva(occupyEqva);
        commonVO.setUsedEqva(usedEqva);
    }

    public void countTotalChange(BudgetVO budgetVO) {
        if (budgetVO.getVersionNo() != null && budgetVO.getVersionNo() > 0) {
            budgetVO.setPlanAmtChange(budgetVO.getPlanAmt().subtract(budgetVO.getOriginalPlanAmt()));
            budgetVO.setPlanEqvaChange(budgetVO.getPlanEqva().subtract(budgetVO.getOriginalPlanEqva()));
            budgetVO.setPlanEqvaAmtChange(budgetVO.getPlanEqvaAmt().subtract(budgetVO.getOriginalPlanEqvaAmt()));
            budgetVO.setTotalAmtChange(budgetVO.getTotalAmt().subtract(budgetVO.getOriginalTotalAmt()));
        } else {
            budgetVO.setPlanAmtChange(BigDecimal.ZERO);
            budgetVO.setPlanEqvaChange(BigDecimal.ZERO);
            budgetVO.setPlanEqvaAmtChange(BigDecimal.ZERO);
            budgetVO.setTotalAmtChange(BigDecimal.ZERO);
        }
    }

    public BigDecimal getReceivedRate(Long saleConId) {
        List receivablePlanVOS = this.conReceivablePlanService.queryBySaleConId(saleConId);
        BigDecimal receAmt = receivablePlanVOS.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getReceAmt())).map(ConReceivablePlanVO::getReceAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal alreadyReceAmt = receivablePlanVOS.stream().map(ConReceivablePlanVO::getActualRecvAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal receivedRate = BigDecimal.ZERO;
        if (receAmt.doubleValue() > 0.0) {
            receivedRate = alreadyReceAmt.divide(receAmt, 4, RoundingMode.HALF_UP);
        }
        return receivedRate;
    }

    BigDecimal getValue(BigDecimal value) {
        return value == null ? BigDecimal.ZERO : value;
    }

    public void checkOnlyOneProc(BudgetVO budgetVO) {
        if (!ObjectUtils.isEmpty((Object)budgetVO.getProcInstId()) && !WorkFlowStatusEnum.APPROVED_WORK.getCode().equals(budgetVO.getBudgetStatus())) {
            throw TwException.error("", "\u7b2c\u4e00\u6b21\u9884\u7b97\u5ba1\u6279\u6d41\u7a0b\u8fd8\u672a\u8d70\u5b8c\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u7533\u8bf7");
        }
        ComChangeQuery changeQuery = new ComChangeQuery();
        changeQuery.setChangeType(ChangeTypeEnum.BUDGET_CHANGE.getCode());
        changeQuery.setChangeDocId(budgetVO.getId().toString());
        List changeVOS = this.changeService.changeSearch(changeQuery);
        long count = changeVOS.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getProcInstId()) && !WorkFlowStatusEnum.APPROVED_WORK.getCode().equals(v.getChangeStatus())).count();
        if (count > 0L) {
            throw TwException.error("", "\u4e0a\u4e00\u6b21\u7684\u9884\u7b97\u53d8\u66f4\u6d41\u7a0b\u8fd8\u672a\u8d70\u5b8c\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u53d8\u66f4");
        }
    }

    public Boolean isInnerProject(String platType) {
        return SaleConEnum.FICTITIOUS.getCode().equals(platType);
    }

    public Boolean isExternalProject(String platType) {
        return SaleConEnum.INTERNAL.getCode().equals(platType) || SaleConEnum.EXTERNAL.getCode().equals(platType) || SaleConEnum.NO_CONTRACT_VIRTUAL_CONTRACT.getCode().equals(platType);
    }

    public Boolean isExternalContractProject(String platType, String contractStatus) {
        return this.isExternalProject(platType) != false && "ACTIVE".equals(contractStatus);
    }

    public Boolean isExternalNoContractProject(String platType, String contractStatus) {
        return SaleConEnum.NO_CONTRACT_VIRTUAL_CONTRACT.getCode().equals(platType) && "ACTIVE_WAITING".equals(contractStatus);
    }

    public void countCurrentChange(BudgetVO currentVersionBudge) {
        BudgetVO budgetVO = this.budgetDAO.queryByKey(currentVersionBudge.getId());
        currentVersionBudge.setCurrentPlanAmtChange(currentVersionBudge.getPlanAmt().subtract(budgetVO.getPlanAmt()));
        currentVersionBudge.setCurrentPlanEqvaChange(currentVersionBudge.getPlanEqva().subtract(budgetVO.getPlanEqva()));
        currentVersionBudge.setCurrentPlanEqvaAmtChange(currentVersionBudge.getPlanEqvaAmt().subtract(budgetVO.getPlanEqvaAmt()));
        currentVersionBudge.setCurrentTotalAmtChange(currentVersionBudge.getTotalAmt().subtract(budgetVO.getTotalAmt()));
        currentVersionBudge.setPlanAmtChange(currentVersionBudge.getPlanAmt().subtract(budgetVO.getOriginalPlanAmt()));
        currentVersionBudge.setPlanEqvaChange(currentVersionBudge.getPlanEqva().subtract(budgetVO.getOriginalPlanEqva()));
        currentVersionBudge.setPlanEqvaAmtChange(currentVersionBudge.getPlanEqvaAmt().subtract(budgetVO.getOriginalPlanEqvaAmt()));
        currentVersionBudge.setTotalAmtChange(currentVersionBudge.getTotalAmt().subtract(budgetVO.getOriginalTotalAmt()));
    }

    public void checkBudgetEqva(Long reasonId, String reasonType, Long relatedActId, BigDecimal eqva) {
        if (ObjectUtils.isEmpty((Object)reasonType)) {
            throw TwException.error("", "\u4e8b\u7531\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            BudgetVO budgetVO = this.querySimpleBySource(reasonId, reasonType);
            if (ObjectUtils.isEmpty((Object)budgetVO)) {
                throw TwException.error("", "\u9884\u7b97\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (!WorkFlowStatusEnum.APPROVED_WORK.getCode().equals(budgetVO.getBudgetStatus())) {
                throw TwException.error("", "\u9884\u7b97\u8fd8\u672a\u5ba1\u6279\u901a\u8fc7\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (BudgetControlType.STIFFNESS.getCode().equals(budgetVO.getControlType())) {
                PmsProjectActivityVO activityVO;
                if (ObjectUtils.isEmpty((Object)budgetVO.getPlanEqva())) {
                    throw TwException.error("", "\u8be5\u9879\u76ee\u9884\u7b97\u5f53\u91cf\u4e0d\u8db3\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                BudgetCommonVO commonVO = new BudgetCommonVO();
                commonVO.setReasonId(reasonId);
                commonVO.setReasonType(reasonType);
                this.queryBudgetEqva(commonVO, null);
                if (eqva.compareTo(budgetVO.getPlanEqva().subtract(commonVO.getOccupyEqva()).subtract(commonVO.getUsedEqva())) > 0) {
                    throw TwException.error("", "\u8be5\u9879\u76ee\u9884\u7b97\u5f53\u91cf\u4e0d\u8db3\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                if (!ObjectUtils.isEmpty((Object)relatedActId) && !ObjectUtils.isEmpty((Object)(activityVO = this.pmsProjectActivityService.queryByKey(relatedActId)).getDetailControlFlag()) && activityVO.getDetailControlFlag().booleanValue()) {
                    BigDecimal actOccupyEqva;
                    if (ObjectUtils.isEmpty((Object)activityVO.getPlanEqva())) {
                        throw TwException.error("", "\u8be5\u6d3b\u52a8\u9884\u7b97\u5f53\u91cf\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                    BigDecimal actUsedEqva = commonVO.getActUsedEqvaMap().get(relatedActId) == null ? BigDecimal.ZERO : (BigDecimal)commonVO.getActUsedEqvaMap().get(relatedActId);
                    BigDecimal bigDecimal = actOccupyEqva = commonVO.getActOccupyEqvaMap().get(relatedActId) == null ? BigDecimal.ZERO : (BigDecimal)commonVO.getActOccupyEqvaMap().get(relatedActId);
                    if (eqva.compareTo(activityVO.getPlanEqva().subtract(actOccupyEqva).subtract(actUsedEqva)) > 0) {
                        log.info("\u6d3e\u53d1\u5f53\u91cf:" + eqva + " /\u5df2\u62e8\u4ed8\u5f53\u91cf\uff1a" + activityVO.getAllocateEqva() + " /\u5360\u7528\u5f53\u91cf\uff1a" + actOccupyEqva + " /\u4f7f\u7528\u5f53\u91cf\uff1a" + actUsedEqva);
                        throw TwException.error("", "\u8be5\u6d3b\u52a8\u9884\u7b97\u5f53\u91cf\u4e0d\u8db3\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                }
            }
        }
    }

    public void checkBudgetReimAmt(Long reasonId, String reasonType, Long budgetItemId, BigDecimal amt, Long ... reimId) {
        if (ObjectUtils.isEmpty((Object)reasonType)) {
            throw TwException.error("", "\u4e8b\u7531\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            BudgetVO budgetVO = this.querySimpleBySource(reasonId, reasonType);
            if (ObjectUtils.isEmpty((Object)budgetVO)) {
                throw TwException.error("", "\u9884\u7b97\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (!WorkFlowStatusEnum.APPROVED_WORK.getCode().equals(budgetVO.getBudgetStatus())) {
                throw TwException.error("", "\u9884\u7b97\u8fd8\u672a\u5ba1\u6279\u901a\u8fc7\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (BudgetControlType.STIFFNESS.getCode().equals(budgetVO.getControlType())) {
                if (ObjectUtils.isEmpty((Object)budgetVO.getPlanAmt())) {
                    throw TwException.error("", "\u9884\u7b97\u8d39\u7528\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                BudgetCommonVO commonVO = new BudgetCommonVO();
                commonVO.setReasonId(reasonId);
                commonVO.setReasonType(reasonType);
                this.queryBudgetReimAmt(commonVO, null, reimId);
                if (amt.compareTo(budgetVO.getPlanAmt().subtract(commonVO.getOccupyAmt())) > 0) {
                    throw TwException.error("", "\u9884\u7b97\u8d39\u7528\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                if (!ObjectUtils.isEmpty((Object)budgetItemId)) {
                    BudgetSubjectDetailVO budgetSubjectDetailVO = this.budgetSubjectDetailDAO.queryByBudgetItemId(budgetItemId);
                    if (budgetSubjectDetailVO == null) {
                        throw TwException.error("", "\u8d39\u7528\u660e\u7ec6\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                    if (!ObjectUtils.isEmpty((Object)budgetSubjectDetailVO.getDetailControlFlag()) && budgetSubjectDetailVO.getDetailControlFlag().booleanValue()) {
                        BigDecimal actcccupyAmt;
                        if (ObjectUtils.isEmpty((Object)budgetSubjectDetailVO.getBudgetAmt())) {
                            throw TwException.error("", budgetSubjectDetailVO.getAccName() + "-\u79d1\u76ee\u9884\u7b97\u8d39\u7528\u4e0d\u8db3\uff0c\u8bf7\u6838\u9a8c\uff01");
                        }
                        BigDecimal bigDecimal = actcccupyAmt = commonVO.getAccOccupyAmtMap().get(budgetItemId) == null ? BigDecimal.ZERO : (BigDecimal)commonVO.getAccOccupyAmtMap().get(budgetItemId);
                        if (amt.compareTo(budgetSubjectDetailVO.getBudgetAmt().subtract(actcccupyAmt)) > 0) {
                            throw TwException.error("", budgetSubjectDetailVO.getAccName() + "-\u79d1\u76ee\u9884\u7b97\u8d39\u7528\u4e0d\u8db3\uff0c\u8bf7\u6838\u9a8c\uff01");
                        }
                    }
                }
            }
        }
    }

    public BudgetCommonServiceImpl(BudgetDAO budgetDAO, PmsProjectActivityService pmsProjectActivityService, BudgetSubjectDetailDAO budgetSubjectDetailDAO, TransactionUtilService transactionUtilService, ConReceivablePlanService conReceivablePlanService, PrdSystemRoleDAO daoRole, PrdMessageConfigService messageConfigService, ComChangeService changeService, PmsProjectService pmsProjectService, BuProjectService buProjectService, PurchaseContractManagerDAO purchaseContractManagerDAO, AccSubjectTemplateService accSubjectTemplateService, TaskInfoDAO taskInfoDAO, AccReimDAO accReimDAO, AccReimDetailDAO detailDAO, TaskSettleTimesheetDAO taskSettleTimesheetDAO, CacheUtil cacheUtil, ConPurchaseDemandDService conPurchaseDemandDService, TimesheetDAO timesheetDAO) {
        this.budgetDAO = budgetDAO;
        this.pmsProjectActivityService = pmsProjectActivityService;
        this.budgetSubjectDetailDAO = budgetSubjectDetailDAO;
        this.transactionUtilService = transactionUtilService;
        this.conReceivablePlanService = conReceivablePlanService;
        this.daoRole = daoRole;
        this.messageConfigService = messageConfigService;
        this.changeService = changeService;
        this.pmsProjectService = pmsProjectService;
        this.buProjectService = buProjectService;
        this.purchaseContractManagerDAO = purchaseContractManagerDAO;
        this.accSubjectTemplateService = accSubjectTemplateService;
        this.taskInfoDAO = taskInfoDAO;
        this.accReimDAO = accReimDAO;
        this.detailDAO = detailDAO;
        this.taskSettleTimesheetDAO = taskSettleTimesheetDAO;
        this.cacheUtil = cacheUtil;
        this.conPurchaseDemandDService = conPurchaseDemandDService;
        this.timesheetDAO = timesheetDAO;
    }
}

