/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmPeopleQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPeopleVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmPeopleDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustomerOperationDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustomerOperationMemberDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmLeadsDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOperationPlanDetailDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmPeopleDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmPeopleRepo;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBusinessPartnerDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.QBusinessCustomerInfoDO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Repository
public class CrmPeopleDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmPeopleRepo repo;
    private final QCrmPeopleDO qdo = QCrmPeopleDO.crmPeopleDO;
    private final QCrmCustomerOperationDO qdoOperation = QCrmCustomerOperationDO.crmCustomerOperationDO;
    private final QCrmCustomerOperationMemberDO qdoOperationMember = QCrmCustomerOperationMemberDO.crmCustomerOperationMemberDO;
    private final QCrmOperationPlanDetailDO qdoOperationPlanDetail = QCrmOperationPlanDetailDO.crmOperationPlanDetailDO;
    private final QCrmLeadsDO qdoLeads = QCrmLeadsDO.crmLeadsDO;
    private final QCrmOpportunityDO qdoOpportunity = QCrmOpportunityDO.crmOpportunityDO;
    private final QBusinessPartnerDO qBusinessPartnerDO = QBusinessPartnerDO.businessPartnerDO;
    private final QBusinessCustomerInfoDO qBusinessCustomerInfoDO = QBusinessCustomerInfoDO.businessCustomerInfoDO;

    public List<Long> queryOperationIds(Long userId, Set<Long> empRefUserIdList, Set<Long> orgIdList) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qdoOperation.id).from((EntityPath)this.qdoOperation)).leftJoin((EntityPath)this.qdoOperationMember)).on((Predicate)this.qdoOperationMember.operId.eq(this.qdoOperation.id).and((Predicate)this.qdoOperationMember.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qdoOperationPlanDetail)).on((Predicate)this.qdoOperationPlanDetail.operId.eq(this.qdoOperation.id).and((Predicate)this.qdoOperationPlanDetail.deleteFlag.eq((Object)0)));
        BooleanExpression jpaQueryOr = this.qdoOperationMember.userId.eq((Object)userId).or((Predicate)this.qdoOperationPlanDetail.performerId.eq((Object)userId)).or((Predicate)this.qdoOperation.createUserId.eq((Object)userId)).or((Predicate)this.qdoOperation.saleOperManagerId.eq((Object)userId)).or((Predicate)this.qdoOperation.custOperManagerId.eq((Object)userId)).or((Predicate)this.qdoOperation.channelUserId.eq((Object)userId)).or((Predicate)this.qdoOperation.productUserId.eq((Object)userId)).or((Predicate)this.qdoOperation.serviceUserId.eq((Object)userId)).or((Predicate)this.qdoOperation.businessUserId.eq((Object)userId)).or((Predicate)this.qdoOperation.careUserId.eq((Object)userId)).or((Predicate)this.qdoOperation.operationUserId.eq((Object)userId));
        if (!CollectionUtils.isEmpty(empRefUserIdList)) {
            jpaQueryOr = jpaQueryOr.or((Predicate)this.qdoOperation.serviceUserId.in(empRefUserIdList)).or((Predicate)this.qdoOperation.businessUserId.in(empRefUserIdList)).or((Predicate)this.qdoOperation.careUserId.in(empRefUserIdList)).or((Predicate)this.qdoOperation.operationUserId.in(empRefUserIdList));
        }
        if (!CollectionUtils.isEmpty(orgIdList)) {
            jpaQueryOr = jpaQueryOr.or((Predicate)this.qdoOperation.custOperBu.in(orgIdList)).or((Predicate)this.qdoOperation.saleOperBu.in(orgIdList));
        }
        ((JPAQuery)jpaQuery.where((Predicate)jpaQueryOr)).where((Predicate)this.qdoOperation.deleteFlag.eq((Object)0));
        return ((JPAQuery)jpaQuery.distinct()).fetch();
    }

    private JPAQuery<CrmPeopleVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmPeopleVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.operId, this.qdo.customerId, this.qdo.peopleName, this.qdo.jobs, this.qdo.birthday, this.qdo.companyName, this.qdoOperation.custType, this.qdoOperation.custName.as("operationName"), this.qBusinessPartnerDO.partnerName.as("customerName"), this.qdo.sex, this.qdo.email, this.qdo.loveLevel, this.qdo.mobile, this.qdo.tags, this.qdo.locationDetail, this.qdo.remark, this.qdo.weChat, this.qdo.jobDetail, this.qdo.industry, this.qdo.industryInfluence, this.qdo.birthplace, this.qdo.bu, this.qdo.socialIdentity, this.qdo.marital, this.qdo.spouseJobs, this.qdo.childAge, this.qdo.parentHealth, this.qdo.parentHabitation, this.qdo.peopleStatus, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoOperation)).on((Predicate)this.qdo.operId.eq(this.qdoOperation.id))).leftJoin((EntityPath)this.qBusinessPartnerDO)).on((Predicate)this.qdo.customerId.eq(this.qBusinessPartnerDO.id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery;
    }

    public CrmPeopleVO queryByKey(Long id) {
        JPAQuery<CrmPeopleVO> jpaQuerySelect = this.getJpaQuerySelect();
        ((JPAQuery)jpaQuerySelect.where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.id.eq((Object)id));
        return (CrmPeopleVO)jpaQuerySelect.fetchFirst();
    }

    public List<CrmPeopleVO> queryListByKeys(List<Long> ids) {
        JPAQuery<CrmPeopleVO> jpaQuerySelect = this.getJpaQuerySelect();
        ((JPAQuery)jpaQuerySelect.where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.id.in(ids));
        return jpaQuerySelect.fetch();
    }

    public CrmPeopleDO findByIdAndDeleteFlag(Long id) {
        return (CrmPeopleDO)((Object)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo).from((EntityPath)this.qdo)).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.id.eq((Object)id))).fetchFirst());
    }

    public List<CrmPeopleVO> queryList(Long operId, Long customerId) {
        JPAQuery<CrmPeopleVO> jpaQuerySelect = this.getJpaQuerySelect();
        jpaQuerySelect.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        if (!ObjectUtils.isEmpty((Object)customerId)) {
            jpaQuerySelect.where((Predicate)this.qdo.customerId.eq((Object)customerId));
        } else {
            jpaQuerySelect.where((Predicate)this.qdo.operId.eq((Object)operId));
        }
        return jpaQuerySelect.fetch();
    }

    public List<CrmPeopleVO> queryListByOperIds(List<Long> operIds) {
        JPAQuery<CrmPeopleVO> jpaQuerySelect = this.getJpaQuerySelect();
        jpaQuerySelect.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        jpaQuerySelect.where((Predicate)this.qdo.operId.in(operIds));
        return jpaQuerySelect.fetch();
    }

    public PagingVO<CrmPeopleVO> paging(CrmPeopleQuery query) {
        JPAQuery<CrmPeopleVO> jpaQuerySelect = this.getJpaQuerySelect();
        jpaQuerySelect.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        if (StringUtils.hasText((String)query.getPeopleName())) {
            jpaQuerySelect.where((Predicate)this.qdo.peopleName.like(SqlUtil.toSqlLikeString(query.getPeopleName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerId()) && !ObjectUtils.isEmpty((Object)query.getOperId())) {
            jpaQuerySelect.where((Predicate)this.qdo.customerId.eq((Object)query.getCustomerId()).or((Predicate)this.qdo.operId.eq((Object)query.getOperId())));
        } else if (!ObjectUtils.isEmpty((Object)query.getCustomerId())) {
            jpaQuerySelect.where((Predicate)this.qdo.customerId.eq((Object)query.getCustomerId()));
        } else if (!ObjectUtils.isEmpty((Object)query.getOperId())) {
            jpaQuerySelect.where((Predicate)this.qdo.operId.eq((Object)query.getOperId()));
        }
        if (!query.getNoPermissionFlag().booleanValue()) {
            BooleanExpression jpaQueryOr = this.qdo.createUserId.eq((Object)query.getCreateUserId());
            if (!ObjectUtils.isEmpty((Object)query.getOperIds())) {
                jpaQueryOr = jpaQueryOr.or((Predicate)this.qdo.operId.in((Collection)query.getOperIds()));
            }
            if (!ObjectUtils.isEmpty((Object)query.getCustomerIds())) {
                jpaQueryOr = jpaQueryOr.or((Predicate)this.qdo.customerId.in((Collection)query.getCustomerIds()));
            }
            jpaQuerySelect.where((Predicate)jpaQueryOr);
        }
        if (StringUtils.hasText((String)query.getCustomerName())) {
            jpaQuerySelect.where((Predicate)this.qdoOperation.custName.like(SqlUtil.toSqlLikeString(query.getPeopleName())).or((Predicate)this.qBusinessPartnerDO.partnerName.like(SqlUtil.toSqlLikeString(query.getPeopleName())).and((Predicate)this.qBusinessPartnerDO.customerFlag.eq(Boolean.valueOf(true)))));
        }
        if (StringUtils.hasText((String)query.getPeopleStatus())) {
            jpaQuerySelect.where((Predicate)this.qdo.peopleStatus.eq((Object)query.getPeopleStatus()));
        }
        if (StringUtils.hasText((String)query.getBu())) {
            jpaQuerySelect.where((Predicate)this.qdo.bu.like(SqlUtil.toSqlLikeString(query.getBu())));
        }
        if (StringUtils.hasText((String)query.getJobs())) {
            jpaQuerySelect.where((Predicate)this.qdo.jobs.like(SqlUtil.toSqlLikeString(query.getJobs())));
        }
        if (StringUtils.hasText((String)query.getIndustry())) {
            jpaQuerySelect.where((Predicate)this.qdo.industry.eq((Object)query.getIndustry()));
        }
        if (StringUtils.hasText((String)query.getWeChat())) {
            jpaQuerySelect.where((Predicate)this.qdo.weChat.like(SqlUtil.toSqlLikeString(query.getWeChat())));
        }
        if (StringUtils.hasText((String)query.getEmail())) {
            jpaQuerySelect.where((Predicate)this.qdo.email.like(SqlUtil.toSqlLikeString(query.getEmail())));
        }
        if (StringUtils.hasText((String)query.getMobile())) {
            jpaQuerySelect.where((Predicate)this.qdo.mobile.like(SqlUtil.toSqlLikeString(query.getMobile())));
        }
        if (StringUtils.hasText((String)query.getLocationDetail())) {
            jpaQuerySelect.where((Predicate)this.qdo.locationDetail.like(SqlUtil.toSqlLikeString(query.getLocationDetail())));
        }
        jpaQuerySelect.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuerySelect.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public void deleteByIdIn(List<Long> keys) {
        JPAUpdateClause where = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        where.execute();
    }

    public void relationCustomer(List<Long> ids, Long customerId) {
        JPAUpdateClause where = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.customerId, (Object)customerId).where(new Predicate[]{this.qdo.id.in(ids)});
        where.execute();
    }

    public List<Long> findByOperIdAndDeleteFlag(Long operId) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qdo.id).from((EntityPath)this.qdo)).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.operId.eq((Object)operId))).fetch();
    }

    public void removeAllByIdIn(List<Long> keys) {
        JPAUpdateClause where = this.jpaQueryFactory.update((EntityPath)this.qdo).setNull(this.qdo.customerId).setNull((Path)this.qdo.companyName).setNull(this.qdo.operId).where(new Predicate[]{this.qdo.id.in(keys)});
        where.execute();
    }

    public void removeOperByIdIn(List<Long> keys) {
        JPAUpdateClause where = this.jpaQueryFactory.update((EntityPath)this.qdo).setNull((Path)this.qdo.companyName).setNull(this.qdo.operId).where(new Predicate[]{this.qdo.id.in(keys)});
        where.execute();
    }

    public long updateLoveLevel(Long key, Integer level) {
        JPAUpdateClause where = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.loveLevel, (Object)level).where(new Predicate[]{this.qdo.id.eq((Object)key)});
        return where.execute();
    }

    public List<CrmPeopleVO> queryPeopleVOType1(Long id, String industry, String searchStr) {
        JPAQuery<CrmPeopleVO> jpaQuerySelect = this.getJpaQuerySelect();
        ((JPAQuery)((JPAQuery)jpaQuerySelect.where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.industry.eq((Object)industry))).where((Predicate)this.qdo.id.ne((Object)id));
        if (StringUtils.hasText((String)searchStr)) {
            jpaQuerySelect.where((Predicate)this.qdo.jobs.like(SqlUtil.toSqlLikeString(searchStr)).or((Predicate)this.qdo.peopleName.like(SqlUtil.toSqlLikeString(searchStr))).or((Predicate)this.qdo.companyName.like(SqlUtil.toSqlLikeString(searchStr))).or((Predicate)this.qdoOperation.custName.like(SqlUtil.toSqlLikeString(searchStr))).or((Predicate)this.qBusinessPartnerDO.partnerName.like(SqlUtil.toSqlLikeString(searchStr))));
        }
        return jpaQuerySelect.fetch();
    }

    public List<CrmPeopleVO> queryPeopleVOType2(Long id, Long operId, Long partnerId, String companyName, String searchStr) {
        JPAQuery<CrmPeopleVO> jpaQuerySelect = this.getJpaQuerySelect();
        ((JPAQuery)jpaQuerySelect.where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.id.ne((Object)id));
        if (operId != null && partnerId != null) {
            jpaQuerySelect.where((Predicate)this.qdo.operId.eq((Object)operId).or((Predicate)this.qdo.customerId.eq((Object)partnerId)));
        } else if (operId != null) {
            jpaQuerySelect.where((Predicate)this.qdo.operId.eq((Object)operId));
        } else if (partnerId != null) {
            jpaQuerySelect.where((Predicate)this.qdo.customerId.eq((Object)partnerId));
        } else {
            jpaQuerySelect.where((Predicate)this.qdo.companyName.eq((Object)companyName));
        }
        if (StringUtils.hasText((String)searchStr)) {
            jpaQuerySelect.where((Predicate)this.qdo.jobs.like(SqlUtil.toSqlLikeString(searchStr)).or((Predicate)this.qdo.peopleName.like(SqlUtil.toSqlLikeString(searchStr))).or((Predicate)this.qdo.companyName.like(SqlUtil.toSqlLikeString(searchStr))).or((Predicate)this.qdoOperation.custName.like(SqlUtil.toSqlLikeString(searchStr))).or((Predicate)this.qBusinessPartnerDO.partnerName.like(SqlUtil.toSqlLikeString(searchStr))));
        }
        return jpaQuerySelect.fetch();
    }

    public List<CrmPeopleVO> queryPeopleVOType3(Long id, List<Long> customerIds, List<String> companyNames, String searchStr) {
        JPAQuery<CrmPeopleVO> jpaQuerySelect = this.getJpaQuerySelect();
        ((JPAQuery)jpaQuerySelect.where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.id.ne((Object)id));
        if (!ObjectUtils.isEmpty(customerIds) && !ObjectUtils.isEmpty(companyNames)) {
            jpaQuerySelect.where((Predicate)this.qdo.customerId.in(customerIds).or((Predicate)this.qdo.companyName.in(companyNames)));
        } else if (!ObjectUtils.isEmpty(customerIds)) {
            jpaQuerySelect.where((Predicate)this.qdo.customerId.in(customerIds));
        } else if (!ObjectUtils.isEmpty(companyNames)) {
            jpaQuerySelect.where((Predicate)this.qdo.companyName.in(companyNames));
        }
        if (StringUtils.hasText((String)searchStr)) {
            jpaQuerySelect.where((Predicate)this.qdo.jobs.like(SqlUtil.toSqlLikeString(searchStr)).or((Predicate)this.qdo.peopleName.like(SqlUtil.toSqlLikeString(searchStr))).or((Predicate)this.qdo.companyName.like(SqlUtil.toSqlLikeString(searchStr))).or((Predicate)this.qdoOperation.custName.like(SqlUtil.toSqlLikeString(searchStr))).or((Predicate)this.qBusinessPartnerDO.partnerName.like(SqlUtil.toSqlLikeString(searchStr))));
        }
        return jpaQuerySelect.fetch();
    }

    public List<Long> queryPeopleIds1(Long id, Long operId, Long partnerId, String companyName, String industry) {
        JPAQuery jpaQuerySelect = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qdo.id).from((EntityPath)this.qdo)).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.id.ne((Object)id));
        BooleanExpression jpaQueryOr = null;
        if (operId != null && partnerId != null) {
            jpaQueryOr = this.qdo.operId.eq((Object)operId).or((Predicate)this.qdo.customerId.eq((Object)partnerId));
        } else if (operId != null) {
            jpaQueryOr = this.qdo.operId.eq((Object)operId);
        } else if (partnerId != null) {
            jpaQueryOr = this.qdo.customerId.eq((Object)partnerId);
        } else if (StringUtils.hasText((String)companyName)) {
            jpaQueryOr = this.qdo.companyName.eq((Object)companyName);
        }
        if (StringUtils.hasText((String)industry)) {
            jpaQueryOr = jpaQueryOr == null ? this.qdo.industry.eq((Object)industry) : jpaQueryOr.or((Predicate)this.qdo.industry.eq((Object)industry));
        }
        jpaQuerySelect.where((Predicate)jpaQueryOr);
        return jpaQuerySelect.fetch();
    }

    public List<Long> queryPeopleIds2(Long id, List<Long> customerIds, List<String> companyNames) {
        JPAQuery jpaQuerySelect = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qdo.id).from((EntityPath)this.qdo)).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.id.ne((Object)id));
        if (!ObjectUtils.isEmpty(customerIds) && !ObjectUtils.isEmpty(companyNames)) {
            jpaQuerySelect.where((Predicate)this.qdo.customerId.in(customerIds).or((Predicate)this.qdo.companyName.in(companyNames)));
        } else if (!ObjectUtils.isEmpty(customerIds)) {
            jpaQuerySelect.where((Predicate)this.qdo.customerId.in(customerIds));
        } else if (!ObjectUtils.isEmpty(companyNames)) {
            jpaQuerySelect.where((Predicate)this.qdo.companyName.in(companyNames));
        }
        return jpaQuerySelect.fetch();
    }

    public CrmPeopleDAO(JPAQueryFactory jpaQueryFactory, CrmPeopleRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

