/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.my.query.UserVacationApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.UserRecentVacationApplyVO;
import com.elitesland.tw.tw5.api.prd.my.vo.UserVacationApplyVO;
import com.elitesland.tw.tw5.server.common.scheduling.TimeUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.my.entity.QUserVacationApplyDO;
import com.elitesland.tw.tw5.server.prd.my.entity.QUserVacationApplyDetailDO;
import com.elitesland.tw.tw5.server.prd.my.entity.UserVacationApplyDetailDO;
import com.elitesland.tw.tw5.server.prd.my.repo.UserVacationApplyDetailRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Repository
public class UserVacationApplyDetailDAO {
    private final UserVacationApplyDetailRepo repo;
    private final JPAQueryFactory jpaQueryFactory;
    private final QUserVacationApplyDO userVacationApplyDO = QUserVacationApplyDO.userVacationApplyDO;
    private final QUserVacationApplyDetailDO userVacationApplyDetailDO = QUserVacationApplyDetailDO.userVacationApplyDetailDO;
    private final QPrdOrgEmployeeRefDO qdoRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;
    private final QPrdOrgOrganizationDO qdoOrg = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QPrdOrgEmployeeDO employeeDO = QPrdOrgEmployeeDO.prdOrgEmployeeDO;

    public List<UserVacationApplyDetailDO> saveAll(List<UserVacationApplyDetailDO> list) {
        return this.repo.saveAll(list);
    }

    public void updateProcStatus(UserVacationApplyDetailDO detailDO) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.userVacationApplyDetailDO).where(new Predicate[]{this.userVacationApplyDetailDO.id.eq((Object)detailDO.getId())});
        if (detailDO.getProcInstId() != null) {
            update.set((Path)this.userVacationApplyDetailDO.procInstId, (Object)detailDO.getProcInstId());
        }
        if (detailDO.getProcInstStatus() != null) {
            update.set(this.userVacationApplyDetailDO.procInstStatus, (Object)detailDO.getProcInstStatus());
        }
        if (detailDO.getApprovedTime() != null) {
            update.set(this.userVacationApplyDetailDO.approvedTime, (Object)detailDO.getApprovedTime());
        }
        update.execute();
    }

    public void updateProcStatusByApplyId(Long applyId, ProcInstStatus procInstStatus) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.userVacationApplyDetailDO).where(new Predicate[]{this.userVacationApplyDetailDO.applyId.eq((Object)applyId)});
        if (procInstStatus != null) {
            update.set(this.userVacationApplyDetailDO.procInstStatus, (Object)procInstStatus);
        }
        update.execute();
    }

    public List<UserVacationApplyDetailDO> findByProcIdAndExtFlag(String procId, Boolean flag) {
        return this.repo.findByProcInstIdAndExtVacationFlag(procId, flag);
    }

    public List<UserVacationApplyDetailDO> findByApplyIdAndExtFlag(Long applyId, Boolean flag) {
        return this.repo.findByApplyIdAndExtVacationFlag(applyId, flag);
    }

    public List<UserVacationApplyDetailDO> findByApplyId(Long applyId) {
        return this.repo.findByApplyId(applyId);
    }

    private JPAQuery<UserVacationApplyVO> getJpaQueryWhere(UserVacationApplyQuery query) {
        JPAQuery<UserVacationApplyVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object)query.getIds())) {
            jpaQuery.where((Predicate)this.userVacationApplyDetailDO.id.in((Collection)query.getIds()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApplyNo())) {
            jpaQuery.where((Predicate)this.userVacationApplyDO.applyNo.eq((Object)query.getApplyNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getUserId())) {
            jpaQuery.where((Predicate)this.userVacationApplyDO.userId.eq((Object)query.getUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getOrgId())) {
            jpaQuery.where((Predicate)this.qdoRef.orgId.eq((Object)query.getOrgId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getParentUserId())) {
            jpaQuery.where((Predicate)this.qdoRef.parentId.eq((Object)query.getParentUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getVacationType())) {
            jpaQuery.where((Predicate)this.userVacationApplyDO.vacationType.eq((Object)query.getVacationType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getVacationId())) {
            jpaQuery.where((Predicate)this.userVacationApplyDO.vacationId.eq((Object)query.getVacationId()));
        }
        if (StringUtils.hasLength((String)query.getVdateStart()) && StringUtils.hasLength((String)query.getVdateEnd())) {
            jpaQuery.where((Predicate)this.userVacationApplyDetailDO.vDate.between((Comparable)TimeUtil.dateFromYmd(query.getVdateStart()), (Comparable)TimeUtil.dateFromYmd(query.getVdateEnd())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApprStatus())) {
            jpaQuery.where((Predicate)this.userVacationApplyDO.procInstStatus.eq((Object)ProcInstStatus.valueOf((String)query.getApprStatus())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApprDateStr())) {
            LocalDate dateStart = LocalDate.parse((CharSequence)query.getApprDateStr().get(0));
            LocalDateTime timeStart = dateStart.atStartOfDay();
            LocalDate dateEnd = LocalDate.parse((CharSequence)query.getApprDateStr().get(1));
            LocalDateTime timeEnd = dateEnd.plusDays(1L).atStartOfDay();
            jpaQuery.where((Predicate)this.userVacationApplyDO.createTime.between((Comparable)timeStart, (Comparable)timeEnd));
        }
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.userVacationApplyDO._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.userVacationApplyDetailDO, query.getOrders()));
        return jpaQuery;
    }

    private JPAQuery<UserVacationApplyVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(UserVacationApplyVO.class, (Expression[])new Expression[]{this.userVacationApplyDetailDO.id, this.userVacationApplyDetailDO.applyId, this.userVacationApplyDO.applyNo, this.userVacationApplyDO.userId, this.userVacationApplyDO.procInstId, this.userVacationApplyDetailDO.vDate.as("detailVDate"), this.userVacationApplyDetailDO.vDays.as("vacationDays"), this.userVacationApplyDetailDO.vInterval.as("detailInterval"), this.userVacationApplyDO.vacationType, this.userVacationApplyDO.procInstStatus.as("apprStatus"), this.userVacationApplyDO.userId.as("apprUserId"), this.userVacationApplyDO.createTime.as("apprDate"), this.qdoRef.orgId, this.qdoRef.parentId.as("parentUserId"), this.employeeDO.employeeNo})).from((EntityPath)this.userVacationApplyDetailDO)).where((Predicate)this.userVacationApplyDetailDO.deleteFlag.eq((Object)0))).leftJoin((EntityPath)this.userVacationApplyDO)).on((Predicate)this.userVacationApplyDetailDO.applyId.eq(this.userVacationApplyDO.id))).leftJoin((EntityPath)this.qdoRef)).on((Predicate)this.userVacationApplyDO.userId.longValue().eq((Expression)this.qdoRef.userId.longValue()).and((Predicate)this.qdoRef.isDefault.eq((Object)0)).and((Predicate)this.qdoRef.isCopy.eq((Object)0)).and((Predicate)this.qdoRef.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qdoOrg)).on((Predicate)this.qdoOrg.id.longValue().eq((Expression)this.qdoRef.orgId.longValue()).and((Predicate)this.qdoOrg.isCopy.eq((Object)0)))).leftJoin((EntityPath)this.employeeDO)).on((Predicate)this.employeeDO.userId.eq(this.userVacationApplyDO.userId))).where((Predicate)this.userVacationApplyDO.deleteFlag.eq((Object)0));
    }

    public PagingVO<UserVacationApplyVO> page(UserVacationApplyQuery query) {
        JPAQuery<UserVacationApplyVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public List<UserVacationApplyVO> list(UserVacationApplyQuery query) {
        JPAQuery<UserVacationApplyVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = jpaQuery.fetch();
        return result;
    }

    public List<UserRecentVacationApplyVO> getRecentVacation(UserVacationApplyQuery query) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(UserRecentVacationApplyVO.class, (Expression[])new Expression[]{this.userVacationApplyDO.applyNo, this.userVacationApplyDO.userId, this.userVacationApplyDetailDO.vDate.as("detailVDate"), this.userVacationApplyDetailDO.vDays.as("vacationDays"), this.userVacationApplyDO.vacationType, this.userVacationApplyDO.reason})).from((EntityPath)this.userVacationApplyDetailDO)).where((Predicate)this.userVacationApplyDetailDO.deleteFlag.eq((Object)0))).leftJoin((EntityPath)this.userVacationApplyDO)).on((Predicate)this.userVacationApplyDetailDO.applyId.eq(this.userVacationApplyDO.id))).where((Predicate)this.userVacationApplyDO.userId.eq((Object)query.getUserId()))).where((Predicate)this.userVacationApplyDetailDO.vDate.goe((Comparable)TimeUtil.dateFromYmd(query.getVdateStart())))).where((Predicate)this.userVacationApplyDO.procInstStatus.eq((Object)ProcInstStatus.APPROVED))).where((Predicate)this.userVacationApplyDO.deleteFlag.eq((Object)0))).fetch();
    }

    public List<UserRecentVacationApplyVO> queryByDateAndResId(LocalDate startDate, LocalDate endDate, Long resId, List<ProcInstStatus> procInstStatusList) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(UserRecentVacationApplyVO.class, (Expression[])new Expression[]{this.userVacationApplyDetailDO.vDate.as("detailVDate"), this.userVacationApplyDetailDO.vDays.as("vacationDays"), this.userVacationApplyDetailDO.vInterval, this.userVacationApplyDO.vacationType})).from((EntityPath)this.userVacationApplyDetailDO)).leftJoin((EntityPath)this.userVacationApplyDO)).on((Predicate)this.userVacationApplyDO.id.eq(this.userVacationApplyDetailDO.applyId))).where((Predicate)this.userVacationApplyDetailDO.deleteFlag.eq((Object)0))).where((Predicate)this.userVacationApplyDO.deleteFlag.eq((Object)0))).where((Predicate)this.userVacationApplyDetailDO.vDate.between((Comparable)startDate, (Comparable)endDate))).where((Predicate)this.userVacationApplyDO.userId.eq((Object)resId))).where((Predicate)this.userVacationApplyDO.procInstStatus.in(procInstStatusList))).fetch();
    }

    @Transactional
    public void deleteAllByApplyId(Long applyId) {
        this.repo.deleteAllByApplyId(applyId);
    }

    public UserVacationApplyDetailDAO(UserVacationApplyDetailRepo repo, JPAQueryFactory jpaQueryFactory) {
        this.repo = repo;
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

