/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TBusiSignetApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TBusiSignetApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TBusiSignetApplyService;
import com.elitesland.tw.tw5.api.prd.my.vo.TBusiSignetApplyVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeLeaderQuery;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgRoleVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SignetTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowRoleCodeEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.TBusiSignetApplyConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TBusiSignetApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TBusiSignetApplyDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TBusiSignetApplyRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TBusiSignetApplyServiceImpl
extends BaseServiceImpl
implements TBusiSignetApplyService {
    private static final Logger log = LoggerFactory.getLogger(TBusiSignetApplyServiceImpl.class);
    private final TBusiSignetApplyRepo tBusiSignetApplyRepo;
    private final TBusiSignetApplyDAO tBusiSignetApplyDAO;
    @Value(value="${tw5.workflow.enabled}")
    private Boolean workflow_enabled;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final CacheUtil cacheUtil;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final FileUtil fileUtil;
    private final PrdOrgOrganizationDAO daoOrg;
    @Value(value="${tw5.workflow.orgId}")
    private Long workflow_orgId;

    public PagingVO<TBusiSignetApplyVO> queryPaging(TBusiSignetApplyQuery query) {
        PagingVO<TBusiSignetApplyVO> tBusiSignetApplyVOPagingVO = this.tBusiSignetApplyDAO.queryPaging(query);
        if (!CollectionUtils.isEmpty((Collection)tBusiSignetApplyVOPagingVO.getRecords())) {
            tBusiSignetApplyVOPagingVO.stream().forEach(p -> this.translate((TBusiSignetApplyVO)p));
        }
        return tBusiSignetApplyVOPagingVO;
    }

    public List<TBusiSignetApplyVO> queryListDynamic(TBusiSignetApplyQuery query) {
        List<TBusiSignetApplyVO> tBusiSignetApplyVOS = this.tBusiSignetApplyDAO.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(tBusiSignetApplyVOS)) {
            tBusiSignetApplyVOS.stream().forEach(p -> this.translate((TBusiSignetApplyVO)p));
        }
        return tBusiSignetApplyVOS;
    }

    public TBusiSignetApplyVO queryByKey(Long key) {
        TBusiSignetApplyDO entity = this.tBusiSignetApplyRepo.findById(key).orElseGet(TBusiSignetApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TBusiSignetApplyVO vo = TBusiSignetApplyConvert.INSTANCE.toVo(entity);
        this.translate(vo);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TBusiSignetApplyVO insert(TBusiSignetApplyPayload payload) {
        TBusiSignetApplyDO entityDo = TBusiSignetApplyConvert.INSTANCE.toDo(payload);
        TBusiSignetApplyDO tBusiSignetApplyDO = (TBusiSignetApplyDO)this.tBusiSignetApplyRepo.save(entityDo);
        this.busiSignetApplyProc(tBusiSignetApplyDO);
        return TBusiSignetApplyConvert.INSTANCE.toVo(tBusiSignetApplyDO);
    }

    @Transactional(rollbackFor={Exception.class})
    public TBusiSignetApplyVO update(TBusiSignetApplyPayload payload) {
        TBusiSignetApplyDO entity = this.tBusiSignetApplyRepo.findById(payload.getId()).orElseGet(TBusiSignetApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TBusiSignetApplyDO entityDo = TBusiSignetApplyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TBusiSignetApplyConvert.INSTANCE.toVo((TBusiSignetApplyDO)this.tBusiSignetApplyRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(TBusiSignetApplyPayload payload) {
        TBusiSignetApplyDO entity = this.tBusiSignetApplyRepo.findById(payload.getId()).orElseGet(TBusiSignetApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.tBusiSignetApplyDAO.updateByKeyDynamic(payload);
        if (payload.getSubmit() != null && payload.getSubmit().booleanValue()) {
            if (entity.getProcInstId() == null) {
                TBusiSignetApplyDO entityDo = TBusiSignetApplyConvert.INSTANCE.toDo(payload);
                entity.copy(entityDo);
                this.busiSignetApplyProc(entity);
            } else {
                Boolean workFlag = false;
                SetVariablesPayload setVariablesPayload = new SetVariablesPayload();
                setVariablesPayload.setProcInstId(entity.getProcInstId());
                if (payload.getLendFlag() != null && !payload.getLendFlag().equals(entity.getLendFlag())) {
                    workFlag = true;
                }
                if (payload.getPrintFlag() != null && !payload.getPrintFlag().equals(entity.getPrintFlag())) {
                    workFlag = true;
                }
                if (payload.getSignetType() != null && !payload.getSignetType().equals(entity.getSignetType())) {
                    workFlag = true;
                }
                if (workFlag.booleanValue()) {
                    TBusiSignetApplyDO entityDo = TBusiSignetApplyConvert.INSTANCE.toDo(payload);
                    entity.copy(entityDo);
                    HashMap variables = this.dealWorkFlowVariables(entity);
                    setVariablesPayload.setVariables(variables);
                    this.workflowUtil.setVaribales(setVariablesPayload);
                }
            }
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.tBusiSignetApplyDAO.deleteSoft(keys);
        }
    }

    private void busiSignetApplyProc(TBusiSignetApplyDO permissionApplyDO) {
        ProcessInfo processInfo = new ProcessInfo();
        if (this.workflow_enabled.booleanValue()) {
            String applyResName = this.cacheUtil.getUserName(permissionApplyDO.getApplyResId());
            HashMap variables = this.dealWorkFlowVariables(permissionApplyDO);
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.BUSI_SIGNET_APPLY.name(), (String)(applyResName + "-\u7528\u5370\u7533\u8bf7\u6d41\u7a0b"), (String)("" + permissionApplyDO.getId()), (HashMap)variables), new Long[0]);
        }
        TBusiSignetApplyPayload payload = new TBusiSignetApplyPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(permissionApplyDO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        this.transactionUtilService.executeWithRunnable(() -> this.tBusiSignetApplyDAO.updateByKeyDynamic(payload));
    }

    public void translate(TBusiSignetApplyVO vo) {
        if (vo != null && StringUtils.hasText((String)vo.getRelatedSignet())) {
            StringBuilder stringBuilder = new StringBuilder("");
            Arrays.stream(vo.getRelatedSignet().split(",")).forEach(p -> stringBuilder.append(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.RELATED_SIGNET.getCode(), (String)p) + ","));
            if (stringBuilder.length() > 0) {
                vo.setRelatedSignet(stringBuilder.substring(0, stringBuilder.length() - 1));
            }
            if (StringUtils.hasText((String)vo.getFileCode())) {
                vo.setFileData(this.fileUtil.getFileDatas(vo.getFileCode()));
            }
        }
    }

    public HashMap dealWorkFlowVariables(TBusiSignetApplyDO permissionApplyDO) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        Boolean isDepartmentHead = false;
        Boolean isPersonnel = false;
        List<PrdOrgEmployeeLeaderQuery> prdOrgEmployeeLeaderQueryList = this.employeeDAO.queryOrgLeaderByUserId(permissionApplyDO.getApplyResId());
        if (CollectionUtils.isEmpty(prdOrgEmployeeLeaderQueryList)) {
            throw TwException.error("", "\u5f53\u524d\u767b\u5f55\u4eba\u7684\u90e8\u95e8\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4");
        }
        List leaderIdList = prdOrgEmployeeLeaderQueryList.stream().filter(p -> p.getOrgLeaderId() != null).map(x -> x.getOrgLeaderId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(leaderIdList)) {
            throw TwException.error("", "\u5f53\u524d\u767b\u5f55\u4eba\u7684\u90e8\u95e8\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728\uff0c\u8bf7\u7ef4\u62a4");
        }
        if (leaderIdList.contains(permissionApplyDO.getApplyResId())) {
            isDepartmentHead = true;
        }
        variables.put("Activity_1ff34gj", leaderIdList.get(0));
        PrdOrgRoleVO personnelSignetCustody = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.BUSI_SIGNET_APPLY_PERSONNEL_SIGNET_CUSTODY.getCode());
        if (ObjectUtils.isEmpty((Object)personnelSignetCustody)) {
            throw new BusinessException("\u4eba\u4e8b\u4e13\u7528\u5370\u7ae0\u4fdd\u7ba1\u5458\u4e0d\u5b58\u5728\uff01");
        }
        String[] splitByPersonnelSignetCustody = personnelSignetCustody.getRoleEmployees().split(",");
        variables.put("Activity_03oy8as", Arrays.asList(splitByPersonnelSignetCustody));
        String printWorkFlowRoleCode = this.dealPrintPersonnel(permissionApplyDO.getSignetType());
        if (!StringUtils.hasText((String)printWorkFlowRoleCode)) {
            throw new BusinessException("\u5370\u7ae0\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        PrdOrgRoleVO printManage = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, printWorkFlowRoleCode);
        if (ObjectUtils.isEmpty((Object)printManage)) {
            throw new BusinessException(WorkFlowRoleCodeEnum.valueOf(printWorkFlowRoleCode).getDesc() + "\u4e0d\u5b58\u5728\uff01");
        }
        String[] splitByPrintManage = printManage.getRoleEmployees().split(",");
        variables.put("Activity_01c620f", Arrays.asList(splitByPrintManage));
        PrdOrgRoleVO signetCustody = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.BUSI_SIGNET_APPLY_SIGNET_CUSTODY.getCode());
        if (ObjectUtils.isEmpty((Object)signetCustody)) {
            throw new BusinessException(WorkFlowRoleCodeEnum.BUSI_SIGNET_APPLY_SIGNET_CUSTODY.getDesc() + "\u4e0d\u5b58\u5728\uff01");
        }
        String[] splitBySignetCustody = signetCustody.getRoleEmployees().split(",");
        variables.put("Activity_0rjplkf", Arrays.asList(splitBySignetCustody));
        PrdOrgRoleVO signetReturn = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.BUSI_SIGNET_APPLY_RETURN.getCode());
        if (ObjectUtils.isEmpty((Object)signetReturn)) {
            throw new BusinessException(WorkFlowRoleCodeEnum.BUSI_SIGNET_APPLY_RETURN.getDesc() + "\u4e0d\u5b58\u5728\uff01");
        }
        String[] splitBySignetReturn = signetReturn.getRoleEmployees().split(",");
        variables.put("Activity_1u28a42", Arrays.asList(splitBySignetReturn));
        variables.put("isDepartmentHead", isDepartmentHead);
        variables.put("lendFlag", permissionApplyDO.getLendFlag());
        if (StringUtils.hasText((String)permissionApplyDO.getSignetType()) && SignetTypeEnum.PERSONNEL.getCode().equals(permissionApplyDO.getSignetType())) {
            isPersonnel = true;
        }
        variables.put("isPersonnel", isPersonnel);
        variables.put("printFlag", permissionApplyDO.getPrintFlag());
        return variables;
    }

    public String dealPrintPersonnel(String signetType) {
        String roleCode = "";
        switch (SignetTypeEnum.toType(signetType)) {
            case PERSONNEL: {
                roleCode = WorkFlowRoleCodeEnum.BUSI_SIGNET_APPLY_PRINT_PERSONNEL.getCode();
                break;
            }
            case SALES_CONTRACT: {
                roleCode = WorkFlowRoleCodeEnum.BUSI_SIGNET_APPLY_PRINT_SALES_CONTRACT.getCode();
                break;
            }
            case PURCHASE_CONTRACT: {
                roleCode = WorkFlowRoleCodeEnum.BUSI_SIGNET_APPLY_PRINT_PURCHASE_CONTRACT.getCode();
                break;
            }
            case PROJECT: {
                roleCode = WorkFlowRoleCodeEnum.BUSI_SIGNET_APPLY_PRINT_PROJECT.getCode();
                break;
            }
            case ADMINISTRATION: {
                roleCode = WorkFlowRoleCodeEnum.BUSI_SIGNET_APPLY_PRINT_ADMINISTRATION.getCode();
                break;
            }
            case FINANCE: {
                roleCode = WorkFlowRoleCodeEnum.BUSI_SIGNET_APPLY_PRINT_FINANCE.getCode();
                break;
            }
            case MARKETPLACE: {
                roleCode = WorkFlowRoleCodeEnum.BUSI_SIGNET_APPLY_PRINT_MARKETPLACE.getCode();
                break;
            }
        }
        return roleCode;
    }

    public TBusiSignetApplyServiceImpl(TBusiSignetApplyRepo tBusiSignetApplyRepo, TBusiSignetApplyDAO tBusiSignetApplyDAO, WorkflowUtil workflowUtil, TransactionUtilService transactionUtilService, CacheUtil cacheUtil, PrdOrgEmployeeDAO employeeDAO, PrdSystemRoleDAO systemRoleDAO, FileUtil fileUtil, PrdOrgOrganizationDAO daoOrg) {
        this.tBusiSignetApplyRepo = tBusiSignetApplyRepo;
        this.tBusiSignetApplyDAO = tBusiSignetApplyDAO;
        this.workflowUtil = workflowUtil;
        this.transactionUtilService = transactionUtilService;
        this.cacheUtil = cacheUtil;
        this.employeeDAO = employeeDAO;
        this.systemRoleDAO = systemRoleDAO;
        this.fileUtil = fileUtil;
        this.daoOrg = daoOrg;
    }
}

