/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.tw.tw5.api.prd.my.payload.TDeviceApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TDeviceApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TDeviceApplyService;
import com.elitesland.tw.tw5.api.prd.my.vo.TDeviceApplyVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgRoleVO;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.TDeviceApplyConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TDeviceApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TDeviceApplyDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TDeviceApplyRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class TDeviceApplyServiceImpl
implements TDeviceApplyService {
    private static final Logger log = LoggerFactory.getLogger(TDeviceApplyServiceImpl.class);
    private final TDeviceApplyRepo tDeviceApplyRepo;
    private final TDeviceApplyDAO tDeviceApplyDAO;
    private final FileUtil fileUtil;
    private final CacheUtil cacheUtil;
    @Value(value="${tw5.workflow.enabled}")
    private Boolean workflow_enabled;
    @Value(value="${tw5.workflow.orgId}")
    private Long workflow_orgId;
    private final PrdOrgOrganizationDAO daoOrg;
    private final TransactionUtilService transactionUtilService;
    private final WorkflowUtil workflowUtil;

    public PagingVO<TDeviceApplyVO> queryPaging(TDeviceApplyQuery query) {
        PagingVO<TDeviceApplyVO> paging = this.tDeviceApplyDAO.queryPaging(query);
        return paging;
    }

    public List<TDeviceApplyVO> queryListDynamic(TDeviceApplyQuery query) {
        return this.tDeviceApplyDAO.queryListDynamic(query);
    }

    public TDeviceApplyVO queryByKey(Long key) {
        TDeviceApplyVO vo = this.tDeviceApplyDAO.queryByKey(key);
        vo.setFileData(this.fileUtil.getFileDatas(vo.getFileCode()));
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TDeviceApplyVO insert(TDeviceApplyPayload payload) {
        payload.setApplyDate(LocalDate.now());
        TDeviceApplyDO entityDo = TDeviceApplyConvert.INSTANCE.toDo(payload);
        TDeviceApplyDO save = (TDeviceApplyDO)this.tDeviceApplyRepo.save(entityDo);
        if (payload.getSubmit() != null && payload.getSubmit().booleanValue()) {
            this.deviceApplyProc(save);
        }
        return TDeviceApplyConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public TDeviceApplyVO update(TDeviceApplyPayload payload) {
        TDeviceApplyDO entity = this.tDeviceApplyRepo.findById(payload.getId()).orElseGet(TDeviceApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TDeviceApplyDO entityDo = TDeviceApplyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        TDeviceApplyDO save = (TDeviceApplyDO)this.tDeviceApplyRepo.save(entity);
        if (!StringUtils.hasText((String)entity.getProcInstId())) {
            this.deviceApplyProcByUpdate(entity);
        }
        return TDeviceApplyConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(TDeviceApplyPayload payload) {
        TDeviceApplyDO entity = this.tDeviceApplyRepo.findById(payload.getId()).orElseGet(TDeviceApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.tDeviceApplyDAO.updateByKeyDynamic(payload);
        if (payload.getSubmit() != null && payload.getSubmit().booleanValue()) {
            this.deviceApplyProcByUpdate(entity);
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.tDeviceApplyDAO.deleteSoft(keys);
        }
    }

    private void deviceApplyProc(TDeviceApplyDO deviceApplyDO) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.CREATE_WORK.getCode();
        if (this.workflow_enabled.booleanValue()) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, Object> variables = new HashMap<String, Object>();
            Long applyResId = deviceApplyDO.getApplyResId();
            String applyResName = this.cacheUtil.getUserName(applyResId);
            Long planOrgManageUserId = this.daoOrg.queryManageIdById(deviceApplyDO.getResBuId());
            variables.put("Activity_1qf9o2s", planOrgManageUserId);
            List<PrdOrgRoleVO> prdOrgRoleVOS = this.daoOrg.queryRoleList(this.workflow_orgId);
            Optional<PrdOrgRoleVO> optional = prdOrgRoleVOS.stream().filter(e -> "PLAT_IT_ADMIN".equals(e.getRoleCode())).findFirst();
            if (!optional.isPresent()) {
                throw new BusinessException("\u5e73\u53f0IT\u8d1f\u8d23\u4eba\u89d2\u8272\u4e0d\u5b58\u5728\uff01");
            }
            PrdOrgRoleVO prdOrgRoleVO = optional.get();
            String[] split = prdOrgRoleVO.getRoleEmployees().split(",");
            variables.put("Activity_15lageb", Arrays.asList(split));
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.SELF_PUR_COMPUTER.name(), (String)(applyResName + "-\u81ea\u8d2d\u7535\u8111\u7533\u8bf7\u6d41\u7a0b"), (String)("" + deviceApplyDO.getId()), variables), new Long[0]);
        }
        TDeviceApplyPayload payload = new TDeviceApplyPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(deviceApplyDO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setApplyStatus(status);
        payload.setApplyNo(String.valueOf(deviceApplyDO.getId()));
        this.transactionUtilService.executeWithRunnable(() -> this.tDeviceApplyDAO.updateByKeyDynamic(payload));
    }

    private void deviceApplyProcByUpdate(TDeviceApplyDO deviceApplyDO) {
        if (this.workflow_enabled.booleanValue()) {
            HashMap<String, Object> variables = new HashMap<String, Object>();
            Long applyResId = deviceApplyDO.getApplyResId();
            String applyResName = this.cacheUtil.getUserName(applyResId);
            Long planOrgManageUserId = this.daoOrg.queryManageIdById(deviceApplyDO.getResBuId());
            variables.put("Activity_1qf9o2s", planOrgManageUserId);
            List<PrdOrgRoleVO> prdOrgRoleVOS = this.daoOrg.queryRoleList(this.workflow_orgId);
            Optional<PrdOrgRoleVO> optional = prdOrgRoleVOS.stream().filter(e -> "PLAT_IT_ADMIN".equals(e.getRoleCode())).findFirst();
            if (!optional.isPresent()) {
                throw new BusinessException("\u5e73\u53f0IT\u8d1f\u8d23\u4eba\u89d2\u8272\u4e0d\u5b58\u5728\uff01");
            }
            PrdOrgRoleVO prdOrgRoleVO = optional.get();
            String[] split = prdOrgRoleVO.getRoleEmployees().split(",");
            variables.put("Activity_15lageb", Arrays.asList(split));
            SetVariablesPayload payload = new SetVariablesPayload();
            payload.setProcInstId(deviceApplyDO.getProcInstId());
            payload.setVariables(variables);
            this.workflowUtil.setVaribales(payload);
        }
    }

    public TDeviceApplyServiceImpl(TDeviceApplyRepo tDeviceApplyRepo, TDeviceApplyDAO tDeviceApplyDAO, FileUtil fileUtil, CacheUtil cacheUtil, PrdOrgOrganizationDAO daoOrg, TransactionUtilService transactionUtilService, WorkflowUtil workflowUtil) {
        this.tDeviceApplyRepo = tDeviceApplyRepo;
        this.tDeviceApplyDAO = tDeviceApplyDAO;
        this.fileUtil = fileUtil;
        this.cacheUtil = cacheUtil;
        this.daoOrg = daoOrg;
        this.transactionUtilService = transactionUtilService;
        this.workflowUtil = workflowUtil;
    }
}

