/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.partner.identity.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessDistributorInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessDistributorInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessDistributorInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessDistributorInfoVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.partner.identity.convert.BusinessDistributorInfoConvert;
import com.elitesland.tw.tw5.server.prd.partner.identity.dao.BusinessDistributorInfoDAO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.BusinessDistributorInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.repo.BusinessDistributorInfoRepo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class BusinessDistributorInfoServiceImpl
extends BaseServiceImpl
implements BusinessDistributorInfoService {
    private static final Logger log = LoggerFactory.getLogger(BusinessDistributorInfoServiceImpl.class);
    private final BusinessDistributorInfoRepo businessDistributorInfoRepo;
    private final BusinessDistributorInfoDAO businessDistributorInfoDAO;
    private final FileUtil fileUtil;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final PrdSystemLogService logService;

    public PagingVO<BusinessDistributorInfoVO> queryPaging(BusinessDistributorInfoQuery query) {
        return this.businessDistributorInfoDAO.queryPaging(query);
    }

    public List<BusinessDistributorInfoVO> queryListDynamic(BusinessDistributorInfoQuery query) {
        List<BusinessDistributorInfoVO> businessDistributorInfoVOS = this.businessDistributorInfoDAO.queryListDynamic(query);
        businessDistributorInfoVOS.stream().forEach(vo -> {
            vo.setFileDatas1(this.fileUtil.getFileDatas(vo.getFileCodes1()));
            vo.setFileDatas2(this.fileUtil.getFileDatas(vo.getFileCodes2()));
        });
        return businessDistributorInfoVOS;
    }

    public BusinessDistributorInfoVO queryByKey(Long key) {
        BusinessDistributorInfoDO entity = this.businessDistributorInfoRepo.findById(key).orElseGet(BusinessDistributorInfoDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessDistributorInfoVO vo = BusinessDistributorInfoConvert.INSTANCE.toVo(entity);
        vo.setFileDatas1(this.fileUtil.getFileDatas(vo.getFileCodes1()));
        vo.setFileDatas2(this.fileUtil.getFileDatas(vo.getFileCodes2()));
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessDistributorInfoVO insert(BusinessDistributorInfoPayload payload) {
        BusinessDistributorInfoDO entityDo = BusinessDistributorInfoConvert.INSTANCE.toDo(payload);
        return BusinessDistributorInfoConvert.INSTANCE.toVo((BusinessDistributorInfoDO)this.businessDistributorInfoRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessDistributorInfoVO update(BusinessDistributorInfoPayload payload) {
        BusinessDistributorInfoDO entity = this.businessDistributorInfoRepo.findById(payload.getId()).orElseGet(BusinessDistributorInfoDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessDistributorInfoDO entityLog = new BusinessDistributorInfoDO();
        BeanUtils.copyProperties((Object)entity, (Object)entityLog);
        BusinessDistributorInfoDO entityDo = BusinessDistributorInfoConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        if (null != payload.getPartnerId()) {
            StringBuilder fieldsUpdateLog = this.changeFieldLogUtil.nullFieldsProcess((TwCommonPayload)payload, entityLog, entity);
            fieldsUpdateLog.append(this.changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
            if (StringUtils.hasText((CharSequence)fieldsUpdateLog)) {
                this.logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), fieldsUpdateLog.toString());
            }
        }
        return BusinessDistributorInfoConvert.INSTANCE.toVo((BusinessDistributorInfoDO)this.businessDistributorInfoRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.businessDistributorInfoDAO.deleteSoft(keys);
        }
    }

    public BusinessDistributorInfoServiceImpl(BusinessDistributorInfoRepo businessDistributorInfoRepo, BusinessDistributorInfoDAO businessDistributorInfoDAO, FileUtil fileUtil, ChangeFieldLogUtil changeFieldLogUtil, PrdSystemLogService logService) {
        this.businessDistributorInfoRepo = businessDistributorInfoRepo;
        this.businessDistributorInfoDAO = businessDistributorInfoDAO;
        this.fileUtil = fileUtil;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.logService = logService;
    }
}

