/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.purchase.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.purchase.payload.ResSetRatePayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.ResSetRateQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.ResSetRateVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.purchase.entity.QResSetRateDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.ResSetRateDO;
import com.elitesland.tw.tw5.server.prd.purchase.repo.ResSetRateRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class ResSetRateDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final ResSetRateRepo repo;
    private final QResSetRateDO qdo = QResSetRateDO.resSetRateDO;

    private JPAQuery<ResSetRateVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ResSetRateVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.documentId, this.qdo.documentNo, this.qdo.serviceRate, this.qdo.startAtm, this.qdo.endAtm})).from((EntityPath)this.qdo);
    }

    private JPAQuery<ResSetRateVO> getJpaQueryWhere(ResSetRateQuery query) {
        JPAQuery<ResSetRateVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        return jpaQuery;
    }

    public long count(ResSetRateQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(ResSetRateQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDocumentId())) {
            list.add(this.qdo.documentId.eq((Object)query.getDocumentId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDocumentNo())) {
            list.add(this.qdo.documentNo.eq((Object)query.getDocumentNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getServiceRate())) {
            list.add(this.qdo.serviceRate.eq((Object)query.getServiceRate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStartAtm())) {
            list.add(this.qdo.startAtm.eq((Object)query.getStartAtm()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEndAtm())) {
            list.add(this.qdo.endAtm.eq((Object)query.getEndAtm()));
        }
        return ExpressionUtils.allOf(list);
    }

    public ResSetRateVO queryByKey(Long id) {
        JPAQuery<ResSetRateVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (ResSetRateVO)jpaQuery.fetchFirst();
    }

    public List<ResSetRateVO> queryListDynamic(ResSetRateQuery query) {
        JPAQuery<ResSetRateVO> jpaQuery = this.getJpaQueryWhere(query);
        jpaQuery.orderBy(this.qdo.startAtm.asc());
        return jpaQuery.fetch();
    }

    public PagingVO<ResSetRateVO> queryPaging(ResSetRateQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<ResSetRateVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public ResSetRateDO save(ResSetRateDO ado) {
        return (ResSetRateDO)this.repo.save(ado);
    }

    public List<ResSetRateDO> saveAll(List<ResSetRateDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(ResSetRatePayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getDocumentId() != null) {
            update.set(this.qdo.documentId, (Object)payload.getDocumentId());
        }
        if (payload.getDocumentNo() != null) {
            update.set((Path)this.qdo.documentNo, (Object)payload.getDocumentNo());
        }
        if (payload.getServiceRate() != null) {
            update.set(this.qdo.serviceRate, (Object)payload.getServiceRate());
        }
        if (payload.getStartAtm() != null) {
            update.set(this.qdo.startAtm, (Object)payload.getStartAtm());
        }
        if (payload.getEndAtm() != null) {
            update.set(this.qdo.endAtm, (Object)payload.getEndAtm());
        }
        if (payload.getRemark() != null) {
            update.set((Path)this.qdo.remark, (Object)payload.getRemark());
        }
        if (payload.getDeleteFlag() != null) {
            update.set(this.qdo.deleteFlag, (Object)payload.getDeleteFlag());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("documentId")) {
                update.setNull(this.qdo.documentId);
            }
            if (nullFields.contains("documentNo")) {
                update.setNull((Path)this.qdo.documentNo);
            }
            if (nullFields.contains("serviceRate")) {
                update.setNull(this.qdo.serviceRate);
            }
            if (nullFields.contains("startAtm")) {
                update.setNull(this.qdo.startAtm);
            }
            if (nullFields.contains("endAtm")) {
                update.setNull(this.qdo.endAtm);
            }
            if (nullFields.contains("deleteFlag")) {
                update.setNull(this.qdo.deleteFlag);
            }
            if (nullFields.contains("remark")) {
                update.setNull((Path)this.qdo.remark);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public void deleteSoftByDocumentIdList(List<Long> documentIdList) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.documentId.in(documentIdList)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        update.execute();
    }

    public List<ResSetRateVO> findByAgreementId(Long agreementId) {
        JPAQuery<ResSetRateVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0).and((Predicate)this.qdo.documentId.eq((Object)agreementId)));
        return jpaQuery.fetch();
    }

    public ResSetRateDAO(JPAQueryFactory jpaQueryFactory, ResSetRateRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

