/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.salecon.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivableDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivableDQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivableDService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivableDVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConReceivableDConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConReceivableDDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConReceivableDDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConReceivableDRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConReceivablePlanRepo;
import com.xxl.job.core.log.XxlJobLogger;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ConReceivableDServiceImpl
extends BaseServiceImpl
implements ConReceivableDService {
    private static final Logger log = LoggerFactory.getLogger(ConReceivableDServiceImpl.class);
    private final ConReceivableDRepo conReceivableDRepo;
    private final ConReceivableDDAO conReceivableDDAO;
    private final ConReceivablePlanRepo conReceivablePlanRepo;
    private final PrdOrgEmployeeService employeeService;
    private final PrdOrgSyncLogDAO daoLog;
    private final HttpUtil httpUtil;
    @Value(value="${tw4.sale.conReceivabled}")
    private String conReceivabled;

    public PagingVO<ConReceivableDVO> queryPaging(ConReceivableDQuery query) {
        return this.conReceivableDDAO.queryPaging(query);
    }

    public List<ConReceivableDVO> queryListDynamic(ConReceivableDQuery query) {
        return this.conReceivableDDAO.queryListDynamic(query);
    }

    public ConReceivableDVO queryByKey(Long key) {
        ConReceivableDDO entity = this.conReceivableDRepo.findById(key).orElseGet(ConReceivableDDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ConReceivableDVO vo = ConReceivableDConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ConReceivableDVO insert(ConReceivableDPayload payload) {
        ConReceivableDDO entityDo = ConReceivableDConvert.INSTANCE.toDo(payload);
        return ConReceivableDConvert.INSTANCE.toVo((ConReceivableDDO)this.conReceivableDRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public ConReceivableDVO update(ConReceivableDPayload payload) {
        ConReceivableDDO entity = this.conReceivableDRepo.findById(payload.getId()).orElseGet(ConReceivableDDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ConReceivableDDO entityDo = ConReceivableDConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ConReceivableDConvert.INSTANCE.toVo((ConReceivableDDO)this.conReceivableDRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(ConReceivableDPayload payload) {
        ConReceivableDDO entity = this.conReceivableDRepo.findById(payload.getId()).orElseGet(ConReceivableDDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.conReceivableDDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.conReceivableDDAO.deleteSoft(keys);
        }
    }

    public void syncConReceivableDTo4(String param) {
        LocalDateTime syncTime;
        String syncType = "con_receivabled_to4";
        syncTime = StringUtils.hasText((String)param) ? LocalDateTime.parse(param) : ((syncTime = this.daoLog.queryOrgSyncLog(syncType)) == null ? LocalDateTime.of(2023, 11, 1, 0, 0) : syncTime.minusSeconds(30L));
        XxlJobLogger.log((String)"\u5408\u540c\u6536\u6b3e\u660e\u7ec6\u540c\u6b65\u52304.0\u5f00\u59cb...", (Object[])new Object[0]);
        XxlJobLogger.log((String)("syncContractInvBatchTo4 localDateTime\uff1a" + syncTime), (Object[])new Object[0]);
        String format = DateUtil.format((LocalDateTime)syncTime, (String)"yyyy-MM-dd HH:mm:ss");
        List<ConReceivableDDO> conReceivableDDOS = this.conReceivableDRepo.findByModifyTimeStart(format);
        Object syncData = "";
        LocalDateTime syncNow = LocalDateTime.now();
        if (!ObjectUtils.isEmpty(conReceivableDDOS)) {
            Map<Long, Long> v4AndV5UserIds = this.employeeService.getV4AndV5UserIds().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            int failNum = 0;
            for (ConReceivableDDO temDo : conReceivableDDOS) {
                Long planIdV4 = this.conReceivablePlanRepo.queryV4Id(temDo.getRecvplanId());
                LocalDateTime syncStartTime = LocalDateTime.now();
                try {
                    Map<String, Object> map = BeanUtil.beanToMap(temDo);
                    map.put("delFlag", temDo.getDeleteFlag());
                    if (planIdV4 == null) {
                        map.put("recvplanIdV5", temDo.getRecvplanId());
                        map.put("recvplanId", null);
                    } else {
                        map.put("recvplanIdV5", null);
                        map.put("recvplanId", planIdV4);
                    }
                    map.put("createUserId", v4AndV5UserIds.get(temDo.getCreateUserId()));
                    map.put("modifyUserId", v4AndV5UserIds.get(temDo.getModifyUserId()));
                    HashMap data = new HashMap();
                    if (("" + data.get("ok")).equals("true")) {
                        Long idV4 = Long.parseLong(data.get("datum").toString());
                        this.conReceivableDRepo.updateConReceivableDIdV4(idV4, temDo.getId());
                        continue;
                    }
                    LocalDateTime syncEndTime = LocalDateTime.now();
                    this.saveSyncLog(syncType + "_exception", "\u5408\u540c\u6536\u6b3e\u660e\u7ec6id" + temDo.getId() + "\u540c\u6b65\u5f02\u5e38\uff0c" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "\u8be6\u60c5\uff1a" + data.get("datum"), null);
                    this.conReceivableDRepo.updateRemark(temDo.getId());
                    ++failNum;
                }
                catch (Exception e) {
                    XxlJobLogger.log((String)("\u5408\u540c\u6536\u6b3e\u660e\u7ec6" + temDo.getId() + "\u540c\u6b65\u5f02\u5e38......" + e), (Object[])new Object[0]);
                    LocalDateTime syncEndTime = LocalDateTime.now();
                    this.saveSyncLog(syncType + "_exception", "\u5408\u540c\u6536\u6b3e\u660e\u7ec6id" + temDo.getId() + "\u540c\u6b65\u5f02\u5e38\uff0c" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "\u8be6\u60c5\uff1a" + e, null);
                    ++failNum;
                    this.conReceivableDRepo.updateRemark(temDo.getId());
                }
            }
            syncData = "\u66f4\u65b0\u4e86" + (conReceivableDDOS.size() - failNum) + "\u6570\u636e,\u6709" + failNum + "\u6761\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff01";
        } else {
            syncData = "\u5408\u540c\u6536\u6b3e\u660e\u7ec6\u6570\u636e\u672a\u53d8\u5316";
        }
        PrdOrgSyncLogDO logDO = this.saveSyncLog(syncType, (String)syncData, syncNow);
        XxlJobLogger.log((String)("\u540c\u6b65\u5408\u540c\u6536\u6b3e\u660e\u7ec6\u7ed3\u675f..." + logDO), (Object[])new Object[0]);
    }

    private PrdOrgSyncLogDO saveSyncLog(String syncType, String syncData, LocalDateTime currentTime) {
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        this.daoLog.save(logDO);
        return logDO;
    }

    public ConReceivableDServiceImpl(ConReceivableDRepo conReceivableDRepo, ConReceivableDDAO conReceivableDDAO, ConReceivablePlanRepo conReceivablePlanRepo, PrdOrgEmployeeService employeeService, PrdOrgSyncLogDAO daoLog, HttpUtil httpUtil) {
        this.conReceivableDRepo = conReceivableDRepo;
        this.conReceivableDDAO = conReceivableDDAO;
        this.conReceivablePlanRepo = conReceivablePlanRepo;
        this.employeeService = employeeService;
        this.daoLog = daoLog;
        this.httpUtil = httpUtil;
    }
}

