/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFinPeriodPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFinPeriodQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFinPeriodVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemFinPeriodDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemFinPeriodDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemFinYearDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemFinPeriodRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PrdSystemFinPeriodDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemFinPeriodRepo repo;
    private final QPrdSystemFinPeriodDO qdo = QPrdSystemFinPeriodDO.prdSystemFinPeriodDO;
    private final QPrdSystemFinYearDO qdoYear = QPrdSystemFinYearDO.prdSystemFinYearDO;

    private JPAQuery<PrdSystemFinPeriodVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdSystemFinPeriodVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.finYearId, this.qdo.finPeriod, this.qdo.periodName, this.qdo.periodStatus, this.qdo.beginDate, this.qdo.endDate, this.qdoYear.finYear})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoYear)).on((Predicate)this.qdo.finYearId.longValue().eq((Expression)this.qdoYear.id.longValue()));
    }

    private JPAQuery<PrdSystemFinPeriodVO> getJpaQueryWhere(PrdSystemFinPeriodQuery query) {
        JPAQuery<PrdSystemFinPeriodVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        ArrayList<OrderItem> orderse = new ArrayList<OrderItem>();
        orderse.add(OrderItem.desc((String)"beginDate"));
        query.setOrders(orderse);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(PrdSystemFinPeriodQuery query) {
        long total = this.getJpaQueryWhere(query).fetchCount();
        return total;
    }

    private Predicate where(PrdSystemFinPeriodQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFinYearId())) {
            list.add(this.qdo.finYearId.eq((Object)query.getFinYearId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFinPeriod())) {
            list.add(this.qdo.finPeriod.eq((Object)query.getFinPeriod()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPeriodName())) {
            list.add(this.qdo.periodName.like(SqlUtil.toSqlLikeString(query.getPeriodName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPeriodStatus())) {
            list.add(this.qdo.periodStatus.eq((Object)query.getPeriodStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBeginDate())) {
            list.add(this.qdo.beginDate.eq((Object)query.getBeginDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEndDate())) {
            list.add(this.qdo.endDate.eq((Object)query.getEndDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFinYear())) {
            list.add(this.qdoYear.finYear.eq((Object)query.getFinYear()));
        }
        return ExpressionUtils.allOf(list);
    }

    public PrdSystemFinPeriodVO queryByKey(Long id) {
        JPAQuery<PrdSystemFinPeriodVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PrdSystemFinPeriodVO)jpaQuery.fetchFirst();
    }

    public List<PrdSystemFinPeriodVO> queryListDynamic(PrdSystemFinPeriodQuery query) {
        JPAQuery<PrdSystemFinPeriodVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PrdSystemFinPeriodVO> queryPaging(PrdSystemFinPeriodQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PrdSystemFinPeriodVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PrdSystemFinPeriodDO save(PrdSystemFinPeriodDO ado) {
        return (PrdSystemFinPeriodDO)this.repo.save(ado);
    }

    public List<PrdSystemFinPeriodDO> saveAll(List<PrdSystemFinPeriodDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PrdSystemFinPeriodPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getFinYearId() != null) {
            update.set(this.qdo.finYearId, (Object)payload.getFinYearId());
        }
        if (payload.getFinPeriod() != null) {
            update.set(this.qdo.finPeriod, (Object)payload.getFinPeriod());
        }
        if (payload.getPeriodName() != null) {
            update.set((Path)this.qdo.periodName, (Object)payload.getPeriodName());
        }
        if (payload.getPeriodStatus() != null) {
            update.set((Path)this.qdo.periodStatus, (Object)payload.getPeriodStatus());
        }
        if (payload.getBeginDate() != null) {
            update.set(this.qdo.beginDate, (Object)payload.getBeginDate());
        }
        if (payload.getEndDate() != null) {
            update.set(this.qdo.endDate, (Object)payload.getEndDate());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("finYearId")) {
                update.setNull(this.qdo.finYearId);
            }
            if (nullFields.contains("finPeriod")) {
                update.setNull(this.qdo.finPeriod);
            }
            if (nullFields.contains("periodName")) {
                update.setNull((Path)this.qdo.periodName);
            }
            if (nullFields.contains("periodStatus")) {
                update.setNull((Path)this.qdo.periodStatus);
            }
            if (nullFields.contains("beginDate")) {
                update.setNull(this.qdo.beginDate);
            }
            if (nullFields.contains("endDate")) {
                update.setNull(this.qdo.endDate);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public PrdSystemFinPeriodVO selectInspect(String periodName) {
        JPAQuery<PrdSystemFinPeriodVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.periodName.eq((Object)periodName));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PrdSystemFinPeriodVO)jpaQuery.fetchFirst();
    }

    public PrdSystemFinPeriodDAO(JPAQueryFactory jpaQueryFactory, PrdSystemFinPeriodRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

