package com.elitesland.tw.tw5.server.common.workFlow;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface TwWorkflowCheckAnnotation {
    // 检查名称
    String name();
    // 检查编号
    String code();
    // 检查范围类型COMMON：公共，BUSINESS：功能业务
    String scope() default "BUSINESS";
    // 主表名称,范围类型为BUSINESS时，必须指定
    String tableName() default "";
    // 检查参数
    String params() default "";
    // 检查说明
    String description() default "";
    // 是否启用
    boolean enabled() default true;
}
