package com.elitesland.tw.tw5.server.prd.acc.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimTripStdPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimTripStdQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimTripStdService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimTripStdVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 差旅报销额度管理
 *
 * @author sunxw
 * @date 2023-12-04
 */
@Api(tags = "差旅报销额度管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/acc/accReimTripStd")
@Slf4j
public class AccReimTripStdController {

    private final AccReimTripStdService accReimTripStdService;

    /**
     * 差旅报销额度管理-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("差旅报销额度管理-新增")
    public TwOutputUtil<AccReimTripStdVO> insert(@RequestBody AccReimTripStdPayload payload) {
        return TwOutputUtil.ok(accReimTripStdService.insert(payload));
    }

    /**
     * 差旅报销额度管理-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("差旅报销额度管理-更新")
    public TwOutputUtil<AccReimTripStdVO> update(@RequestBody AccReimTripStdPayload payload) {
        return TwOutputUtil.ok(accReimTripStdService.update(payload));
    }

    /**
     * 差旅报销额度管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("差旅报销额度管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody AccReimTripStdPayload payload) {
        return TwOutputUtil.ok(accReimTripStdService.updateByKeyDynamic(payload));
    }

    /**
     * 差旅报销额度管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("差旅报销额度管理-主键查询")
    public TwOutputUtil<AccReimTripStdVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(accReimTripStdService.queryByKey(key));
    }

    /**
     * 差旅报销额度管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("差旅报销额度管理-分页")
    public TwOutputUtil<PagingVO<AccReimTripStdVO>> paging(AccReimTripStdQuery query) {
        return TwOutputUtil.ok(accReimTripStdService.queryPaging(query));
    }

    /**
     * 差旅报销额度管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("差旅报销额度管理-查询列表")
    public TwOutputUtil<List<AccReimTripStdVO>> queryList(AccReimTripStdQuery query) {
        return TwOutputUtil.ok(accReimTripStdService.queryListDynamic(query));
    }

    /**
     * 差旅报销额度管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("差旅报销额度管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        accReimTripStdService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

