package com.elitesland.tw.tw5.server.prd.adm.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmReasonService;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmReasonVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 事由管理
 *
 * @author carl
 * @date 2023-10-12
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AdmReasonServiceImpl extends BaseServiceImpl implements AdmReasonService {

    private final CacheUtil cacheUtil;

    private final CrmOpportunityService opportunityService;
    private final PmsProjectDAO pmsProjectDAO;
    @Value("${tw5.sys_default.ou_id:1001}")
    private Long ou_id;

    @Override
    public List<AdmReasonVO> queryReasonInfos(String reasonType) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        List<AdmReasonVO> list = new ArrayList<>();
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
            CrmOpportunityQuery query = new CrmOpportunityQuery();
            //query.setPreSaleUserId(loginUserId);
            //query.setProjectStatus("ACTIVE");
            List<CrmOpportunityListVO> crmOpportunityListVOS = opportunityService.queryListDynamic(query);
            //查询商机事由
            if (crmOpportunityListVOS != null) {
                crmOpportunityListVOS.forEach(vo -> {
                    AdmReasonVO reasonVO = new AdmReasonVO();
                    reasonVO.setId(vo.getId());
                    reasonVO.setName(vo.getProjectName());
                    reasonVO.setCode(vo.getProjectNo());
                    reasonVO.setExpenseBuId(vo.getPreSaleOrgId());
                    reasonVO.setExpenseBuName(cacheUtil.getOrgName(vo.getPreSaleOrgId()));
                    reasonVO.setExpenseCompanyId(ou_id);
                    reasonVO.setExpenseCompanyName(cacheUtil.getCompanyNameByBookId(ou_id));
                    reasonVO.setCustId(vo.getCustBookId());
                    reasonVO.setCustName(cacheUtil.getCompanyNameByBookId(vo.getCustBookId()));

                    reasonVO.setRemark("商机");
                    list.add(reasonVO);
                });
            }

        } else {
            //查询项目事由
            PmsProjectQuery query = new PmsProjectQuery();
            query.setLoginUserId(loginUserId);
            query.setProjStatus(ProjectStatusEnum.ACTIVE.getCode());
            List<PmsProjectVO> pmsProjectVOS = pmsProjectDAO.queryReasonProjectList(query);
            if (pmsProjectVOS != null) {
                pmsProjectVOS.forEach(vo -> {
                    AdmReasonVO reasonVO = new AdmReasonVO();
                    reasonVO.setId(vo.getId());
                    reasonVO.setName(vo.getProjName());
                    reasonVO.setCode(vo.getProjNo());
                    reasonVO.setExpenseBuId(vo.getDeliBuId());
                    reasonVO.setExpenseBuName(cacheUtil.getOrgName(vo.getDeliBuId()));
                    // todo wly
                    reasonVO.setExpenseCompanyId(vo.getOuBookId());
                    reasonVO.setExpenseCompanyName(cacheUtil.getCompanyNameByBookId(vo.getOuBookId()));
                    reasonVO.setCustId(vo.getCustId());
                    reasonVO.setCustName(cacheUtil.getCompanyNameByBookId(vo.getCustId()));
                    reasonVO.setCustBarExpense(vo.getCustBarExpense());
                    list.add(reasonVO);
                });
            }
        }

        return list;
    }

}
