package com.elitesland.tw.tw5.server.prd.administration.controller;

import com.elitesland.tw.tw5.api.prd.administration.payload.CertificationLicensePayload;
import com.elitesland.tw.tw5.api.prd.administration.query.CertificationLicenseQuery;
import com.elitesland.tw.tw5.api.prd.administration.vo.CertificationLicenseVO;
import com.elitesland.tw.tw5.api.prd.administration.service.CertificationLicenseService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 资质证照
 *
 * @folder 资质证照
 * @author wangly
 * @date 2023-09-20
 */
@Api(tags = "资质证照")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/certificationLicense")
@Slf4j
public class CertificationLicenseController {

private final CertificationLicenseService certificationLicenseService;

    /**
     * 资质证照-新增
     *
     * @folder 资质证照
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("资质证照-新增")
    public TwOutputUtil<CertificationLicenseVO> insert(@RequestBody CertificationLicensePayload payload){
         return TwOutputUtil.ok(certificationLicenseService.insert(payload));
    }

    /**
     * 资质证照-更新
     *
         * @folder 资质证照
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("资质证照-更新")
    public TwOutputUtil<CertificationLicenseVO> update(@RequestBody CertificationLicensePayload payload){
        return TwOutputUtil.ok(certificationLicenseService.update(payload));
    }

    /**
     * 资质证照-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 资质证照
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("资质证照-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody CertificationLicensePayload payload){
        return TwOutputUtil.ok(certificationLicenseService.updateByKeyDynamic(payload));
    }

    /**
     * 资质证照-主键查询
     *
     * @folder 资质证照
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("资质证照-主键查询")
    public TwOutputUtil<CertificationLicenseVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(certificationLicenseService.queryByKey(key));
    }

    /**
     * 资质证照-分页
     *
         * @folder 资质证照
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("资质证照-分页")
    public TwOutputUtil<PagingVO<CertificationLicenseVO>> paging(CertificationLicenseQuery query) {
        return TwOutputUtil.ok(certificationLicenseService.queryPaging(query));
    }

    /**
     * 资质证照-查询列表
     *
     * @folder 资质证照
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("资质证照-查询列表")
    public TwOutputUtil<List<CertificationLicenseVO>> queryList(CertificationLicenseQuery query) {
        return TwOutputUtil.ok(certificationLicenseService.queryListDynamic(query));
    }

    /**
     * 资质证照-删除
     *
         * @folder 资质证照
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("资质证照-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         certificationLicenseService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

