package com.elitesland.tw.tw5.server.prd.cal.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalEqvaIncomeLogPayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalEqvaIncomeLogQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalEqvaIncomeLogService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalEqvaIncomeLogVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 当量收入配置变更记录
 *
 * @folder 当量收入配置变更记录
 * @author wangly
 * @date 2024-02-22
 */
@Api(tags = "当量收入配置变更记录")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/calEqvaIncomeLog")
@Slf4j
public class CalEqvaIncomeLogController {

private final CalEqvaIncomeLogService calEqvaIncomeLogService;

    /**
     * 当量收入配置变更记录-新增
     *
     * @folder 当量收入配置变更记录
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("当量收入配置变更记录-新增")
    public TwOutputUtil<CalEqvaIncomeLogVO> insert(@RequestBody CalEqvaIncomeLogPayload payload){
         return TwOutputUtil.ok(calEqvaIncomeLogService.insert(payload));
    }

    /**
     * 当量收入配置变更记录-更新
     *
         * @folder 当量收入配置变更记录
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("当量收入配置变更记录-更新")
    public TwOutputUtil<CalEqvaIncomeLogVO> update(@RequestBody CalEqvaIncomeLogPayload payload){
        return TwOutputUtil.ok(calEqvaIncomeLogService.update(payload));
    }

    /**
     * 当量收入配置变更记录-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 当量收入配置变更记录
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("当量收入配置变更记录-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody CalEqvaIncomeLogPayload payload){
        return TwOutputUtil.ok(calEqvaIncomeLogService.updateByKeyDynamic(payload));
    }

    /**
     * 当量收入配置变更记录-主键查询
     *
     * @folder 当量收入配置变更记录
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("当量收入配置变更记录-主键查询")
    public TwOutputUtil<CalEqvaIncomeLogVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(calEqvaIncomeLogService.queryByKey(key));
    }

    /**
     * 当量收入配置变更记录-分页
     *
         * @folder 当量收入配置变更记录
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("当量收入配置变更记录-分页")
    public TwOutputUtil<PagingVO<CalEqvaIncomeLogVO>> paging(CalEqvaIncomeLogQuery query) {
        return TwOutputUtil.ok(calEqvaIncomeLogService.queryPaging(query));
    }

    /**
     * 当量收入配置变更记录-查询列表
     *
     * @folder 当量收入配置变更记录
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("当量收入配置变更记录-查询列表")
    public TwOutputUtil<List<CalEqvaIncomeLogVO>> queryList(CalEqvaIncomeLogQuery query) {
        return TwOutputUtil.ok(calEqvaIncomeLogService.queryListDynamic(query));
    }

    /**
     * 当量收入配置变更记录-删除
     *
         * @folder 当量收入配置变更记录
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("当量收入配置变更记录-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         calEqvaIncomeLogService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

