package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmLeadsOffshorePayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsOffshoreQuery;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.*;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmLeadsOffshoreRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.prj.entity.PrjProjectDO;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import javax.persistence.criteria.*;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zoey
 * @Description:
 * @date 2022/6/1 - 0:08
 */
@Repository
@RequiredArgsConstructor
public class CrmLeadsOffshoreDAO {
    private final CrmLeadsOffshoreRepo repo;
    private final JPAQueryFactory jpaQueryFactory;
    private final QCrmLeadsOffshoreDO qdo = QCrmLeadsOffshoreDO.crmLeadsOffshoreDO;
    private final PrdOrgEmployeeDAO employeeDAO;


    //分配领取类型为all,当前登录人是近海成员，且线索状态为已退回或者未分配
    public Specification<CrmLeadsOffshoreDO> getSpec(CrmLeadsOffshoreQuery query) {
        Specification<CrmLeadsOffshoreDO> querySpecifi = (root, criteriaQuery, cb) -> {
            List<Predicate> predicates = new ArrayList<>();

            // 使用左连接查询
            Join<CrmLeadsOffshoreDO, CrmOffshoreDO> offshoreJoin = root.join("offshore", JoinType.LEFT);
            Join<CrmOffshoreDO, CrmOffshoreRuleDO> offshoreRuleJoin = offshoreJoin.join("offshoreRule", JoinType.LEFT);
            Join<CrmOffshoreDO, CrmOffshoreMembersDO> offshoreMembersJoin = offshoreJoin.join("offshoreMembers", JoinType.LEFT);
            Join<CrmOffshoreDO, CrmOffshoreAdminDO> offshoreAdminJoin = offshoreJoin.join("offshoreAdmins", JoinType.LEFT);
            // 使用左连接查询
            Join<CrmLeadsOffshoreDO, CrmLeadsDO> leadsJoin = root.join("leads", JoinType.LEFT);
            Join<CrmLeadsDO, PrjProjectDO> marketJoin = leadsJoin.join("market", JoinType.LEFT);

            if (!ObjectUtils.isEmpty(query.getLeadsStatusList())) {
                //in查询
                Path<Object> path = leadsJoin.get("leadsStatus");
                CriteriaBuilder.In<Object> in = cb.in(path);
                for (String status : query.getLeadsStatusList()) {
                    in.value(status);
                }
                predicates.add(cb.and(in));
            }


            if (!ObjectUtils.isEmpty(query.getSaleOrCreateUserId())) {
                Predicate pred1 = cb.equal(leadsJoin.get("saleUserId"), query.getSaleOrCreateUserId());
                Predicate pred2 = cb.equal(leadsJoin.get("createUserId"), query.getSaleOrCreateUserId());
                predicates.add(cb.or(pred1, pred2));
            }
            if (!ObjectUtils.isEmpty(query.getNotDistributeLeadsRemindTimeNotNull()) && query.getNotDistributeLeadsRemindTimeNotNull() == true) {
                predicates.add(cb.isNotNull(root.get("notDistributeLeadsRemindTime").as(Long.class)));
            }
            //=========================线索表条件查询====================================
            if (!ObjectUtils.isEmpty(query.getLeadsIds())) {
                //in查询
                Path<Object> path = leadsJoin.get("id");
                CriteriaBuilder.In<Object> in = cb.in(path);
                for (Long id : query.getLeadsIds()) {
                    in.value(id);
                }
                predicates.add(cb.and(in));
            }
            if (!ObjectUtils.isEmpty(query.getLeadsIdsForFollow())) {
                //in查询
                Path<Object> path = leadsJoin.get("id");
                CriteriaBuilder.In<Object> in = cb.in(path);
                for (Long id : query.getLeadsIdsForFollow()) {
                    in.value(id);
                }
                predicates.add(cb.and(in));
            }
            if (!ObjectUtils.isEmpty(query.getLeadsIdsStr())) {
                final String[] split = query.getLeadsIdsStr().split(",");
                //in查询
                Path<Object> path = leadsJoin.get("id");
                CriteriaBuilder.In<Object> in = cb.in(path);
                for (String id : split) {
                    in.value(Long.valueOf(id));
                }
                predicates.add(cb.and(in));
            }
            if (!StringUtils.isEmpty(query.getLeadsTagIds())) {
                String[] split = query.getLeadsTagIds().split(",");
                Predicate[] predicatesArray = new Predicate[split.length];
                for (int i = 0; i < split.length; i++) {
                    predicatesArray[i] = cb.like(leadsJoin.get("leadsTagIds").as(String.class), SqlUtil.toSqlLikeString(split[i]));
                }
                predicates.add(cb.or(predicatesArray));
            }
            if (!ObjectUtils.isEmpty(query.getMarketChannel())) {
                predicates.add(cb.like(leadsJoin.get("marketChannel").as(String.class), SqlUtil.toSqlLikeString(query.getMarketChannel())));
            }
            if (!ObjectUtils.isEmpty(query.getFilterLeadsOffshore()) && query.getFilterLeadsOffshore() == true) {
                predicates.add(cb.equal(leadsJoin.get("offshoreId"), offshoreJoin.get("id")));
            }
            if (!ObjectUtils.isEmpty(query.getFilterOffshore()) && query.getFilterOffshore() == true) {
                predicates.add(cb.isNotNull(leadsJoin.get("offshoreId").as(Long.class)));
            }
            if (!ObjectUtils.isEmpty(query.getLeadsId())) {
                predicates.add(cb.equal(leadsJoin.get("id").as(Long.class), query.getLeadsId()));
            }
            if (!ObjectUtils.isEmpty(query.getSaleUserId())) {
                predicates.add(cb.equal(leadsJoin.get("saleUserId").as(Long.class), query.getSaleUserId()));
            }

            if (!StringUtils.isEmpty(query.getLeadsNo())) {
                predicates.add(cb.like(leadsJoin.get("leadNo").as(String.class), SqlUtil.toSqlLikeString(query.getLeadsNo())));
            }

            if (!ObjectUtils.isEmpty(query.getLeadsName())) {
                predicates.add(cb.like(leadsJoin.get("leadsName").as(String.class), SqlUtil.toSqlLikeString(query.getLeadsName())));
            }
            if (!ObjectUtils.isEmpty(query.getAnnualTurnover())) {
                predicates.add(cb.equal(leadsJoin.get("annualTurnover").as(String.class), query.getAnnualTurnover()));
            }
            if (!ObjectUtils.isEmpty(query.getArea())) {
                predicates.add(cb.like(leadsJoin.get("area").as(String.class), SqlUtil.toSqlLikeString(query.getArea())));
            }
            if (!ObjectUtils.isEmpty(query.getLeadsStatus())) {
                predicates.add(cb.equal(leadsJoin.get("leadsStatus").as(String.class), query.getLeadsStatus()));
            }
            if (!ObjectUtils.isEmpty(query.getDemandProduct())) {
                predicates.add(cb.equal(leadsJoin.get("demandProduct").as(String.class), query.getDemandProduct()));
            }
            if (!ObjectUtils.isEmpty(query.getDemandProductOrg())) {
                predicates.add(cb.equal(leadsJoin.get("demandProductOrg").as(Long.class), query.getDemandProductOrg()));
            }
            if (!ObjectUtils.isEmpty(query.getLeadsStage())) {
                predicates.add(cb.equal(leadsJoin.get("leadsStage").as(String.class), query.getLeadsStage()));
            }
            if (!ObjectUtils.isEmpty(query.getLeadsStageNotEqual())) {
                predicates.add(cb.notEqual(leadsJoin.get("leadsStage").as(String.class), query.getLeadsStageNotEqual()));
            }
            if (!ObjectUtils.isEmpty(query.getCreateUserIdNotEqual())) {
                predicates.add(cb.notEqual(leadsJoin.get("createUserId").as(String.class), query.getCreateUserIdNotEqual()));
            }
            if (!ObjectUtils.isEmpty(query.getDemandProduct())) {
                predicates.add(cb.equal(leadsJoin.get("demandProduct").as(String.class), query.getDemandProduct()));
            }
            if (!ObjectUtils.isEmpty(query.getSaleUserId())) {
                predicates.add(cb.equal(leadsJoin.get("saleUserId").as(String.class), query.getSaleUserId()));
            }
            //TODO:后续优化
            if (!ObjectUtils.isEmpty(query.getLeadsStageNotIn())) {
                List<String> leadsStageNotIn = query.getLeadsStageNotIn();
                for (String s : leadsStageNotIn) {
                    predicates.add(cb.notEqual(leadsJoin.get("leadsStage").as(String.class), s));
                }
            }
            if (!ObjectUtils.isEmpty(query.getExpireDays())) {
                //分配日期不为空，且分配日期加上超过日期恰好等于当前日期
                predicates.add(cb.isNotNull(leadsJoin.get("distributeDate")));
//                DateTimeFormatter dateTimeFormatter=DateTimeFormatter.ofPattern("yyyy-MM-dd");
//                String format = dateTimeFormatter.format(LocalDate.now().minusDays(query.getExpireDays()));
//                LocalDate localDate = LocalDate.parse(format, dateTimeFormatter);
                predicates.add(cb.equal(leadsJoin.get("distributeDate").as(String.class), LocalDate.now().minusDays(query.getExpireDays()).toString()));
            }
            if (!ObjectUtils.isEmpty(query.getSourceType())) {
                predicates.add(cb.equal(leadsJoin.get("sourceType").as(String.class), query.getSourceType()));
            }
            if (!ObjectUtils.isEmpty(query.getMarketId())) {
                predicates.add(cb.equal(marketJoin.get("id").as(Long.class), query.getMarketId()));
            }
            if (!ObjectUtils.isEmpty(query.getCreateTimeStart())) {
                //大于或等于开始时间
                predicates.add(cb.greaterThanOrEqualTo(leadsJoin.get("createTime").as(LocalDateTime.class), query.getCreateTimeStart()));
            }
            if (!ObjectUtils.isEmpty(query.getCreateTimeEnd())) {
                //小于或等于结束时间
                predicates.add(cb.lessThanOrEqualTo(leadsJoin.get("createTime").as(LocalDateTime.class), query.getCreateTimeEnd()));
            }
            // 使用左连接查询
            Join<CrmLeadsDO, CrmLeadsCustomerDO> customerJoin = leadsJoin.join("customer", JoinType.LEFT);
            if (!StringUtils.isEmpty(query.getCustomerContacts())) {
                predicates.add(cb.like(customerJoin.get("customerContacts").as(String.class), SqlUtil.toSqlLikeString(query.getCustomerContacts())));
            }
            if (!StringUtils.isEmpty(query.getContactsPhone())) {
                predicates.add(cb.like(customerJoin.get("contactsPhone").as(String.class), SqlUtil.toSqlLikeString(query.getContactsPhone())));
            }
            if (!StringUtils.isEmpty(query.getContactsEmail())) {
                predicates.add(cb.like(customerJoin.get("contactsEmail").as(String.class), SqlUtil.toSqlLikeString(query.getContactsEmail())));
            }
            if (!ObjectUtils.isEmpty(query.getCustomerName())) {
                predicates.add(cb.like(customerJoin.get("customerName").as(String.class), SqlUtil.toSqlLikeString(query.getCustomerName())));
            }
            if (!ObjectUtils.isEmpty(query.getCustomerNameEqual())) {
                predicates.add(cb.equal(customerJoin.get("customerName").as(String.class), query.getCustomerNameEqual()));
            }
            if (!ObjectUtils.isEmpty(query.getCustomerIndustry())) {
                predicates.add(cb.equal(customerJoin.get("customerIndustry").as(String.class), query.getCustomerIndustry()));
            }
            if (!ObjectUtils.isEmpty(query.getCustomerGrade())) {
                predicates.add(cb.equal(customerJoin.get("customerGrade").as(String.class), query.getCustomerGrade()));
            }
            if (!ObjectUtils.isEmpty(query.getCustRegion())) {
                predicates.add(cb.equal(customerJoin.get("custRegion").as(String.class), query.getCustRegion()));
            }
            //===============================近海表条件查询===================================
            if (!ObjectUtils.isEmpty(query.getOffshoreId())) {
                if (query.getOffshoreId() != 0) {
                    predicates.add(cb.equal(offshoreJoin.get("id").as(String.class), query.getOffshoreId()));
                }
            }
            if (!ObjectUtils.isEmpty(query.getOffshoreIds())) {
                final String[] split = query.getOffshoreIds().split(",");
                //in查询
                Path<Object> path = offshoreJoin.get("id");
                CriteriaBuilder.In<Object> in = cb.in(path);
                for (String id : split) {
                    in.value(Long.valueOf(id));
                }
                predicates.add(cb.and(in));
            }
            if (!StringUtils.isEmpty(query.getOffshoreName())) {
                predicates.add(cb.like(offshoreJoin.get("offshoreName").as(String.class), SqlUtil.toSqlLikeString(query.getOffshoreName())));
            }
            if (!ObjectUtils.isEmpty(query.getOffshoreAdminId())) {
                predicates.add(cb.equal(offshoreAdminJoin.get("userId").as(Long.class), query.getOffshoreAdminId()));
            }

            if (!ObjectUtils.isEmpty(query.getDistributeReceiveRule())) {
                predicates.add(cb.equal(offshoreRuleJoin.get("distributeReceiveRule").as(String.class), query.getDistributeReceiveRule()));
            }

            if (!ObjectUtils.isEmpty(query.getMemberId())) {
                predicates.add(cb.equal(offshoreMembersJoin.get("userId").as(Long.class), query.getMemberId()));
            }
            predicates.add(cb.equal(offshoreJoin.get("deleteFlag"), 0));
            criteriaQuery.distinct(true);

//            criteriaQuery.groupBy(leadsJoin.get("id"),leadsJoin.get("offshoreId"));
            return cb.and(predicates.toArray(new Predicate[predicates.size()]));
        };

        return querySpecifi;
    }

    public Page<CrmLeadsOffshoreDO> findAll(Specification<CrmLeadsOffshoreDO> spec, Pageable pageable) {
        pageable = PageUtil.defaultSort(pageable);
        return repo.findAll(spec, pageable);
    }

    public List<CrmLeadsOffshoreDO> findAll(Specification<CrmLeadsOffshoreDO> spec) {
        return repo.findAll(spec);
    }

    public CrmLeadsOffshoreDO save(CrmLeadsOffshoreDO leadsOffshore) {
        return repo.save(leadsOffshore);
    }


    public void setLeadsOffshoresOrder(Long id, int index) {
        repo.saveIndex(id, index);
    }


    public Long countBySpec(Specification<CrmLeadsOffshoreDO> spec) {
        return repo.count(spec);
    }


    public void deleteSoft(Long id) {
        repo.deleteById(id);
    }


    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public void updateByKeyDynamic(CrmLeadsOffshorePayload payload) {
        //查询出当前的do
        CrmLeadsOffshoreDO crmLeadsOffshoreDO = repo.findById(payload.getId()).orElse(null);
        if (crmLeadsOffshoreDO != null) {

            if (payload.getRemark() != null) {
                crmLeadsOffshoreDO.setRemark(payload.getRemark());
            }
            if (payload.getNotDistributeLeadsRemindTime() != null) {
                crmLeadsOffshoreDO.setNotDistributeLeadsRemindTime(payload.getNotDistributeLeadsRemindTime());
            }
            // 处理要设置成空的字段
            List<String> nullFields = payload.getNullFields();
            if (nullFields != null && nullFields.size() > 0) {
                if (nullFields.contains("notDistributeLeadsRemindTime")) {
                    crmLeadsOffshoreDO.setNotDistributeLeadsRemindTime(null);
                }
            }
            repo.save(crmLeadsOffshoreDO);
        }
    }

    public long deleteSoftByLeadsIds(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.leads.id.in(keys));
        return update.execute();
    }

    public int getExist(Long leadsId, Long offshoreId) {
        return repo.getExistNum(leadsId, offshoreId);
    }
}
