package com.elitesland.tw.tw5.server.prd.crm.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @Author carl.wang
 * @Description 活动跟进动态表
 * @Date
 **/
@Entity
@Table(name = "crm_act_dynamic", indexes = {
        @Index(name = "act_index", columnList = "act_id"),
})
@org.hibernate.annotations.Table(appliesTo = "crm_act_dynamic", comment = "活动跟进动态表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmActDynamicDO extends BaseModel {

    @Comment("活动id")
    @Column(name = "act_id", nullable = false)
    private Long actId;

    @Comment("跟进类型")
    @Column()
    private String dynamicType;

    @Comment("记录内容")
    @Column()
    private String dynamicContent;

    @Comment("附件地址")
    @Column()
    private String fileCodes;


}
