package com.elitesland.tw.tw5.server.prd.crm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;

/**
 * 礼品单明细
 *
 * @author xxb
 * @date 2023-08-31
 */
@Entity
@Table(name = "crm_gift_info", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_gift_info", comment = "礼品单明细")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmGiftInfoDO extends BaseModel implements Serializable  {
    /** 礼品单ID */
    @Comment("礼品单ID")
    @Column()
    private Long giftListId;
    /** 礼品名称 */
    @Comment("礼品名称")
    @Column()
    private String giftName;
    /** 申请数量 */
    @Comment("申请数量")
    @Column()
    private String giftNumber;
    /** 单位 */
    @Comment("单位")
    @Column()
    private String giftUnit;

    @Comment("客户表主键")
    @Column()
    private Long customerId;
    /** 客户方名称 */
    @Comment("客户方名称")
    @Column()
    private String custName;
    /** 客户方地址 */
    @Comment("客户方地址")
    @Column()
    private String custAddress;

    /** 经营人脉 */
    @Comment("经营人脉")
    @Column()
    private Long peopleId;
    /** 经营人脉 */
    @Comment("经营人脉")
    @Column()
    private String peopleName;
    /** 客户经营部门 */
    @Comment("经营人脉部门")
    @Column()
    private String custOperBu;
    /** 岗位情况 */
    @Comment("岗位情况")
    @Column()
    private String jobDetail;
    /** 联系方式 */
    @Comment("联系方式")
    @Column()
    private String mobile;
    /** 礼品寄送地址 */
    @Comment("礼品寄送地址")
    @Column()
    private String locationDetail;
    /** 赠送理由 */
    @Comment("赠送理由")
    @Column()
    private String reason;


    public void copy(CrmGiftInfoDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
