package com.elitesland.tw.tw5.server.prd.humanresources.ability.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdCompositeAbilityStructPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdCompositeAbilityStructQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdCompositeAbilityStructVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;

import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdCompositeAbilityStructService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;


/**
 * @author : WWW
 * @date : 2023-10-23
 * @desc : 复合能力构成
 */

@RestController
@RequestMapping("/api/prdCompositeAbilityStruct")
@RequiredArgsConstructor
@Api(value = "复合能力构成", tags = {"复合能力构成"})
public class PrdCompositeAbilityStructController {

    private final PrdCompositeAbilityStructService prdCompositeAbilityStructService;


    @GetMapping("get/{id}")
    @ApiOperation("详情-复合能力构成")
    public TwOutputUtil<PrdCompositeAbilityStructVO> get(@PathVariable Long id) {

        PrdCompositeAbilityStructVO res = prdCompositeAbilityStructService.get(id);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("save")
    @ApiOperation("新增-复合能力构成")
    public TwOutputUtil<Long> save(@RequestBody PrdCompositeAbilityStructPayload prdCompositeAbilityStructPayload) {

        PrdCompositeAbilityStructVO res = prdCompositeAbilityStructService.save(prdCompositeAbilityStructPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @PostMapping("update")
    @ApiOperation("修改-复合能力构成")
    public TwOutputUtil<Long> update(@RequestBody PrdCompositeAbilityStructPayload prdCompositeAbilityStructPayload) {

        PrdCompositeAbilityStructVO res = prdCompositeAbilityStructService.update(prdCompositeAbilityStructPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @DeleteMapping("del")
    @ApiOperation("删除-复合能力构成")
    public TwOutputUtil<Long> del(Long[] ids) {

        Long res = prdCompositeAbilityStructService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-复合能力构成")
    public TwOutputUtil<PagingVO<PrdCompositeAbilityStructVO>> page(PrdCompositeAbilityStructQuery prdCompositeAbilityStructQuery) {

        PagingVO<PrdCompositeAbilityStructVO> res = prdCompositeAbilityStructService.page(prdCompositeAbilityStructQuery);
        return TwOutputUtil.ok(res);

    }


}

