package com.elitesland.tw.tw5.server.prd.humanresources.ability.dao;

import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdCompositeAbilityStructQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdCompositeAbilityStructVO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.PrdCompositeAbilityStructDO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.QPrdCompositeAbilityStructDO;

import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;

import java.util.ArrayList;


/**
 * @author : WWW
 * @date : 2023-10-23
 * @desc : 复合能力构成RepoProc
 */

@Component
public class PrdCompositeAbilityStructDao extends BaseRepoProc<PrdCompositeAbilityStructDO> {

    private static final QPrdCompositeAbilityStructDO qPrdCompositeAbilityStructDO = QPrdCompositeAbilityStructDO.prdCompositeAbilityStructDO;


    protected PrdCompositeAbilityStructDao() {

        super(qPrdCompositeAbilityStructDO);

    }


    public PagingVO<PrdCompositeAbilityStructVO> page(PrdCompositeAbilityStructQuery prdCompositeAbilityStructQuery) {

        JPAQuery<PrdCompositeAbilityStructVO> query =
                select(PrdCompositeAbilityStructVO.class)
                        .where(bulidPredicate(prdCompositeAbilityStructQuery));
        prdCompositeAbilityStructQuery.setPaging(query);
        prdCompositeAbilityStructQuery.fillOrders(query, qPrdCompositeAbilityStructDO);
        return PagingVO.<PrdCompositeAbilityStructVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPrdCompositeAbilityStructDO)
                .set(qPrdCompositeAbilityStructDO.deleteFlag, 1)
                .where(qPrdCompositeAbilityStructDO.id.in(ids))
                .execute();

        return res;

    }


    public PrdCompositeAbilityStructVO get(Long id) {

        PrdCompositeAbilityStructVO prdCompositeAbilityStructVO = select(PrdCompositeAbilityStructVO.class)
                .where(qPrdCompositeAbilityStructDO.id.eq(id))
                .fetchOne();

        return prdCompositeAbilityStructVO;

    }


    public List<PrdCompositeAbilityStructVO> getList(PrdCompositeAbilityStructQuery prdCompositeAbilityStructQuery) {

        List<PrdCompositeAbilityStructVO> res =
                select(PrdCompositeAbilityStructVO.class)
                        .where(bulidPredicate(prdCompositeAbilityStructQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qPrdCompositeAbilityStructDO.individAbilityId,
                        qPrdCompositeAbilityStructDO.individAbilityName,
                        qPrdCompositeAbilityStructDO.individAbilityLevelId,
                        qPrdCompositeAbilityStructDO.cateType,
                        qPrdCompositeAbilityStructDO.abilityId,
                        qPrdCompositeAbilityStructDO.levelDtlId,
                        qPrdCompositeAbilityStructDO.levelDtlName,
                        qPrdCompositeAbilityStructDO.id,
                        qPrdCompositeAbilityStructDO.createTime,
                        qPrdCompositeAbilityStructDO.remark

                )).from(qPrdCompositeAbilityStructDO);

    }


    private Predicate bulidPredicate(PrdCompositeAbilityStructQuery prdCompositeAbilityStructQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(null != prdCompositeAbilityStructQuery.getIndividAbilityId(), qPrdCompositeAbilityStructDO.individAbilityId, prdCompositeAbilityStructQuery.getIndividAbilityId())
                .andEq(StringUtils.isNotBlank(prdCompositeAbilityStructQuery.getIndividAbilityName()), qPrdCompositeAbilityStructDO.individAbilityName, prdCompositeAbilityStructQuery.getIndividAbilityName())
                .andEq(StringUtils.isNotBlank(prdCompositeAbilityStructQuery.getCateType()), qPrdCompositeAbilityStructDO.cateType, prdCompositeAbilityStructQuery.getCateType())
                .andEq(null != prdCompositeAbilityStructQuery.getAbilityId(), qPrdCompositeAbilityStructDO.abilityId, prdCompositeAbilityStructQuery.getAbilityId())
                .andEq(null != prdCompositeAbilityStructQuery.getLevelDtlId(), qPrdCompositeAbilityStructDO.levelDtlId, prdCompositeAbilityStructQuery.getLevelDtlId())
                .andEq(StringUtils.isNotBlank(prdCompositeAbilityStructQuery.getLevelDtlName()), qPrdCompositeAbilityStructDO.levelDtlName, prdCompositeAbilityStructQuery.getLevelDtlName())
                .build();

        return predicate;

    }


    private List<Predicate> bulidPredicates(PrdCompositeAbilityStructQuery prdCompositeAbilityStructQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 单项能力id
        if (null != prdCompositeAbilityStructQuery.getIndividAbilityId()) {
            predicates.add(qPrdCompositeAbilityStructDO.individAbilityId.eq(prdCompositeAbilityStructQuery.getIndividAbilityId()));
        }
        // 单项能力name
        if (StringUtils.isNotEmpty(prdCompositeAbilityStructQuery.getIndividAbilityName())) {
            predicates.add(qPrdCompositeAbilityStructDO.individAbilityName.eq(prdCompositeAbilityStructQuery.getIndividAbilityName()));
        }
        // 分类名称
        if (StringUtils.isNotEmpty(prdCompositeAbilityStructQuery.getCateType())) {
            predicates.add(qPrdCompositeAbilityStructDO.cateType.eq(prdCompositeAbilityStructQuery.getCateType()));
        }
        // 能力id
        if (null != prdCompositeAbilityStructQuery.getAbilityId()) {
            predicates.add(qPrdCompositeAbilityStructDO.abilityId.eq(prdCompositeAbilityStructQuery.getAbilityId()));
        }
        // 级别明细id
        if (null != prdCompositeAbilityStructQuery.getLevelDtlId()) {
            predicates.add(qPrdCompositeAbilityStructDO.levelDtlId.eq(prdCompositeAbilityStructQuery.getLevelDtlId()));
        }
        // 级别明细名称
        if (StringUtils.isNotEmpty(prdCompositeAbilityStructQuery.getLevelDtlName())) {
            predicates.add(qPrdCompositeAbilityStructDO.levelDtlName.eq(prdCompositeAbilityStructQuery.getLevelDtlName()));
        }

//      Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicates;
    }


    public Long count(PrdCompositeAbilityStructQuery prdCompositeAbilityStructQuery) {

        long res = select(PrdCompositeAbilityStructVO.class)
                .where(bulidPredicate(prdCompositeAbilityStructQuery))
                .fetchCount();

        return res;


    }

    public Long delByAbilitId(Long id) {
        long res = jpaQueryFactory.update(qPrdCompositeAbilityStructDO)
                .set(qPrdCompositeAbilityStructDO.deleteFlag, 1)
                .where(qPrdCompositeAbilityStructDO.abilityId.eq(id))
                .execute();
        return res;

    }

}

