package com.elitesland.tw.tw5.server.prd.humanresources.examination.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.query.CalTaskSettleQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalTaskSettleService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalTaskSettleVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamResDtlPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamResultPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamPointQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamResDtlQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamResultQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamPointService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamResDtlService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamResultService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamPointVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamResDtlVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamResultVO;
import com.elitesland.tw.tw5.api.prd.my.service.VacationService;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeEqvaRatioQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeEqvaRatioVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.base.HrBaseEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdPerformanceExamResultConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.dao.PrdPerformanceExamResultDao;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdPerformanceExamResultDO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.repo.PrdPerformanceExamResultRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * @author : WWW
 * @date : 2023-11-15
 * @desc : 绩效考核结果Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdPerformanceExamResultServiceImpl implements PrdPerformanceExamResultService {


    private final PrdPerformanceExamResultDao prdPerformanceExamResultDao;

    private final PrdPerformanceExamResultRepo prdPerformanceExamResultRepo;

    private final PrdPerformanceExamResDtlService prdPerformanceExamResDtlService;

    private final PrdPerformanceExamPointService prdPerformanceExamPointService;

    private final PrdEvaluateService prdEvaluateService;

    private final CalTaskSettleService calTaskSettleService;

    private final VacationService vacationService;

    private final PrdOrgEmployeeEqvaRatioService eqvaRatioService;

    private final CacheUtil cacheUtil;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdPerformanceExamResultVO save(PrdPerformanceExamResultPayload prdPerformanceExamResultPayload) {

        checkData(prdPerformanceExamResultPayload);
        PrdPerformanceExamResultDO prdPerformanceExamResultDO = new PrdPerformanceExamResultDO();
        prdPerformanceExamResultDO = PrdPerformanceExamResultConvert.INSTANCE.p2d(prdPerformanceExamResultPayload);
        PrdPerformanceExamResultDO res = prdPerformanceExamResultRepo.save(prdPerformanceExamResultDO);

        // 新增绩效考核明细
        PrdPerformanceExamPointQuery prdPerformanceExamPointQuery = new PrdPerformanceExamPointQuery();
        prdPerformanceExamPointQuery.setExamId(prdPerformanceExamResultPayload.getExamId());
        List<PrdPerformanceExamPointVO> pointVOList = prdPerformanceExamPointService.getList(prdPerformanceExamPointQuery);

        pointVOList.forEach(x -> {
            PrdPerformanceExamResDtlPayload prdPerformanceExamResDtlPayload = new PrdPerformanceExamResDtlPayload();
            prdPerformanceExamResDtlPayload.setResultId(res.getId());
            prdPerformanceExamResDtlPayload.setPointId(x.getId());
            // 权重
            prdPerformanceExamResDtlPayload.setWeightRatio(x.getWeightRatio());
            // 考核点
            prdPerformanceExamResDtlPayload.setPointName(x.getName());
            // 考评人
            prdPerformanceExamResDtlPayload.setEvalUser(x.getName());
            // 评分类型
            prdPerformanceExamResDtlPayload.setScoreType(x.getScoreType());


            // 评分标准
            prdPerformanceExamResDtlPayload.setStandardDesc(x.getStandardDesc());

            // 系统自动评分
            if (x.getScoreType().equals(HrBaseEnum.SYSTEM_AUTO.getCode())) {

                // 当量年度考评
                if (x.getName().equals(HrBaseEnum.EXAM_EQVA_YEAR.getCode())) {

                    LocalDate currentDate = LocalDate.now();
                    // 获取年度开始时间-结束时间
                    LocalDate firstDayOfYear = currentDate.with(TemporalAdjusters.firstDayOfYear());
                    LocalDate lastDayOfYear = currentDate.with(TemporalAdjusters.lastDayOfYear());

                    // 处理获取 当量评分
                    BigDecimal score = dealScore(prdPerformanceExamResultPayload, firstDayOfYear, lastDayOfYear, prdPerformanceExamResDtlPayload);
                    // 评分结果
                    prdPerformanceExamResDtlPayload.setScoreRes(score);
                    // 考评人
                    prdPerformanceExamResDtlPayload.setEvalUser(HrBaseEnum.STSTEM_AUTO_SCORE.getDesc());


                } else if (x.getName().equals(HrBaseEnum.EXAM_EQVA.getCode())) {
                    // 指定时间段内 当量考评
                    LocalDate startPeriodDate = prdPerformanceExamResultPayload.getExamStartPeriod();
                    LocalDate endPeriodDate = prdPerformanceExamResultPayload.getExamEndPeriod();

                    // 处理获取 当量评分
                    BigDecimal score = dealScore(prdPerformanceExamResultPayload, startPeriodDate, endPeriodDate, prdPerformanceExamResDtlPayload);
                    // 评分结果
                    prdPerformanceExamResDtlPayload.setScoreRes(score);
                    // 考评人
                    prdPerformanceExamResDtlPayload.setEvalUser(HrBaseEnum.STSTEM_AUTO_SCORE.getDesc());

                } else if (x.getName().equals(HrBaseEnum.TASK_EVALUATION.getCode())) {
                    // 任务评价
                    PrdEvaluateQuery prdEvaluateQuery = new PrdEvaluateQuery();
                    prdEvaluateQuery.setToEvalUserId(prdPerformanceExamResultPayload.getUserId());
                    prdEvaluateQuery.setCate("TASK");
                    List<PrdEvaluateVO> prdEvaluateVOList = prdEvaluateService.getScoreListByUserId(prdEvaluateQuery);
                    // 默认为 60分
                    BigDecimal score = new BigDecimal("60");
                    if (CollectionUtil.isNotEmpty(prdEvaluateVOList)) {

                        BigDecimal sumScore = new BigDecimal("10").multiply(new BigDecimal(prdEvaluateVOList.size()));
                        BigDecimal average = prdEvaluateVOList.stream().map(vo -> ObjectUtils.isEmpty(vo.getAverageScore()) ? new BigDecimal(0) : vo.getAverageScore()).reduce(BigDecimal.ZERO, BigDecimal::add);
                        // 平均分数 / 总分数
                        score = average.divide(sumScore, 2, BigDecimal.ROUND_HALF_UP);
                        log.info("任务得分为：{}", score);
                    }
                    // 系统统计
                    prdPerformanceExamResDtlPayload.setSysExam("任务评分:" + score);
                    // 评分结果
                    prdPerformanceExamResDtlPayload.setScoreRes(score);
                    // 考评人
                    prdPerformanceExamResDtlPayload.setEvalUser(HrBaseEnum.STSTEM_AUTO_SCORE.getDesc());

                }

            }
            prdPerformanceExamResDtlService.save(prdPerformanceExamResDtlPayload);
        });

        return PrdPerformanceExamResultConvert.INSTANCE.d2v(res);

    }

    private BigDecimal dealScore(PrdPerformanceExamResultPayload prdPerformanceExamResultPayload, LocalDate firstDayOfYear, LocalDate lastDayOfYear, PrdPerformanceExamResDtlPayload prdPerformanceExamResDtlPayload) {

        BigDecimal edDl = getEdEqva(firstDayOfYear, lastDayOfYear, prdPerformanceExamResultPayload.getUserId());

        // 该资源获取时间段内已结算当量
        CalTaskSettleQuery calTaskSettleQuery = new CalTaskSettleQuery();
        // 年初/年末
        calTaskSettleQuery.setSettleStartDate(firstDayOfYear);
        calTaskSettleQuery.setSettleEndDate(lastDayOfYear);

        calTaskSettleQuery.setIncomeResId(prdPerformanceExamResultPayload.getUserId());
        List<CalTaskSettleVO> calTaskSettleVOS = calTaskSettleService.queryListDynamic(calTaskSettleQuery);
        // 结算当量
        BigDecimal jsDl = calTaskSettleVOS.stream().map(x1 -> ObjectUtils.isEmpty(x1.getApproveSettleEqva()) ? BigDecimal.ZERO : x1.getApproveSettleEqva()).reduce(BigDecimal.ZERO, BigDecimal::add);
        // 系统统计
        prdPerformanceExamResDtlPayload.setSysExam("额定当量为: " + edDl + ",已结算当量为:" + jsDl);
        log.info("额定当量为: " + edDl + ",已结算当量为:" + jsDl);

        // 评分结果  该资源的 已结算当量/额定当量
        BigDecimal score = jsDl.divide(edDl, 2, BigDecimal.ROUND_HALF_UP);
        return score;
    }

    /**
     * 开始/结束时间处理
     *
     * @param prdOrgEmployeeEqvaRatioVO
     * @param startDate
     * @param endDate
     */
    private void dealDate(PrdOrgEmployeeEqvaRatioVO prdOrgEmployeeEqvaRatioVO, LocalDate startDate, LocalDate endDate) {

        // 如果开始时间在 2022-01-01之前，截取，--》算天数
        if (prdOrgEmployeeEqvaRatioVO.getStartDate().isBefore(startDate)) {
            prdOrgEmployeeEqvaRatioVO.setStartDate(startDate);
        }

        // 如果没有结束时间，结束时间为所选结束时间
        if (null == prdOrgEmployeeEqvaRatioVO.getEndDate()) {
            prdOrgEmployeeEqvaRatioVO.setEndDate(endDate);
        }
        // 如果结束时间在 2022-12-31 之后，截取 --》算天数
        if (prdOrgEmployeeEqvaRatioVO.getEndDate().isAfter(endDate)) {
            prdOrgEmployeeEqvaRatioVO.setEndDate(endDate);
        }

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdPerformanceExamResultVO update(PrdPerformanceExamResultPayload prdPerformanceExamResultPayload) {

        Assert.notNull(prdPerformanceExamResultPayload.getId(), "id is null");
        PrdPerformanceExamResultVO res = save(prdPerformanceExamResultPayload);
        return res;

    }


    @Override
    public PrdPerformanceExamResultVO get(Long id) {

        if (null == id) {
            return null;
        }
        PrdPerformanceExamResultVO res = prdPerformanceExamResultDao.get(id);
        if (null != res.getExamCreatUserId()) {
            String userName = cacheUtil.getUserName(res.getExamCreatUserId());
            res.setExamCreatUser(userName);
        }
        if (null != res.getUserId()) {
            res.setEmpName(cacheUtil.getUserName(res.getUserId()));
        }
        if (null != res.getBaseBuId()) {
            res.setBaseBuName(cacheUtil.getOrgName(res.getBaseBuId()));
        }
        // 结果明细
        PrdPerformanceExamResDtlQuery prdPerformanceExamResDtlQuery = new PrdPerformanceExamResDtlQuery();
        prdPerformanceExamResDtlQuery.setResultId(id);
        List<PrdPerformanceExamResDtlVO> list = prdPerformanceExamResDtlService.getList(prdPerformanceExamResDtlQuery);
        list.forEach(x -> {
            String userName = cacheUtil.getUserName(x.getEvalUserId());
            x.setEvalUser(userName);

        });
        res.setPrdPerformanceExamResDtlVOList(list);
        return res;

    }


    @Override
    public PagingVO<PrdPerformanceExamResultVO> page(PrdPerformanceExamResultQuery prdPerformanceExamResultQuery) {

        PagingVO<PrdPerformanceExamResultVO> res = prdPerformanceExamResultDao.page(prdPerformanceExamResultQuery);
        res.getRecords().forEach(x -> {
            if (null != x.getUserId()) {
                String userName = cacheUtil.getUserName(x.getUserId());
                x.setEmpName(userName);
            }
            if (null != x.getBaseBuId()) {
                String orgName = cacheUtil.getOrgName(x.getBaseBuId());
                x.setBaseBuName(orgName);
            }

        });
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdPerformanceExamResultDao.del(ids);
        return res;

    }

    @Override
    public List<PrdPerformanceExamResultVO> getList(PrdPerformanceExamResultQuery prdPerformanceExamResultQuery) {

        List<PrdPerformanceExamResultVO> res = prdPerformanceExamResultDao.getList(prdPerformanceExamResultQuery);
        return res;

    }


    /**
     * 数据校验
     *
     * @param prdPerformanceExamResultPayload
     */
    private void checkData(PrdPerformanceExamResultPayload prdPerformanceExamResultPayload) {

        if (null == (prdPerformanceExamResultPayload.getUserId())) {
            throw new BusinessException("userId不能为空");
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateByCondition(PrdPerformanceExamResultPayload prdPerformanceExamResultPayload) {
        Assert.notNull(prdPerformanceExamResultPayload.getId(), "id不能为空");
        Long res = prdPerformanceExamResultDao.update(prdPerformanceExamResultPayload);
        return res;
    }

    @Override
    public PrdPerformanceExamResultVO getBySelf(Long id) {

        if (null == id) {
            return null;
        }
        PrdPerformanceExamResultVO res = prdPerformanceExamResultDao.get(id);
        // 结果明细
        PrdPerformanceExamResDtlQuery prdPerformanceExamResDtlQuery = new PrdPerformanceExamResDtlQuery();
        prdPerformanceExamResDtlQuery.setResultId(id);
        List<PrdPerformanceExamResDtlVO> list = prdPerformanceExamResDtlService.getList(prdPerformanceExamResDtlQuery);
        list.forEach(x -> {
            x.setEvalDesc(null);
        });
        res.setPrdPerformanceExamResDtlVOList(list);
        return res;
    }

    @Override
    public BigDecimal getEdEqva(LocalDate startDate, LocalDate endDate, Long userId) {

        Map<String, BigDecimal> utMap = getStringBigDecimalMap();

        // 获取当年的个人当量系数列表
        PrdOrgEmployeeEqvaRatioQuery prdOrgEmployeeEqvaRatioQuery = new PrdOrgEmployeeEqvaRatioQuery();

        prdOrgEmployeeEqvaRatioQuery.setUserId(userId);
        prdOrgEmployeeEqvaRatioQuery.setStartDate(startDate);
        prdOrgEmployeeEqvaRatioQuery.setEndDate(endDate);

        List<PrdOrgEmployeeEqvaRatioVO> eqvaRatioListByDate = eqvaRatioService.getEqvaRatioListByDate(prdOrgEmployeeEqvaRatioQuery);
        // 额定当量
        BigDecimal edDl = BigDecimal.ZERO;
        // 时间段内的当量数据计算
        for (PrdOrgEmployeeEqvaRatioVO prdOrgEmployeeEqvaRatioVO : eqvaRatioListByDate) {
            // 截取开始时间-结束时间
            dealDate(prdOrgEmployeeEqvaRatioVO, startDate, endDate);
            // 计算开始时间-结束时间的天数
//                        long daysBetween = ChronoUnit.DAYS.between(prdOrgEmployeeEqvaRatioVO.getStartDate(), prdOrgEmployeeEqvaRatioVO.getEndDate());

            // 1.该资源时间段内的应该工作天数
            long workDay = vacationService.findWorkDay(prdOrgEmployeeEqvaRatioVO.getStartDate(), prdOrgEmployeeEqvaRatioVO.getEndDate());
            log.info("开始时间:" + prdOrgEmployeeEqvaRatioVO.getStartDate() + "结束时间：" + prdOrgEmployeeEqvaRatioVO.getEndDate() + "对应天数:" + workDay);
            // 获取对应的当量数计算 系数*应该工作天数*ut达标值
            BigDecimal utVal = BigDecimal.ONE;
            if (null != utMap.get(prdOrgEmployeeEqvaRatioVO.getEqvaRatio().toString())) {
                utVal = utMap.get(prdOrgEmployeeEqvaRatioVO.getEqvaRatio().toString());
            }
            BigDecimal zDl = prdOrgEmployeeEqvaRatioVO.getEqvaRatio().multiply(new BigDecimal(workDay)).multiply(utVal);
            log.info("该时间段的应有额定当量为:" + zDl);
            edDl = edDl.add(zDl);

        }

        return edDl;
    }

    @Override
    @Transactional
    public void delByRangeIds(List<Long> ids) {

        Long res = prdPerformanceExamResultDao.delByRangeIds(ids);
    }


    private static Map<String, BigDecimal> getStringBigDecimalMap() {
        Map<String, BigDecimal> utMap = new HashMap<>();
        // p0
        utMap.put("0.20", new BigDecimal("1"));
        // p1
        utMap.put("0.50", new BigDecimal("0.95"));
        // p2
        utMap.put("0.60", new BigDecimal("0.93"));
        // p3
        utMap.put("0.80", new BigDecimal("0.90"));
        // p4
        utMap.put("1.00", new BigDecimal("0.90"));
        // p5
        utMap.put("1.20", new BigDecimal("0.88"));
        // p6
        utMap.put("1.50", new BigDecimal("0.88"));
        // p7
        utMap.put("1.60", new BigDecimal("0.85"));
        // p8
        utMap.put("1.90", new BigDecimal("0.85"));
        // p9
        utMap.put("2.00", new BigDecimal("0.85"));
        // p10
        utMap.put("3.00", new BigDecimal("0.85"));
        // p11
        utMap.put("3.50", new BigDecimal("0.85"));
        // p12
        utMap.put("4.00", new BigDecimal("0.85"));
        return utMap;
    }


}

