package com.elitesland.tw.tw5.server.prd.humanresources.personnel.service;

import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonCertService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonCertVO;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.convert.PersonCertConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao.PersonCertDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.PersonCertDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@RequiredArgsConstructor
@Slf4j
public class PersonCertServiceImpl implements PersonCertService {

    private final PersonCertDAO personCertDAO;

    private final FileUtil fileUtil;

    @Override
    public void saveAll(List<PersonCertVO> personCertVOList, Long personId) {
        if (personCertVOList != null) {
            if (personCertVOList.size() == 0) {
                personCertDAO.deleteAllByPersonId(personId);
            } else {
                for (PersonCertVO personCertVO : personCertVOList) {
                    if (personCertVO.getPersonId() == null) {
                        personCertVO.setPersonId(personId);
                    }
                }
                personCertDAO.saveAll(PersonCertConvert.INSTANCE.toDos(personCertVOList));
            }

        }
    }

    @Override
    public List<PersonCertVO> findAllByPersonId(Long personId) {
        List<PersonCertDO> personEduExperienceDOList = personCertDAO.findAllByPersonId(personId);
        List<PersonCertVO> certVOList = PersonCertConvert.INSTANCE.toVos(personEduExperienceDOList);
        for (PersonCertVO personCertVO : certVOList) {
            personCertVO.setCertDatas(fileUtil.getFileDatas(personCertVO.getCertCodes()));
        }
        return certVOList;
    }

    @Override
    public void deleteAllByPersonId(Long personId) {
        personCertDAO.deleteAllByPersonId(personId);
    }
}
