package com.elitesland.tw.tw5.server.prd.inv.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 发票主表
 *
 * @author zoey
 * @date 2023-12-05
 */
@Entity
@Table(name = "inv_invoice", indexes = {
        @Index(name = "idx_reim_id", columnList = "reim_id"),
        @Index(name = "idx_REIM_D_ID", columnList = "REIM_D_ID")
})
@org.hibernate.annotations.Table(appliesTo = "inv_invoice", comment = "发票主表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class InvInvoiceDO extends BaseModel implements Serializable {
    /**
     * 发票类型COM:INPUT_INV_TYPE
     */
    @Comment("发票类型COM:INPUT_INV_TYPE")
    @Column(length = 40)
    private String invType;
    /**
     * 发票状态ACC:INV_STATUS
     */
    @Comment("发票状态ACC:INV_STATUS")
    @Column(length = 40)
    private String invState;
    /**
     * 发票报销状态ACC:INV_REIMB_STATUS
     */
    @Comment("发票报销状态ACC:INV_REIMB_STATUS")
    @Column(length = 40)
    private String invReimStatus;
    /**
     * 归属人
     */
    @Comment("归属人")
    @Column()
    private Long invOwnerId;
    /**
     * 发票内容根据百望识别的发票内容，例如 餐饮、住宿等，需确认识别方式
     */
    @Comment("发票内容根据百望识别的发票内容，例如 餐饮、住宿等，需确认识别方式")
    @Column(length = 100)
    private String invLtype;
    /**
     * 百望系统发票ID
     */
    @Comment("百望系统发票ID")
    @Column()
    private Long baiwangInvId;
    /**
     * 单据主键id:关联的单据主键id
     */
    @Comment("单据主键id:关联的单据主键id")
    @Column()
    private Long billId;
    /**
     * 文件主键id:票据信息关联的票据影像文件主键id
     */
    @Comment("文件主键id:票据信息关联的票据影像文件主键id")
    @Column()
    private Long fileId;
    /**
     * 是否可抵扣:是否可抵扣，0：否，1：是
     */
    @Comment("是否可抵扣:是否可抵扣，0：否，1：是")
    @Column()
    private Integer isDeduct;
    /**
     * 抵扣税额:可抵扣税额
     */
    @Comment("抵扣税额:可抵扣税额")
    @Column()
    private BigDecimal deductTax;
    /**
     * 百望发票类型:01-增值税专用发票，02-货物运输业增值税专用发票，03-机动车销售统一发票，04-增值税普通发票，10-增值税电子普通发票，11-增值税普通发票(卷式)，14-增值税电子普通发票（通行费），15-二手车销售统一发票，1002-火车票，1003-飞机票，1004-出租车票，1005-定额发票，1006-客运发票，99-其他发票
     */
    @Comment("百望发票类型:01-增值税专用发票，02-货物运输业增值税专用发票，03-机动车销售统一发票，04-增值税普通发票，10-增值税电子普通发票，11-增值税普通发票(卷式)，14-增值税电子普通发票（通行费），15-二手车销售统一发票，1002-火车票，1003-飞机票，1004-出租车票，1005-定额发票，1006-客运发票，99-其他发票")
    @Column(length = 40)
    private String invoiceType;
    /**
     * 是否删除:是否删除，0-否，1-是
     */
    @Comment("是否删除:是否删除，0-否，1-是")
    @Column()
    private Integer isDel;
    /**
     * 有无影像:有无影像，0-无影像，1-有影像
     */
    @Comment("有无影像:有无影像，0-无影像，1-有影像")
    @Column()
    private Integer hasPicture;
    /**
     * 有无坐标:有无坐标，0-无，1-有
     */
    @Comment("有无坐标:有无坐标，0-无，1-有")
    @Column()
    private Integer hasPosition;
    /**
     * 创建时间:创建时间：yyyy-MM-dd HH:mm:ss
     */
    @Comment("创建时间:创建时间：yyyy-MM-dd HH:mm:ss")
    @Column(length = 40)
    private String baiwangCreateTime;
    /**
     * 修改时间:修改时间：yyyy-MM-dd HH:mm:ss
     */
    @Comment("修改时间:修改时间：yyyy-MM-dd HH:mm:ss")
    @Column(length = 40)
    private String baiwangUpdateTime;
    /**
     * 查验时间:查验时间：yyyy-MM-dd HH:mm:ss
     */
    @Comment("查验时间:查验时间：yyyy-MM-dd HH:mm:ss")
    @Column(length = 40)
    private String inspectionTime;
    /**
     * 查验状态ACC:INV_INSPECTION_STATUS:0-待查验，1-查验一致，2-查无此票，3-不一致，4-查验失败,5-无需查验
     */
    @Comment("查验状态ACC:INV_INSPECTION_STATUS:0-待查验，1-查验一致，2-查无此票，3-不一致，4-查验失败,5-无需查验")
    @Column()
    private Integer inspectionStatus;
    /**
     * 查验失败描述:查验失败描述
     */
    @Comment("查验失败描述:查验失败描述")
    @Column(length = 100)
    private String inspectionErrorDesc;
    /**
     * 零税率标识:1:税率栏位显示“免税”， 2:税率栏位显示“不征收”， 3:零税率
     */
    @Comment("零税率标识:1:税率栏位显示“免税”， 2:税率栏位显示“不征收”， 3:零税率")
    @Column()
    private Integer zeroTaxRateSign;
    /**
     * 百望发票状态:0：正常, 1：失控, 2：作废, 3：红冲, 4：异常
     */
    @Comment("百望发票状态:0：正常, 1：失控, 2：作废, 3：红冲, 4：异常")
    @Column()
    private Integer invoiceState;
    /**
     * 校验状态:票据数据校验状态，0-校验通过，1-校验失败，2-重复发票
     */
    @Comment("校验状态:票据数据校验状态，0-校验通过，1-校验失败，2-重复发票")
    @Column()
    private Integer verifyStatus;
    /**
     * 票据报销状态:票据使用状态 ，0-未关联，2-已关联
     */
    @Comment("票据报销状态:票据使用状态 ，0-未关联，2-已关联")
    @Column()
    private Integer reimburseStatus;
    /**
     * 归集用途类型:0：普通归集，1：审单归集，2：仅采集
     */
    @Comment("归集用途类型:0：普通归集，1：审单归集，2：仅采集")
    @Column()
    private Integer collectUseType;
    /**
     * 创建用户账号、采集人:采集人账号
     */
    @Comment("创建用户账号、采集人:采集人账号")
    @Column(length = 40)
    private String userAccount;
    /**
     * 创建用户id、采集人:采集人id
     */
    @Comment("创建用户id、采集人:采集人id")
    @Column(length = 40)
    private String userId;
    /**
     * 用户名:采集人姓名
     */
    @Comment("用户名:采集人姓名")
    @Column(length = 40)
    private String userName;
    /**
     * 组织机构id:组织结构id
     */
    @Comment("组织机构id:组织结构id")
    @Column(length = 40)
    private String orgId;
    /**
     * 组织机构名称:组织机构名称
     */
    @Comment("组织机构名称:组织机构名称")
    @Column(length = 40)
    private String orgName;
    /**
     * 所属行政区编码:所属行政区编码，增值税通用
     */
    @Comment("所属行政区编码:所属行政区编码，增值税通用")
    @Column(length = 40)
    private String administrativeDivisionNo;
    /**
     * 所属行政区名称:所属行政区名称，增值税通用
     */
    @Comment("所属行政区名称:所属行政区名称，增值税通用")
    @Column(length = 150)
    private String administrativeDivisionName;
    /**
     * 发票代码:发票代码，通用；火车票、行程单无代码，部分其他发票也无代码
     */
    @Comment("发票代码:发票代码，通用；火车票、行程单无代码，部分其他发票也无代码")
    @Column(length = 20)
    private String invoiceCode;
    /**
     * 发票号码:发票号码，通用；火车票为左上角票号，行程单为电子客票号码
     */
    @Comment("发票号码:发票号码，通用；火车票为左上角票号，行程单为电子客票号码")
    @Column(length = 20)
    private String invoiceNo;
    /**
     * 开票日期:开票日期，通用，火车票对应的是乘车日期YYYY-MM-DD
     */
    @Comment("开票日期:开票日期，通用，火车票对应的是乘车日期YYYY-MM-DD")
    @Column(length = 20)
    private String invoiceDate;
    /**
     * 购方名称:购方名称-增值税通用
     */
    @Comment("购方名称:购方名称-增值税通用")
    @Column(length = 100)
    private String purchaserName;
    /**
     * 购方税号:“购方税号，通用；机动车-购方名称及身份证号码/组织机构代码”
     */
    @Comment("购方税号:“购方税号，通用；机动车-购方名称及身份证号码/组织机构代码”")
    @Column(length = 50)
    private String purchaserTaxNo;
    /**
     * 购方开户行账户:购方开户行账户，通用，卷票无
     */
    @Comment("购方开户行账户:购方开户行账户，通用，卷票无")
    @Column(length = 150)
    private String purchaserBank;
    /**
     * 购方地址电话:购方地址电话，通用，卷票无
     */
    @Comment("购方地址电话:购方地址电话，通用，卷票无")
    @Column(length = 150)
    private String purchaserAddressPhone;
    /**
     * 销方名称:销方名称，通用
     */
    @Comment("销方名称:销方名称，通用")
    @Column(length = 100)
    private String saleName;
    /**
     * 销方税号:销方税号，通用
     */
    @Comment("销方税号:销方税号，通用")
    @Column(length = 120)
    private String saleTaxNo;
    /**
     * 销方地址电话:销方地址电话，增值税通用，卷票无
     */
    @Comment("销方地址电话:销方地址电话，增值税通用，卷票无")
    @Column(length = 150)
    private String saleAddressPhone;
    /**
     * 销方开户行账户:销方开户行账户，增值税通用，卷票无
     */
    @Comment("销方开户行账户:销方开户行账户，增值税通用，卷票无")
    @Column(length = 150)
    private String saleBank;
    /**
     * 不含税金额:不含税金额：1.增值税专/普/电：不含税总金额合计；2.机动车：不含税价
     */
    @Comment("不含税金额:不含税金额：1.增值税专/普/电：不含税总金额合计；2.机动车：不含税价")
    @Column()
    private BigDecimal totalAmount;
    /**
     * 合计税额:合计税额：1.增值税专/普/电：税额合计；2.机动车：增值税税额；3.行程单：燃油附加费
     */
    @Comment("合计税额:合计税额：1.增值税专/普/电：税额合计；2.机动车：增值税税额；3.行程单：燃油附加费")
    @Column()
    private BigDecimal totalTax;
    /**
     * 价税合计:价税合计：1.增值税专/普/电/机动车：价税合计；2.二手车：车价合计；3.卷票：合计金额；4.火车票/出租车/定额/客运发票/其他发票：金额；5.行程单：合计（票价+民航发展基金+燃油附加+其他税费）
     */
    @Comment("价税合计:价税合计：1.增值税专/普/电/机动车：价税合计；2.二手车：车价合计；3.卷票：合计金额；4.火车票/出租车/定额/客运发票/其他发票：金额；5.行程单：合计（票价+民航发展基金+燃油附加+其他税费）")
    @Column()
    private BigDecimal amountTax;
    /**
     * 价税合计_中文:价税合计_中文，增值税通用
     */
    @Comment("价税合计_中文:价税合计_中文，增值税通用")
    @Column(length = 64)
    private String amountTaxCn;
    /**
     * 其他税费:其他税费（行程单专有）
     */
    @Comment("其他税费:其他税费（行程单专有）")
    @Column()
    private BigDecimal otherTax;
    /**
     * 民航发展基金:民航发展基金（行程单专有）
     */
    @Comment("民航发展基金:民航发展基金（行程单专有）")
    @Column()
    private BigDecimal civilAviationFund;
    /**
     * 校验码:校验码，增值税普/电/卷票、行程单含有
     */
    @Comment("校验码:校验码，增值税普/电/卷票、行程单含有")
    @Column(length = 40)
    private String checkCode;
    /**
     * 税控盘号、机器码:税控盘号、机器码，增值税通用
     */
    @Comment("税控盘号、机器码:税控盘号、机器码，增值税通用")
    @Column(length = 40)
    private String machineCode;
    /**
     * 发票密文:增值税专/普/电-密码区，机动车/二手车-税控码
     */
    @Comment("发票密文:增值税专/普/电-密码区，机动车/二手车-税控码")
    @Column(length = 255)
    private String ciphertext;
    /**
     * 备注:发票备注，增值税通用
     */
    @Comment("备注:发票备注，增值税通用")
    @Column(length = 500)
    private String baiwangRemark;
    /**
     * 乘车人:乘车/机人姓名-火车票/行程单/客运发票
     */
    @Comment("乘车人:乘车/机人姓名-火车票/行程单/客运发票")
    @Column(length = 40)
    private String drawer;
    /**
     * 出发地:出发地：火车票、客运发票
     */
    @Comment("出发地:出发地：火车票、客运发票")
    @Column(length = 40)
    private String leaveCity;
    /**
     * 到站地:到达地：火车票、客运发票
     */
    @Comment("到站地:到达地：火车票、客运发票")
    @Column(length = 40)
    private String arriveCity;
    /**
     * 出发时间:出发时间：yyyy-MM-dd HH:mm，火车票的乘车时间，出租车票的上车时间
     */
    @Comment("出发时间:出发时间：yyyy-MM-dd HH:mm，火车票的乘车时间，出租车票的上车时间")
    @Column(length = 40)
    private String leaveTime;
    /**
     * 到站时间:到达时间：yyyy-MM-dd HH:mm，出租车票的下车时间
     */
    @Comment("到站时间:到达时间：yyyy-MM-dd HH:mm，出租车票的下车时间")
    @Column(length = 40)
    private String arriveTime;
    /**
     * 车次:火车票车次
     */
    @Comment("车次:火车票车次")
    @Column(length = 40)
    private String trainNumber;
    /**
     * 座位等级:火车票座位类型
     */
    @Comment("座位等级:火车票座位类型")
    @Column(length = 40)
    private String trainSeat;
    /**
     * 身份证号:身份证号（行程单）
     */
    @Comment("身份证号:身份证号（行程单）")
    @Column(length = 40)
    private String idNum;
    /**
     * 里程:里程（出租车）
     */
    @Comment("里程:里程（出租车）")
    @Column(length = 40)
    private String mileage;
    /**
     * 税率(明细最大最小税率，格式：6%~13%、13%)
     */
    @Comment("税率(明细最大最小税率，格式：6%~13%、13%)")
    @Column(length = 40)
    private String taxRate;
    /**
     * 买方单位代码,个人身份证号
     */
    @Comment("买方单位代码,个人身份证号")
    @Column(length = 40)
    private String buyerIdentification;
    /**
     * 二手车市场税号
     */
    @Comment("二手车市场税号")
    @Column(length = 40)
    private String marketTaxNo;
    /**
     * 卖方单位代码,个人身份证号
     */
    @Comment("卖方单位代码,个人身份证号")
    @Column(length = 40)
    private String sellerId;
    /**
     * 发票在影像中的旋转角度（顺时针）
     */
    @Comment("发票在影像中的旋转角度（顺时针）")
    @Column(length = 40)
    private String orientation;
    /**
     * 是否有公司印章，0：无；1：有
     */
    @Comment(" 是否有公司印章，0：无；1：有")
    @Column(length = 40)
    private String hasSeal;
    /**
     * 车牌号(出租车)
     */
    @Comment("车牌号(出租车)")
    @Column(length = 40)
    private String carNo;
    /**
     * 车架号/车辆识别代码(机动车、二手车)
     */
    @Comment("车架号/车辆识别代码(机动车、二手车)")
    @Column(length = 40)
    private String carCode;
    /**
     * 发动机号码(机动车)
     */
    @Comment("发动机号码(机动车)")
    @Column(length = 40)
    private String carEngineCode;
    /**
     * 机打号码
     */
    @Comment("机打号码")
    @Column(length = 40)
    private String machineInvoiceNo;
    /**
     * 机打代码
     */
    @Comment("机打代码")
    @Column(length = 40)
    private String machineInvoiceCode;
    /**
     * 异步查询码
     */
    @Comment("异步查询码")
    @Column(length = 40)
    private String asyncCode;
    /**
     * 发票坐标对象 该发票在文件中的位置
     */
    @Comment("发票坐标对象 该发票在文件中的位置")
    @Column(length = 40)
    private String invoicePositionX1;
    /**
     * 发票坐标对象 该发票在文件中的位置
     */
    @Comment("发票坐标对象 该发票在文件中的位置")
    @Column(length = 40)
    private String invoicePositionY1;
    /**
     * 发票坐标对象 该发票在文件中的位置
     */
    @Comment("发票坐标对象 该发票在文件中的位置")
    @Column(length = 40)
    private String invoicePositionX2;
    /**
     * 发票坐标对象 该发票在文件中的位置
     */
    @Comment("发票坐标对象 该发票在文件中的位置")
    @Column(length = 40)
    private String invoicePositionY2;
    /**
     * 发票联次
     */
    @Comment("发票联次")
    @Column(length = 40)
    private String invoiceTemplateType;
    /**
     * 发票联次名称
     */
    @Comment("发票联次名称")
    @Column(length = 40)
    private String invoiceTemplateName;
    /**
     * 发票密文
     */
    @Comment("发票密文")
    @Column(length = 400)
    private String invoiceCiphertext;
    /**
     * 主管税务机关代码
     */
    @Comment("主管税务机关代码")
    @Column(length = 40)
    private String taxAuthoritiesCode;
    /**
     * 主管税务机关名称
     */
    @Comment("主管税务机关名称")
    @Column(length = 40)
    private String taxAuthoritiesName;
    /**
     * 厂牌型号
     */
    @Comment("厂牌型号")
    @Column(length = 40)
    private String carModel;
    /**
     * 合格证号
     */
    @Comment("合格证号")
    @Column(length = 40)
    private String certificateNo;
    /**
     * 二手车市场
     */
    @Comment("二手车市场")
    @Column(length = 40)
    private String marketName;
    /**
     * 登记证号
     */
    @Comment("登记证号")
    @Column(length = 40)
    private String registrationNo;
    /**
     * 序列号
     */
    @Comment("序列号")
    @Column(length = 40)
    private String serialNum;
    /**
     * 保险费
     */
    @Comment("保险费")
    @Column()
    private BigDecimal premium;
    /**
     * 印刷序号
     */
    @Comment("印刷序号")
    @Column(length = 40)
    private String printNumber;
    /**
     * 开票时间
     */
    @Comment("开票时间")
    @Column(length = 40)
    private String invoiceTime;
    /**
     * 入口
     */
    @Comment("入口")
    @Column(length = 40)
    private String entrance;
    /**
     * 出口
     */
    @Comment("出口")
    @Column(length = 40)
    private String roadExit;
    /**
     * 高速标识
     */
    @Comment("高速标识")
    @Column(length = 40)
    private String isHighway;

    @Comment("报销表ID")
    @Column(name = "reim_id")
    private Long reimId;
    /**
     * 发票明细表ID
     */
    @Comment("报销明细表ID")
    @Column(name = "REIM_D_ID")
    private Long reimDId;
    /**
     * 已核销金额
     */
    @Comment("已核销金额")
    @Column()
    private BigDecimal writtenOffAmt;
    /**
     * 发票照片
     */
    @Comment("发票照片")
    @Column()
    private String imgContent;

    /**
     * 发票凭证
     */
    @Comment("JDE批号")
    @Column()
    private String invoiceVoucher;

    /** jde单据公司 */
    @Comment("jde单据公司")
    @Column()
    private String jdeCompany;
    /** jde单据号  */
    @Comment("jde单据号 ")
    @Column()
    private String jdeDocumentNo;
    /** jde单据类型 */
    @Comment("jde单据类型")
    @Column()
    private String jdeDocumentType;
    /** jde付款项 */
    @Comment("jde付款项")
    @Column()
    private String jdePaymentItem;
    /** jde发票凭证失败原因 */
    @Comment("jde发票凭证失败原因")
    @Column()
    private String jdeInvoiceFailReason;

    public void copy(InvInvoiceDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
