package com.elitesland.tw.tw5.server.prd.inv.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.math.BigDecimal;

/**
 * 发票商品对象（百望）
 *
 * @author zoey
 * @date 2023-07-31
 */
@Entity
@Table(name = "inv_item", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "inv_item", comment = "发票商品对象（百望）")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class InvItemDO extends BaseModel implements Serializable  {
    /** 省份 */
    @Comment("省份")
    @Column()
    private String province;
    /** 商品编码（税务局） */
    @Comment("商品编码（税务局）")
    @Column()
    private String goodsCode;
    /** 商品编码名称（税务局） */
    @Comment("商品编码名称（税务局）")
    @Column()
    private String goodsCodeName;
    /** 商品编码（TW） */
    @Comment("商品编码（TW）")
    @Column()
    private String twGoodsCode;
    /** 商品编码名称（TW） */
    @Comment("商品编码名称（TW）")
    @Column()
    private String twGoodsCodeName;
    /** 商品编号 */
    @Comment("商品编号")
    @Column()
    private String goodsNo;
    /** 商品名称 */
    @Comment("商品名称")
    @Column()
    private String goodsName;
    /** 商品税率 */
    @Comment("商品税率")
    @Column()
    private Double goodsTaxRate;
    /** 含税标志 N：不含税 Y：含税 */
    @Comment("含税标志 N：不含税 Y：含税")
    @Column()
    private String priceTaxMark;
    /** 是否使用优惠政策 0:未使用，1:使用 */
    @Comment("是否使用优惠政策 0:未使用，1:使用")
    @Column()
    private String preferentialMark;
    /** 优惠政策类型 preferentialMark=Y 必填 preferentialMark =N 不必填 */
    @Comment("优惠政策类型 preferentialMark=Y 必填 preferentialMark =N 不必填")
    @Column()
    private String preferentialType;
    /** 说商品说明 */
    @Comment("说商品说明")
    @Column()
    private String goodsDescribe;
    /** 商品简码 */
    @Comment("商品简码")
    @Column()
    private String goodsShorthand;
    /** 规格型号 */
    @Comment("规格型号")
    @Column()
    private String goodsSpecification;
    /** 计量单位 */
    @Comment("计量单位")
    @Column()
    private String goodsUnit;
    /** 商品单价 */
    @Comment("商品单价")
    @Column()
    private BigDecimal goodsPrice;
    /** 免税类型 0:正常税率；1:出口免税或其他免税优惠政策；2不征增值税；3普通零税率，默认为0 */
    @Comment("免税类型 0:正常税率；1:出口免税或其他免税优惠政策；2不征增值税；3普通零税率，默认为0")
    @Column()
    private String freeTaxType;

    public void copy(InvItemDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
