package com.elitesland.tw.tw5.server.prd.my.callback;

import com.elitesland.tw.tw5.api.prd.my.payload.UserVacationApplyDetailPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.UserVacationApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetService;
import com.elitesland.tw.tw5.server.prd.my.convert.UserVacationApplyConvert;
import com.elitesland.tw.tw5.server.prd.my.convert.UserVacationApplyDetailConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.UserVacationApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.UserVacationApplyDetailDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.UserVacationDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.UserVacationApplyDO;
import com.elitesland.tw.tw5.server.prd.my.entity.UserVacationApplyDetailDO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "RES_VACATION" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class UserVacationApplyWorkFlowCallBackController implements WorkflowCallBack {

    private final UserVacationApplyDAO userVacationApplyDAO;

    private final UserVacationApplyDetailDAO userVacationApplyDetailDAO;

    private final PmsTimesheetService timesheetService;

    private final UserVacationDAO userVacationDAO;

    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("动态指定任务负责人参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        Long applyId = Long.valueOf(businessKey);
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        UserVacationApplyPayload userVacationApplyPayload = new UserVacationApplyPayload();
        userVacationApplyPayload.setId(applyId);


        //工时操作类型
        Integer opertType = 0;
        UserVacationApplyDO applyDO = null;
        switch (procInstStatus) {
            case NOTSUBMIT://创建人提交节点
                //一般情况将单据状态变成"激活",流程状态改为未提交
                userVacationApplyPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                //删除工时
//                timesheetService.deleteVacationPrivateTimesheet(detailIdList);
                break;
            case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                userVacationApplyPayload.setProcInstStatus(ProcInstStatus.INTERRUPT);
                //删除工时
//                timesheetService.deleteVacationPrivateTimesheet(detailIdList);
                break;
            case INVALID://仅删除流程
                userVacationApplyPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                userVacationApplyPayload.setDeleteFlag(1);
                break;
            case REJECTED://审批人拒绝，回到第一个节点
                //将单据状态变为新建状态
                userVacationApplyPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                //删除工时
//                timesheetService.deleteVacationPrivateTimesheet(detailIdList);
                break;
            case APPROVED:
                applyDO = userVacationApplyDAO.findById(applyId);
                if (!ObjectUtils.isEmpty(applyDO.getVacationId()) && !ObjectUtils.isEmpty(applyDO.getVacationDays())) {
                    userVacationDAO.updateUsedDays(applyDO.getVacationId(), applyDO.getVacationDays());
                }
                //timesheetService.generateVacationPrivateTimesheet(applyId);
                userVacationApplyPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                userVacationApplyPayload.setApprovedTime(LocalDateTime.now());
                //更新工时
//                timesheetService.updateVacationPrivateTimesheet(detailIdList);
                opertType = 1;
                break;
            case APPROVING:
                userVacationApplyPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                opertType = -1;
                break;
        }
        if (opertType >= 0) {
            List<UserVacationApplyDetailDO> vacationApplyDetailDOS = userVacationApplyDetailDAO.findByApplyId(applyId);
            List<UserVacationApplyDetailPayload> detailPayloads = UserVacationApplyDetailConvert.INSTANCE.dosToPayloads(vacationApplyDetailDOS);
            if (applyDO == null) {
                applyDO = userVacationApplyDAO.findById(applyId);
            }
            UserVacationApplyPayload applyPayload = UserVacationApplyConvert.INSTANCE.doToPayload(applyDO);
            applyPayload.setApplyDetailPayloadList(detailPayloads);
            //操作工时
            timesheetService.updateVacationPrivateTimesheet(applyPayload, opertType);
        }
        userVacationApplyDAO.updateProcData(userVacationApplyPayload);
        return WorkflowResult.success(null);
    }
}
